/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.MultiPrinterPane;
import com.floreantpos.config.ui.PrinterGroupView;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.KitchenStickerPaperSize;
import com.floreantpos.model.ext.PaperSize;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PrintConfigurationView
extends ConfigurationView {
    public static final String AUTO_PRINT_RECEIPT = "auto_print_receipt";
    private JComboBox<PaperSize> a;
    private JComboBox<KitchenStickerPaperSize> b;
    private PosPrinters c;
    private Terminal d;
    private JCheckBox e;
    private PrinterGroupView f;

    public PrintConfigurationView() {
        this(Application.getInstance().getTerminal());
    }

    public PrintConfigurationView(Terminal terminal) {
        this.d = terminal;
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_PRINT;
    }

    @Override
    public void initialize() throws Exception {
        Object object;
        if (this.isInitialized()) {
            return;
        }
        this.c = PosPrinters.load(this.d);
        this.a();
        String string = this.d.getProperty("report.paper_size");
        if (StringUtils.isNotEmpty((String)string)) {
            object = PaperSize.valueOf(string);
            this.a.setSelectedItem(object);
        }
        if (StringUtils.isNotEmpty((String)(object = this.d.getProperty("kitchen.sticker.paper_size")))) {
            KitchenStickerPaperSize kitchenStickerPaperSize = KitchenStickerPaperSize.fromName((String)object);
            this.b.setSelectedItem((Object)kitchenStickerPaperSize);
        }
        this.e.setSelected(this.d.isAutoPrintReceipt());
        this.setInitialized(true);
    }

    @Override
    public boolean save() throws Exception {
        TerminalDAO.getInstance().refresh(this.d);
        PaperSize paperSize = (PaperSize)((Object)this.a.getSelectedItem());
        this.d.addProperty("report.paper_size", paperSize.name());
        KitchenStickerPaperSize kitchenStickerPaperSize = (KitchenStickerPaperSize)((Object)this.b.getSelectedItem());
        this.d.addProperty("kitchen.sticker.paper_size", kitchenStickerPaperSize.name());
        this.d.setAutoPrintReceipt(this.e.isSelected());
        TerminalDAO.getInstance().performBatchSave(this.f.getEditedGroups().toArray());
        TerminalDAO.getInstance().update(this.d);
        return true;
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][grow,fill]", ""));
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("PrintConfigurationView.8"));
        MultiPrinterPane multiPrinterPane = new MultiPrinterPane(Messages.getString("PrintConfigurationView.1"), this.c.getKitchenPrinters(), this.d);
        jPanel.add((Component)multiPrinterPane, "cell 0 1 2 1, h 250!, grow");
        this.f = new PrinterGroupView(Messages.getString("PrintConfigurationView.0"));
        this.f.setPreferredSize(new Dimension(0, 400));
        jPanel.add((Component)this.f, "cell 0 2 2 1,grow,h 250!,wrap");
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(Messages.getString("PrintConfigurationView.10"));
        jPanel.add((Component)jLabel2, "cell 0 3, growx");
        this.a = new JComboBox<PaperSize>(PaperSize.values());
        jPanel.add(this.a, "cell 1 3, w 250! ,wrap");
        JLabel jLabel3 = new JLabel(Messages.getString("PrintConfigurationView.100"));
        jPanel.add((Component)jLabel3, "cell 0 4, growx");
        this.b = new JComboBox<KitchenStickerPaperSize>(KitchenStickerPaperSize.values());
        jPanel.add(this.b, "cell 1 4, w 250! ,wrap");
        this.e = new JCheckBox(Messages.getString("PrintConfigurationView.16"));
        jPanel.add((Component)this.e, "cell 0 5,growx");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
    }
}

