/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.mailservices;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.mailservices.MailAttachment;
import com.floreantpos.model.MailTemplate;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.MailTemplateUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.sendgrid.Attachments;
import com.sendgrid.Content;
import com.sendgrid.Email;
import com.sendgrid.Mail;
import com.sendgrid.Method;
import com.sendgrid.Request;
import com.sendgrid.Response;
import com.sendgrid.SendGrid;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MailService {
    private static String a = "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";
    private static String b = "noreply@orocube.com";

    public static void setApiKey(String string) {
        a = string;
    }

    public static void setSenderEmail(String string) {
        b = string;
    }

    public static void sendTicket(String string, Ticket ticket) throws Exception {
        if (!MailService.isValidEmail(string)) {
            throw new PosException(Messages.getString("MailService.3"));
        }
        DataProvider.get().refreshStore();
        Store store = DataProvider.get().getStore();
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
        String string2 = MailTemplateUtil.getTemplate(store, MailTemplate.ReceiptTemplate.getSubjectKey());
        String string3 = MailTemplateUtil.getTemplate(store, MailTemplate.ReceiptTemplate.getBodyKey());
        string2 = MailTemplateUtil.process(string2, hashMap);
        string3 = MailTemplateUtil.process(string3, hashMap);
        byte[] byArray = ReceiptPrintService.createPDFStream(ticket);
        if (!MailService.sendMail(string, string2, string3, string2, "TICKET_RECEIPT_" + ticket.getId() + ".pdf", byArray)) {
            throw new PosException(Messages.getString("MailService.8"));
        }
    }

    public static void sendTransaction(String string, PosTransaction posTransaction) throws Exception {
        if (!MailService.isValidEmail(string)) {
            throw new PosException(Messages.getString("MailService.3"));
        }
        DataProvider.get().refreshStore();
        Store store = DataProvider.get().getStore();
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.6"), true, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        Ticket ticket = posTransaction.getTicket();
        HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
        String string2 = MailTemplateUtil.getTemplate(store, MailTemplate.ReceiptTemplate.getSubjectKey());
        String string3 = MailTemplateUtil.getTemplate(store, MailTemplate.ReceiptTemplate.getBodyKey());
        string2 = MailTemplateUtil.process(string2, hashMap);
        string3 = MailTemplateUtil.process(string3, hashMap);
        byte[] byArray = ReceiptPrintService.createPDFStream(posTransaction);
        if (!MailService.sendMail(string, string2, string3, string2, "TICKET_RECEIPT_" + posTransaction.getTicket().getId() + ".pdf", byArray)) {
            throw new PosException(Messages.getString("MailService.8"));
        }
    }

    public static boolean isValidEmail(String string) {
        Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$", 2);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public static boolean sendMail(String string, String string2, String string3) {
        return MailService.sendMail(string, string2, string3, null, null, null);
    }

    public static boolean sendMail(String string, String string2, String string3, String string4, String string5, byte[] byArray) {
        return MailService.sendMail(string, string2, string3, string4, string5, byArray, "application/pdf");
    }

    public static boolean sendMailWithAttchments(String string, String string2, String string3, List<MailAttachment> list) {
        try {
            MailAttachment mailAttachment2;
            if (StringUtils.isEmpty((String)b) || StringUtils.isEmpty((String)a)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MailService.6"));
                return false;
            }
            SendGrid sendGrid = new SendGrid(a);
            Email email = new Email(b);
            Email email2 = new Email(string);
            Content content = new Content("text/html", string3);
            Mail mail = new Mail(email, string2, email2, content);
            if (list != null && list.size() > 0) {
                for (MailAttachment mailAttachment2 : list) {
                    if (mailAttachment2.getAttachment() == null) continue;
                    Attachments attachments = new Attachments();
                    Base64 base64 = new Base64();
                    String string4 = base64.encodeAsString(mailAttachment2.getAttachment());
                    attachments.setContent(string4);
                    attachments.setType("application/pdf");
                    attachments.setFilename(mailAttachment2.getFileName());
                    attachments.setDisposition("attachment");
                    attachments.setContentId(mailAttachment2.getFileName());
                    mail.addAttachments(attachments);
                }
            }
            Request request = new Request();
            request.setMethod(Method.POST);
            request.setEndpoint("mail/send");
            request.setBody(mail.build());
            mailAttachment2 = sendGrid.api(request);
            PosLog.debug(MailService.class, "SendGrid mail send response code: " + mailAttachment2.getStatusCode());
            PosLog.debug(MailService.class, "SendGrid mail send response header: " + mailAttachment2.getHeaders());
            PosLog.info(MailService.class, Messages.getString("MailService.11"));
            return true;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static boolean sendMail(String string, String string2, String string3, String string4, String string5, byte[] byArray, String string6) {
        try {
            String string7;
            Object object;
            Element element22;
            if (StringUtils.isEmpty((String)b) || StringUtils.isEmpty((String)a)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MailService.6"));
                return false;
            }
            SendGrid sendGrid = new SendGrid(a);
            Email email = new Email(b);
            Email email2 = new Email(string);
            ArrayList<Attachments> arrayList = new ArrayList<Attachments>();
            Document document = Jsoup.parse((String)string3);
            Elements elements = document.select("img");
            for (Element element22 : elements) {
                object = element22.attr("src");
                String string82 = ((String)object).substring(((String)object).indexOf("base64,") + 7, ((String)object).length() - 1);
                string7 = RandomStringUtils.random((int)5, (boolean)true, (boolean)true);
                element22.attr("src", "cid:" + string7);
                element22.removeAttr("width");
                element22.removeAttr("height");
                Attachments attachments = new Attachments();
                attachments.setContent(string82);
                attachments.setType("image/png");
                attachments.setFilename(string7);
                attachments.setDisposition("inline");
                attachments.setContentId(string7);
                arrayList.add(attachments);
            }
            string3 = document.html();
            Iterator iterator = new Content("text/html", string3);
            element22 = new Mail(email, string2, email2, (Content)iterator);
            for (Attachments attachments : arrayList) {
                element22.addAttachments(attachments);
            }
            if (byArray != null) {
                object = new Attachments();
                Base64 base64 = new Base64();
                string7 = base64.encodeAsString(byArray);
                object.setContent(string7);
                object.setType(string6);
                object.setFilename(string5);
                object.setDisposition("attachment");
                object.setContentId(string4);
                element22.addAttachments((Attachments)object);
            }
            object = new Request();
            object.setMethod(Method.POST);
            object.setEndpoint("mail/send");
            object.setBody(element22.build());
            Response response = sendGrid.api((Request)object);
            PosLog.debug(MailService.class, "SendGrid mail send response code: " + response.getStatusCode());
            PosLog.debug(MailService.class, "SendGrid mail send response header: " + response.getHeaders());
            PosLog.info(MailService.class, Messages.getString("MailService.11"));
            return true;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void doSendEmailPosLogFile(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.getString("data");
            PosLog.debug(MailService.class, "Request received: " + string);
            if (StringUtils.isEmpty((String)string2)) {
                PosLog.error(MailService.class, Messages.getString("MailService.4"));
                return;
            }
            String string3 = VersionInfo.getAppName() + ".log";
            File file = new File(System.getProperty("user.home") + "\\" + string3);
            if (!file.exists()) {
                PosLog.error(MailService.class, Messages.getString("MailService.15"));
                return;
            }
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            String string4 = VersionInfo.getAppName() + " log";
            String string5 = "<html><body>Terminal no: " + terminal.getId() + "<br/>Terminal name: " + terminal.getName() + "</body></html>";
            MailService.sendMail(string2, string4, string5, string3, string3, FileUtils.readFileToByteArray((File)file), "text/plain");
        }
        catch (Exception exception) {
            PosLog.error(MailService.class, exception.getMessage());
        }
    }
}

