/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ShutDownAction;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.AbstractFloreantPlugin;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.licensing.PluginListDialog;
import com.floreantpos.licensing.ProductLicenseInfo;
import com.floreantpos.main.Application;
import com.floreantpos.main.ProcessUtil;
import com.floreantpos.main.update.UpdateManager;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CronJobDAO;
import com.floreantpos.model.util.CacheRefreshListener;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.GlassPane;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.FooterPanel;
import com.floreantpos.ui.RefreshableTicketList;
import com.floreantpos.ui.dialog.AutoLogOffAlertDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.SuperAdminPassDialog;
import com.floreantpos.ui.kitchendisplay.LineDisplayWindow;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.LoginView;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.SwitchboardView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.floreantpos.webservice.PosWebService;
import com.orocube.common.about.dialog.OroCommonLicenceActivationDialog;
import com.orocube.common.util.TerminalUtil;
import com.orocube.common.util.TicketStatus;
import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.ui.LicenseSelectionListener;
import com.orocube.licensemanager.ui.PluginMessageDialog;
import com.orocube.rest.service.mqtt.OroMqttDataListener;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.lang.StringUtils;

public class PosWindow
extends JFrame
implements CacheRefreshListener,
ProgressObserver,
OroMqttDataListener,
WindowListener {
    private static final String a = Messages.getString("PosWindow.4");
    private static final String b = "extendedstate";
    private static final String c = "wlocy";
    private static final String d = "wlocx";
    private static final String e = "wheight";
    private static final String f = "wwidth";
    private GlassPane g;
    private JLabel h;
    private JLabel i;
    private PosBlinkButton j;
    private Timer k;
    private Timer l;
    private final AutoLogoffHandler m = new AutoLogoffHandler();
    private JPanel n;
    private JSeparator o;
    private JButton p;
    private final CircularFifoQueue<Ticket> q = new CircularFifoQueue(20);
    private JLabel r;
    private JLabel s;
    private JSeparator t;
    private FooterPanel u;

    public void initComponents() {
        this.setIconImage(Application.getApplicationIcon().getImage());
        this.g = new GlassPane();
        this.g.setOpacity(0.6f);
        this.setGlassPane(this.g);
        this.h = new JLabel();
        this.u = new FooterPanel();
        Font font = this.h.getFont().deriveFont(1, PosUIManager.getFontSize(10));
        this.i = new JLabel("");
        this.i.setForeground(Color.RED);
        this.j = new PosBlinkButton(Messages.getString("NewOrderReceived"));
        this.j.setPreferredSize(PosUIManager.getSize(0, 20));
        this.i.setFont(font);
        this.j.setFont(font);
        this.n = this.u.getMessagePanel();
        this.n.add(this.i);
        this.p = new JButton();
        this.p.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.INFO, (float)12.0f));
        this.p.setToolTipText(Messages.getString("PosWindow.1"));
        this.n.add(this.p);
        this.updateVisibilityOfLicenceInfo(false);
        this.p.addActionListener(actionEvent -> this.a());
        this.t = new JSeparator(1);
        this.t.setVisible(false);
        this.s = new JLabel();
        this.n.add(this.s);
        this.n.add((Component)this.t, "growy");
        this.r = new JLabel();
        this.n.add(this.r);
        this.o = new JSeparator(1);
        this.n.add((Component)this.o, "growy");
        this.getContentPane().add((Component)this.u, "South");
        this.c();
        DataProvider.get().addCacheRefreshListener(this);
    }

    public FooterPanel getStatusBar() {
        return this.u;
    }

    private void a() {
        try {
            Application.getInstance().initLicense(TerminalUtil.getSystemUID());
            final ArrayList<AbstractFloreantPlugin> arrayList = new ArrayList<AbstractFloreantPlugin>();
            List<AbstractFloreantPlugin> list = ExtensionManager.getBusinessPlugins();
            if (list != null) {
                for (AbstractFloreantPlugin object : list) {
                    ProductLicenseInfo productLicenseInfo;
                    if (object.getLicense() == null || object.getLicense().getExpiryDate() == null || !(productLicenseInfo = new ProductLicenseInfo(object.getLicense())).isExpired()) continue;
                    arrayList.add(object);
                }
            }
            if (arrayList.size() > 0) {
                final BusyDialog busyDialog = new BusyDialog();
                busyDialog.setCaption(Messages.getString("CheckingLicenseForPlugins"));
                SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
                    boolean a = false;

                    @Override
                    protected Void doInBackground() throws Exception {
                        for (AbstractFloreantPlugin abstractFloreantPlugin : arrayList) {
                            try {
                                OroLicense oroLicense = OroCommonLicenceActivationDialog.loadAndValidateOnlineLicense((OroLicense)abstractFloreantPlugin.getLicense());
                                if (oroLicense == null || !oroLicense.isValid()) continue;
                                abstractFloreantPlugin.setLicense(oroLicense);
                                this.a = true;
                            }
                            catch (Exception exception) {
                                PosLog.error(this.getClass(), exception.getMessage());
                            }
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        busyDialog.dispose();
                        if (this.a) {
                            PosWindow.this.f();
                        }
                        PosWindow.this.b();
                    }
                };
                swingWorker.execute();
                busyDialog.open();
            } else {
                this.b();
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void b() {
        PluginListDialog pluginListDialog = new PluginListDialog(Messages.getString("LicenseStatus"));
        pluginListDialog.setSize(PosUIManager.getSize(600, 500));
        pluginListDialog.open();
    }

    public void initTimers() {
        this.u.initTimers();
        if (TerminalConfig.isCheckUpdateOnStartUp()) {
            this.l = new Timer(900000, new UpdateCheckHandler());
            this.l.start();
        }
    }

    private void c() {
        this.addWindowListener(this);
        this.i.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PosWindow.this.d();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(mouseEvent);
                PosWindow.this.i.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                PosWindow.this.i.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.j.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PosWindow.this.e();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PosWindow.this.j.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PosWindow.this.j.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isAltDown() && keyEvent.isShiftDown() && keyEvent.isControlDown() && keyEvent.getKeyCode() == 80) {
                    SuperAdminPassDialog superAdminPassDialog = new SuperAdminPassDialog();
                    superAdminPassDialog.pack();
                    superAdminPassDialog.open();
                }
            }
        });
    }

    public void rendererUserInfo() {
        this.u.updateUserInfo();
    }

    public void setRestaurantName(String string) {
        this.u.updateStoreName(string);
    }

    public void setStatus(String string) {
        this.h.setText(string);
    }

    public void setupSizeAndLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(AppConfig.getInt(f, (int)dimension.getWidth()), AppConfig.getInt(e, (int)dimension.getHeight()));
        this.setLocation(AppConfig.getInt(d, dimension.width - this.getWidth() >> 1), AppConfig.getInt(c, dimension.height - this.getHeight() >> 1));
        this.setMinimumSize(new Dimension(1024, 724));
        this.setDefaultCloseOperation(0);
        int n = AppConfig.getInt(b, -1);
        if (n != -1) {
            this.setExtendedState(n);
        }
    }

    public void enterFullScreenMode() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dimension);
        this.setExtendedState(6);
        this.setUndecorated(true);
        this.setLocation(0, 0);
    }

    public void leaveFullScreenMode() {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0];
        this.setUndecorated(false);
        graphicsDevice.setFullScreenWindow(null);
    }

    public void saveSizeAndLocation() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        AppConfig.putInt(f, n);
        AppConfig.putInt(e, n2);
        Point point = this.getLocationOnScreen();
        AppConfig.putInt(d, point.x);
        AppConfig.putInt(c, point.y);
        AppConfig.putInt(b, this.getExtendedState());
        Window[] windowArray = Window.getWindows();
        boolean bl = false;
        for (Window window : windowArray) {
            if (!(window instanceof LineDisplayWindow)) continue;
            LineDisplayWindow lineDisplayWindow = (LineDisplayWindow)window;
            bl = lineDisplayWindow.isVisible();
            lineDisplayWindow.saveSizeAndLocation();
        }
        AppConfig.put("ldwvisible", bl);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.u.startOrStopTimer(bl);
    }

    public void startAutoLogoffTimer() {
        this.stopAutoLogoffTimer();
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        if (terminal != null && terminal.isIsAutoLogOffEnabled().booleanValue()) {
            this.k = new Timer(terminal.getAutoLogOffSec() * 1000, this.m);
            this.k.start();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.m, 131128L);
        }
    }

    public void stopAutoLogoffTimer() {
        if (this.k != null && this.k.isRunning()) {
            this.k.stop();
        }
        this.k = null;
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.m);
    }

    public void checkForUpdate() {
        UpdateManager updateManager = Application.getInstance().getUpdateManager();
        if (!updateManager.isUpdateAvailable()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Messages.getString("PosWindow.0"));
        this.i.setText(stringBuilder.toString());
        if (this.l != null) {
            this.l.stop();
        }
    }

    public void setGlassPaneVisible(boolean bl) {
        this.g.setVisible(bl);
    }

    public void updateVisibilityOfLicenceInfo(boolean bl) {
        if (this.p != null) {
            this.p.setVisible(bl);
        }
    }

    public void updateVissabityOfProgressObserver(boolean bl) {
        if (this.r != null) {
            this.r.setVisible(bl);
        }
    }

    public void updateView() {
        CronJob cronJob;
        this.u.updateTerminalId();
        this.r.setVisible(false);
        this.t.setVisible(false);
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        if (terminal != null && (cronJob = CronJobDAO.getInstance().get("cloud_auto_sync")) != null) {
            Boolean bl = terminal.isMasterTerminal() != false && PosWebService.get().isConnected() && cronJob.isActive() != false;
            this.r.setVisible(bl);
            this.t.setVisible(bl != false && StringUtils.isNotBlank((String)this.r.getText()));
        }
        this.u.updateLicenseStatus();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        new ShutDownAction().actionPerformed(null);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private void d() {
        try {
            if (this.l != null && this.l.isRunning()) {
                this.l.stop();
            }
            Application.getInstance().checkForUpdate();
            if (this.l != null) {
                this.l.start();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void ticketReceived(List<Ticket> list) {
        boolean bl = false;
        for (Ticket ticket : list) {
            if (ticket.getTicketStatus() != TicketStatus.Pending && !ticket.isShowNewOrderNotification()) continue;
            if (!this.q.contains((Object)ticket)) {
                this.q.add((Object)ticket);
                bl = true;
            }
            ticket.setShowNewOrderNotification(false);
        }
        if (!bl) {
            return;
        }
        this.n.add(this.j);
        this.n.add((Component)this.o, "growy");
        this.n.revalidate();
        this.n.repaint();
        this.j.setText(Messages.getString("NewOrderReceived") + " (" + this.q.size() + ")");
        this.j.setBlinking(true);
        this.j.setVisible(true);
        this.toFront();
        POSUtil.beep();
    }

    @Override
    public void cacheRefreshed() {
        this.updateView();
    }

    private void e() {
        try {
            RootView rootView = RootView.getInstance();
            IView iView = rootView.getCurrentView();
            User user = Application.getCurrentUser();
            if (user == null || iView == null || iView instanceof LoginView) {
                OrderType orderType = DataProvider.get().getDeliveryOrderType();
                if (orderType != null) {
                    TerminalConfig.setDefaultView(orderType.getId());
                    LoginView.getInstance().doLogin();
                } else {
                    LoginView.getInstance().doLogin();
                    if (rootView.getCurrentView() != null && !SwitchboardView.VIEW_NAME.equals(rootView.getCurrentView().getViewName())) {
                        rootView.showView(SwitchboardView.getInstance());
                    }
                }
            }
            iView = rootView.getCurrentView();
            user = Application.getCurrentUser();
            if (user == null || iView == null || iView instanceof LoginView) {
                return;
            }
            int n = 1;
            for (Ticket ticket : this.q) {
                ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                arrayList.add(ticket);
                OrderInfoView orderInfoView = new OrderInfoView(arrayList);
                OrderInfoDialog orderInfoDialog = new OrderInfoDialog(orderInfoView);
                orderInfoDialog.setTitle(Messages.getString("PosWindow.8") + " " + n++);
                orderInfoDialog.updateView();
                orderInfoDialog.pack();
                orderInfoDialog.setSize(orderInfoDialog.getSize().width + 50, PosUIManager.getSize(650));
                orderInfoDialog.setLocationRelativeTo(Application.getPosWindow());
                orderInfoDialog.setVisible(true);
            }
            IView iView2 = RootView.getInstance().getCurrentView();
            if (iView2 instanceof RefreshableTicketList) {
                iView2.refresh();
            }
            this.q.clear();
            this.j.setVisible(false);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void clearMqttTickets() {
        this.q.clear();
        this.j.setVisible(false);
    }

    private void f() {
        try {
            PluginMessageDialog.show((Component)this, (LicenseSelectionListener)new LicenseSelectionListener(){

                public void restartPOS(boolean bl) {
                    try {
                        ProcessUtil.restart();
                    }
                    catch (Exception exception) {
                        PosLog.error(this.getClass(), exception);
                    }
                }

                public void licenseFileSelected(File file) throws Exception {
                }

                public OroLicense getLicense() throws Exception {
                    return null;
                }
            }, null, (String)Messages.getString("OroCommonLicenceActivationDialog.7"), (boolean)false);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    @Override
    public void progress(int n) {
    }

    @Override
    public void progress(String string) {
        this.r.setText(string);
        this.t.setVisible(Boolean.TRUE);
    }

    @Override
    public void progress(int n, String string) throws Exception {
        String string2 = string + " " + n + "%";
        PosLog.debug(this.getClass(), string2);
        this.r.setText(a + ": " + string2);
        this.t.setVisible(Boolean.TRUE);
    }

    @Override
    public void progressComplete(boolean bl) {
        if (bl) {
            this.r.setText(a + ":  \u2714");
            this.r.setToolTipText(a + Messages.getString("PosWindow.5"));
        } else {
            this.r.setText(a + ":  \u2716");
            this.r.setToolTipText(a + Messages.getString("PosWindow.7"));
        }
    }

    @Override
    public Component getParentComponent() {
        return null;
    }

    public void updateStatusBarFooterMessage(String string) {
        this.s.setText(string);
        this.s.setForeground(Color.RED);
    }

    @Override
    public void mqttConnected() {
        this.u.mqttConnected();
    }

    @Override
    public void mqttConnectionLost() {
        this.u.mqttConnectionLost();
    }

    private class AutoLogoffHandler
    implements AWTEventListener,
    ActionListener {
        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            this.reset();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PosWindow.this.isShowing()) {
                return;
            }
            if (PosGuiUtil.isModalDialogShowing()) {
                return;
            }
            if (PosWindow.this.k != null && PosWindow.this.k.isRunning()) {
                PosWindow.this.k.stop();
            }
            AutoLogOffAlertDialog autoLogOffAlertDialog = new AutoLogOffAlertDialog();
            autoLogOffAlertDialog.pack();
            autoLogOffAlertDialog.open();
            if (autoLogOffAlertDialog.isCanceled()) {
                PosWindow.this.k.restart();
                return;
            }
            Application.getInstance().doAutoLogout();
        }

        public void reset() {
            if (PosWindow.this.k != null && PosWindow.this.k.isRunning()) {
                PosWindow.this.k.restart();
            }
        }
    }

    private class UpdateCheckHandler
    implements ActionListener {
        private UpdateCheckHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PosWindow.this.checkForUpdate();
        }
    }
}

