/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.floreantpos.PosLog;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseModifierGroup;
import com.floreantpos.ui.model.ModifierPricingRule;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"displayName"})
@XmlRootElement
public class ModifierGroup
extends BaseModifierGroup
implements PropertyContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;
    public static final String JSON_PROP_ENABLE_GROUP_PRICE = "enableGroupPricing";
    private Map<Integer, Double> priceMap;
    private ArrayList<ModifierPricingRule> pricingRules;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public ModifierGroup() {
    }

    public ModifierGroup(String string) {
        super(string);
    }

    @Override
    public String toString() {
        return super.getName();
    }

    public String getDisplayName() {
        return super.getName();
    }

    public String getUniqueId() {
        return ("modifiergroup_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getProperties(), JsonObject.class);
        }
        return this.propertiesContainer;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    public void setEnableGroupPricing(boolean bl) {
        this.addProperty(JSON_PROP_ENABLE_GROUP_PRICE, String.valueOf(bl));
    }

    public boolean isEnableGroupPricing() {
        return this.hasProperty(JSON_PROP_ENABLE_GROUP_PRICE) && this.getBooleanProperty(JSON_PROP_ENABLE_GROUP_PRICE, false) != false;
    }

    public boolean hasPriceRules() {
        return this.isEnableGroupPricing() && this.hasProperty("priceRules");
    }

    public Double getPrice(Integer n) {
        if (!this.hasPriceRules()) {
            return null;
        }
        if (this.priceMap != null) {
            return this.priceMap.get(n);
        }
        this.priceMap = new HashMap<Integer, Double>();
        List list = this.getPriceRules();
        if (list != null && list.size() > 0) {
            for (ModifierPricingRule modifierPricingRule : list) {
                for (int i = modifierPricingRule.getFromQty().intValue(); i <= modifierPricingRule.getToQty(); ++i) {
                    this.priceMap.put(i, modifierPricingRule.getPrice());
                }
            }
        }
        return this.priceMap.get(n);
    }

    public List getPriceRules() {
        try {
            JsonNode jsonNode;
            String string;
            if (this.pricingRules == null) {
                this.pricingRules = new ArrayList();
            }
            if (StringUtils.isEmpty((String)(string = this.getProperties()))) {
                return this.pricingRules;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode2 = objectMapper.readTree(string);
            if (jsonNode2 != null && (jsonNode = jsonNode2.findValue("priceRules")) != null) {
                this.pricingRules = (ArrayList)objectMapper.readValue(jsonNode.toString(), (TypeReference)new TypeReference<List<ModifierPricingRule>>(){});
                return this.pricingRules;
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return this.pricingRules;
    }

    public void setInstruction(String string) {
        this.addProperty("instruction", string);
    }

    @JsonIgnore
    public String getInstruction() {
        return this.getProperty("instruction");
    }
}

