/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseSiiopaCustomer;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringUtils;

public class SiiopaCustomer
extends BaseSiiopaCustomer
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private Boolean selected;
    private transient JsonObject propertiesContainer;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    public SiiopaCustomer() {
    }

    public SiiopaCustomer(String string) {
        super(string);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @Override
    public String toString() {
        String string = this.getName();
        if (string == null) {
            string = this.getEmail();
        }
        return string;
    }

    public ImageIcon getImage() {
        return null;
    }

    @Override
    public String getName() {
        String string = super.getFirstName();
        if (StringUtils.isNotEmpty((String)super.getLastName())) {
            string = string + " " + super.getLastName();
        }
        return string;
    }

    @Override
    public void setMobileNo(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            string = string.replaceAll("(\\+)?\\D", "$1");
        }
        super.setMobileNo(string);
    }

    @Override
    public void setWorkPhoneNo(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            string = string.replaceAll("(\\+)?\\D", "$1");
        }
        super.setWorkPhoneNo(string);
    }

    @Override
    public void setHomePhoneNo(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            string = string.replaceAll("(\\+)?\\D", "$1");
        }
        super.setHomePhoneNo(string);
    }

    public Boolean isSelected() {
        return this.selected == null ? Boolean.FALSE : this.selected;
    }

    public void setSelected(Boolean bl) {
        this.selected = bl;
    }

    public CustomerGroup getCustomerGroup() {
        if (StringUtils.isNotEmpty((String)this.getCustomerGroupId())) {
            return CustomerGroupDAO.getInstance().get(this.getCustomerGroupId());
        }
        return null;
    }

    public void setCustomerGroup(CustomerGroup customerGroup) {
        String string = null;
        if (customerGroup != null) {
            string = customerGroup.getId();
        }
        super.setCustomerGroupId(string);
    }

    public void setEncryptedSecretCode(String string) {
        try {
            this.setSecretCode(AESencrp.encrypt(string));
        }
        catch (Exception exception) {
            this.setSecretCode(string);
        }
    }

    public String getUnencryptedSecretCode() {
        String string = this.getSecretCode();
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                string = AESencrp.decrypt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public void setEncryptedPin(String string) {
        try {
            this.setPin(AESencrp.encrypt(string));
        }
        catch (Exception exception) {
            this.setPin(string);
        }
    }

    public String getUnencryptedPin() {
        String string = this.getPin();
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                string = AESencrp.decrypt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        if (StringUtils.isNotEmpty((String)string)) {
            this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        }
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        if (StringUtils.isNotEmpty((String)string2)) {
            this.propertiesContainer.addProperty(string, string2);
        }
    }

    public String getProperty(String string) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }
}

