/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.PosLog;
import com.floreantpos.model.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class WorkingHours {
    public static final String SUNDAY = "Sunday";
    public static final String MONDAY = "Monday";
    public static final String TUESDAY = "Tuesday";
    public static final String WEDNESDAY = "Wednesday";
    public static final String THURSDAY = "Thursday";
    public static final String FRIDAY = "Friday";
    public static final String SATURDAY = "Saturday";
    public static String[] days = new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    public static final String OPEN = ".Open";
    public static final String START_TIME = ".StartTime";
    public static final String END_TIME = ".EndTime";
    public static final String START_DAY_OF_WEEK = "StartDayOfWeek";
    private Calendar day = Calendar.getInstance();
    private Calendar openHour;
    private Calendar endHour;
    private String openTime;
    private String endTime;

    public WorkingHours(int n, String string, String string2) {
        this.day.clear();
        this.day.set(7, n);
        this.openTime = string;
        this.endTime = string2;
        this.openHour = this.parseStringToCalendar(string);
        this.endHour = this.parseStringToCalendar(string2);
    }

    public Calendar getDay() {
        return this.day;
    }

    public void setDay(Calendar calendar) {
        this.day = calendar;
    }

    public Calendar getOpenHour() {
        return this.openHour;
    }

    public void setOpenHour(Calendar calendar) {
        this.openHour = calendar;
    }

    public Calendar getEndHour() {
        return this.endHour;
    }

    public void setEndHour(Calendar calendar) {
        this.endHour = calendar;
    }

    private Calendar parseStringToCalendar(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.clear();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm a");
            Date date = simpleDateFormat.parse(string);
            calendar.setTime(date);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return calendar;
    }

    public boolean isNull() {
        if (this.openHour == null || this.endHour == null) {
            return true;
        }
        return this.openHour.getTime() == null || this.endHour.getTime() == null;
    }

    public boolean isOpen() {
        Calendar calendar = Calendar.getInstance();
        return this.isOpen(calendar.getTime());
    }

    public boolean isOpen(Date date) {
        return this.isOpenOnDate(date, 0);
    }

    public boolean isOpenOnDate(Date date, int n) {
        boolean bl;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        boolean bl2 = bl = this.isNull() ? false : this.isOpenOnDay(calendar, calendar.get(5), n);
        if (!bl) {
            WorkingHours workingHours = this.getStoreWorkingHours(this.getPreviousWorkingDay(calendar));
            if (workingHours != null && (bl = workingHours.isOpenOnDay(calendar, calendar.get(5) - 1, n))) {
                this.endHour = workingHours.endHour;
            }
            if (!bl) {
                WorkingHours workingHours2 = this.getStoreWorkingHours(this.getNextWorkingDay(calendar));
                if (workingHours2 != null) {
                    bl = workingHours2.isOpenOnDay(calendar, calendar.get(5) + 1, n);
                }
                if (bl) {
                    this.endHour = workingHours.endHour;
                }
            }
        }
        return bl;
    }

    public boolean isOpenOnDay(Calendar calendar, int n, int n2) {
        if (this.openHour == null) {
            return false;
        }
        this.openHour.set(1, calendar.get(1));
        this.openHour.set(2, calendar.get(2));
        this.openHour.set(5, n);
        this.endHour.set(1, calendar.get(1));
        this.endHour.set(2, calendar.get(2));
        this.endHour.set(5, n);
        if (n2 != 0) {
            this.endHour.set(12, this.endHour.get(12) - n2);
        }
        int n3 = this.openHour.get(9);
        int n4 = this.endHour.get(9);
        if (n3 == 1 && n4 == 0) {
            this.endHour.set(5, this.endHour.get(5) + 1);
        } else if (n3 == n4 && this.endHour.getTime().before(this.openHour.getTime())) {
            this.endHour.set(5, this.endHour.get(5) + 1);
        }
        return DateUtil.between(this.openHour.getTime(), this.endHour.getTime(), calendar.getTime());
    }

    private int getPreviousWorkingDay(Calendar calendar) {
        int n = calendar.get(7) - 1;
        if (n < 0) {
            n = 7;
        }
        return n;
    }

    private int getNextWorkingDay(Calendar calendar) {
        int n = calendar.get(7) + 1;
        if (n > 7) {
            n = 0;
        }
        return n;
    }

    public WorkingHours getStoreWorkingHours(int n) {
        return new WorkingHours(n, this.openTime, this.endTime);
    }
}

