/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.dao.BaseAttributeGroupDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

public class AttributeGroupDAO
extends BaseAttributeGroupDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        AttributeGroup attributeGroup = (AttributeGroup)object;
        if (attributeGroup == null) {
            throw new PosException(Messages.getString("AttributeGroupDAO.0"));
        }
        attributeGroup.setDeleted(true);
        this.updateAttributeList(attributeGroup);
        this.update(attributeGroup, session);
    }

    private void updateAttributeList(AttributeGroup attributeGroup) {
        List<Attribute> list = attributeGroup.getAttributes();
        if (list != null) {
            for (Attribute attribute : list) {
                attribute.setGroup(null);
                attribute.setDeleted(true);
                AttributeDAO.getInstance().checkForeignRelation(attribute);
            }
        }
    }

    @Override
    public List<AttributeGroup> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)AttributeGroup.PROP_NAME));
            this.addDeletedFilter(criteria);
            List<AttributeGroup> list = this.cleanupDeletedAttribute(criteria.list());
            return list;
        }
    }

    private List<AttributeGroup> cleanupDeletedAttribute(List<AttributeGroup> list) {
        if (list != null) {
            list.forEach(attributeGroup -> {
                List<Attribute> list = attributeGroup.getAttributes();
                if (list != null) {
                    Iterator<Attribute> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        if (!attribute.isDeleted().booleanValue()) continue;
                        iterator.remove();
                    }
                }
            });
        }
        return list;
    }

    public void saveOrUpdateAttributeGroupList(List<AttributeGroup> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (AttributeGroup attributeGroup : list) {
                AttributeGroup attributeGroup2 = this.get(attributeGroup.getId());
                if (attributeGroup2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(attributeGroup.getLastUpdateTime(), attributeGroup2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), attributeGroup.getName() + " already updated");
                        continue;
                    }
                    long l = attributeGroup2.getVersion();
                    PropertyUtils.copyProperties((Object)attributeGroup2, (Object)attributeGroup);
                    attributeGroup2.setVersion(l);
                    attributeGroup2.setUpdateLastUpdateTime(bl);
                    attributeGroup2.setUpdateSyncTime(bl2);
                    this.update(attributeGroup2, session);
                    continue;
                }
                attributeGroup.setUpdateLastUpdateTime(bl);
                attributeGroup.setUpdateSyncTime(bl2);
                this.save(attributeGroup, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

