/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.BaseDepartmentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class DepartmentDAO
extends BaseDepartmentDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        Department department = (Department)object;
        if (department == null) {
            throw new PosException(Messages.getString("DepartmentDAO.0"));
        }
        this.checkForeignRelation(department);
        department.setDeleted(Boolean.TRUE);
        this.update(department, session);
    }

    private void checkForeignRelation(Department department) throws PosException {
        String string = department.getId();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        Object object = this.createNewSession();
        Object object2 = null;
        try {
            GenericDAO genericDAO = GenericDAO.getInstance();
            this.append(genericDAO.getForeignDataListNames((Session)object, MenuCategory.class, "departments", Department.PROP_ID, string), Messages.getString("DepartmentDAO.2"), stringBuilder, stringBuilder2);
            this.append(genericDAO.getForeignDataListNames((Session)object, OrderType.class, "departments", Department.PROP_ID, string), Messages.getString("DepartmentDAO.4"), stringBuilder, stringBuilder2);
            this.append(genericDAO.getForeignDataListNames((Session)object, Outlet.class, "departments", Department.PROP_ID, string), Messages.getString("DepartmentDAO.6"), stringBuilder, stringBuilder2);
            this.append(genericDAO.getForeignDataListNames((Session)object, SalesArea.class, SalesArea.PROP_DEPARTMENT_ID, string), Messages.getString("DepartmentDAO.7"), stringBuilder, stringBuilder2);
            this.append(genericDAO.getForeignDataListNames((Session)object, PriceRule.class, PriceRule.PROP_DEPARTMENT_ID, string), Messages.getString("DepartmentDAO.8"), stringBuilder, stringBuilder2);
            this.append(genericDAO.getForeignDataListNames((Session)object, Terminal.class, Terminal.PROP_DEPARTMENT_ID, string), Messages.getString("DepartmentDAO.9"), stringBuilder, stringBuilder2);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    object.close();
                }
            }
        }
        object = stringBuilder2.toString();
        if (StringUtils.isNotBlank((String)object)) {
            object2 = stringBuilder.toString();
            if (((String)object2).endsWith(", ")) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
            }
            throw new PosException(Messages.getString("DepartmentDAO.11") + (String)object2 + Messages.getString("DepartmentDAO.12") + (String)object2 + ".", (String)object);
        }
    }

    private void append(List<String> list, String string, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (list == null || list.isEmpty()) {
            return;
        }
        stringBuilder2.append(Messages.getString("DepartmentDAO.14") + string + ":");
        stringBuilder.append(string + ", ");
        int n = 1;
        for (String string2 : list) {
            stringBuilder2.append("\n" + n + ". " + string2);
            ++n;
        }
        stringBuilder2.append("\n");
    }

    @Override
    public List<Department> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Department initialize(Department department) {
        if (department == null || department.getId() == null) {
            return department;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)department);
            Hibernate.initialize(department.getOutlets());
            Department department2 = department;
            return department2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Department> findByOrderType(OrderType orderType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias("orderTypes", "o");
            criteria.add((Criterion)Restrictions.eq((String)"o.id", (Object)orderType.getId()));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsDepartment(OrderType orderType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (orderType != null) {
                criteria.createAlias("orderTypes", "o");
                criteria.add((Criterion)Restrictions.eq((String)"o.id", (Object)orderType.getId()));
            }
            this.addDeletedFilter(criteria);
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Department> findDepartmentbyOutlet(Outlet outlet) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            if (list == null || list.size() == 0) {
                List<Department> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Department findById(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Department.PROP_ID, (Object)string));
            this.addDeletedFilter(criteria);
            Department department = (Department)criteria.uniqueResult();
            return department;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Department> findAllUnSyncDepartment() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression simpleExpression = Restrictions.eq((String)Department.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion criterion = Restrictions.isNull((String)Department.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)criterion));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateDepartments(List<Department> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Department department : list) {
                Department department2 = this.get(department.getId());
                if (department2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(department.getLastUpdateTime(), department2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), department.getName() + " already updated");
                        continue;
                    }
                    String string = department2.getId();
                    long l = department2.getVersion();
                    PropertyUtils.copyProperties((Object)department2, (Object)department);
                    department2.setId(string);
                    department2.setVersion(l);
                    department2.setUpdateLastUpdateTime(bl);
                    department2.setUpdateSyncTime(bl2);
                    this.update(department2, session);
                    continue;
                }
                department.setVersion(0L);
                department.setUpdateLastUpdateTime(bl);
                department.setUpdateSyncTime(bl2);
                this.save(department, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

