/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.base.BaseKitchenTicketItem;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.BaseKitchenTicketItemDAO;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.ext.KitchenStatus;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class KitchenTicketItemDAO
extends BaseKitchenTicketItemDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KitchenTicketItem> find(String string, boolean bl) {
        Session session = null;
        try {
            session = this.getSession();
            List<KitchenTicketItem> list = this.find(string, bl, session);
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<KitchenTicketItem> find(String string, boolean bl, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)(bl ? KitchenTicketItem.PROP_TICKET_ITEM_MODIFIER_ID : KitchenTicketItem.PROP_TICKET_ITEM_ID), (Object)string));
        return criteria.list();
    }

    public void markVoided(String string, Double d, Session session) {
        Criteria criteria = session.createCriteria(KitchenTicketItem.class);
        criteria.add((Criterion)Restrictions.eq((String)KitchenTicketItem.PROP_TICKET_ITEM_ID, (Object)string));
        criteria.add((Criterion)Restrictions.eq((String)KitchenTicketItem.PROP_VOIDED, (Object)Boolean.FALSE));
        List list = criteria.list();
        if (list.isEmpty()) {
            return;
        }
        KitchenTicketItem kitchenTicketItem = (KitchenTicketItem)list.get(0);
        KitchenTicket kitchenTicket = kitchenTicketItem.getKitchenTicket();
        kitchenTicketItem.setVoided(true);
        KitchenTicketItemDAO.getInstance().update(kitchenTicketItem, session);
        if (kitchenTicketItem.getQuantity().compareTo(Math.abs(d)) > 0) {
            KitchenTicketItem kitchenTicketItem2 = (KitchenTicketItem)SerializationUtils.clone((Serializable)kitchenTicketItem);
            kitchenTicketItem2.setId(null);
            TicketItem ticketItem = TicketItemDAO.getInstance().get(kitchenTicketItem2.getTicketItemId());
            if (ticketItem != null) {
                Object object;
                Object object2;
                ticketItem.setQuantity(kitchenTicketItem2.getQuantity() - Math.abs(d));
                kitchenTicketItem2.setMenuItemName(ticketItem.getNameDisplay());
                String string2 = kitchenTicketItem2.getMenuItemName();
                List<TicketItemModifier> list2 = ticketItem.getTicketItemModifiers();
                if (list2 != null) {
                    object2 = ticketItem.getTicketItemModifiers().iterator();
                    while (object2.hasNext()) {
                        object = (TicketItemModifier)object2.next();
                        string2 = string2.concat("\n" + ((TicketItemModifier)object).getNameDisplay(true));
                    }
                }
                if ((object2 = ticketItem.getCookingInstructions()) != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        TicketItemCookingInstruction ticketItemCookingInstruction = (TicketItemCookingInstruction)object.next();
                        string2 = string2.concat("\n" + ticketItemCookingInstruction.getNameDisplay());
                    }
                }
                kitchenTicketItem2.setMenuItemName(string2);
            } else {
                kitchenTicketItem2.setMenuItemName(kitchenTicketItem2.getQuantity() + " " + kitchenTicketItem2.getMenuItemNameDisplay());
            }
            kitchenTicketItem2.setQuantity(kitchenTicketItem2.getQuantity() - Math.abs(d));
            kitchenTicketItem2.setVoided(false);
            kitchenTicketItem2.setVoidedItemId(string);
            kitchenTicket.addToticketItems(kitchenTicketItem2);
            KitchenTicketDAO.getInstance().update(kitchenTicket, session);
        }
    }

    public void bumpTicketItem(KitchenTicketItem kitchenTicketItem) {
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            Object object2;
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(KitchenTicketItem.class);
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicketItem.PROP_TICKET_ITEM_ID, (Object)kitchenTicketItem.getTicketItemId()));
            List list = criteria.list();
            for (Object object2 : list) {
                ((BaseKitchenTicketItem)object2).setStatus(KitchenStatus.BUMP.name());
                this.update((KitchenTicketItem)object2, session);
            }
            criteria = session.createCriteria(TicketItem.class);
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_ID, (Object)kitchenTicketItem.getTicketItemId()));
            List list2 = criteria.list();
            object2 = list2.iterator();
            while (object2.hasNext()) {
                TicketItem ticketItem = (TicketItem)object2.next();
                ticketItem.setKitchenStatusValueWithChildren(KitchenStatus.BUMP);
                TicketItemDAO.getInstance().update(ticketItem, session);
            }
            kitchenTicketItem.setStatus(KitchenStatus.BUMP.name());
            transaction.commit();
            this.createJournal(kitchenTicketItem);
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    private void createJournal(KitchenTicketItem kitchenTicketItem) {
        KitchenTicket kitchenTicket = kitchenTicketItem.getKitchenTicket();
        String string = "Item name: " + kitchenTicketItem.getMenuItemNameDisplay();
        string = string + (StringUtils.isBlank((String)kitchenTicketItem.getId()) ? " " : " ,KitchenTicket Item id: " + kitchenTicketItem.getId());
        string = string + (StringUtils.isBlank((String)kitchenTicket.getId()) ? " " : " ,KitchenTicket id: " + kitchenTicket.getId());
        ActionHistoryDAO.saveHistory(kitchenTicket.getParentTicket(), "Item bumped", string);
    }
}

