/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.Shift;
import com.floreantpos.model.dao.BaseMenuShiftDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.ShiftDAO;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class MenuShiftDAO
extends BaseMenuShiftDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.validateData((MenuShift)object, session);
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.validateData((MenuShift)object, session);
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.validateData((MenuShift)object, session);
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    private void validateData(MenuShift menuShift, Session session) {
        GenericDAO.getInstance().checkIdOrNameExists(menuShift.getId(), menuShift.getName(), MenuShift.class, session);
        if (this.menuShiftExists(menuShift.getId(), menuShift.getStartHour(), menuShift.getStartMin(), menuShift.getEndHour(), menuShift.getEndMin(), menuShift.getDaysOfWeek(), session)) {
            throw new DuplicateDataException(Messages.getString("MenuShiftDAO.0"));
        }
    }

    @Override
    public List<MenuShift> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void delete(Object object, Session session) {
        ShiftDAO.getInstance().delete(object, session);
    }

    public boolean exists(String string) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(Shift.class);
            criteria.add((Criterion)Restrictions.eq((String)Shift.PROP_NAME, (Object)string));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            throw new PosException("An error occured while trying to check price shift duplicacy", exception);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean menuShiftExists(String string, Integer n, Integer n2, Integer n3, Integer n4, String string2, Session session) throws PosException {
        SimpleExpression simpleExpression;
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        if (StringUtils.isNotEmpty((String)string)) {
            simpleExpression = Restrictions.ne((String)"id", (Object)string);
            criteria.add((Criterion)simpleExpression);
        }
        this.addDeletedFilter(criteria);
        simpleExpression = Restrictions.eq((String)MenuShift.PROP_START_HOUR, (Object)n);
        SimpleExpression simpleExpression2 = Restrictions.eq((String)MenuShift.PROP_START_MIN, (Object)n2);
        SimpleExpression simpleExpression3 = Restrictions.eq((String)MenuShift.PROP_END_HOUR, (Object)n3);
        SimpleExpression simpleExpression4 = Restrictions.eq((String)MenuShift.PROP_END_MIN, (Object)n4);
        SimpleExpression simpleExpression5 = Restrictions.eq((String)MenuShift.PROP_DAYS_OF_WEEK, (Object)string2);
        Conjunction conjunction = Restrictions.and((Criterion[])new Criterion[]{simpleExpression, simpleExpression2, simpleExpression3, simpleExpression4, simpleExpression5});
        criteria.add((Criterion)conjunction);
        List list = criteria.list();
        return list != null && list.size() > 0;
    }

    public List<MenuShift> findAllActive() {
        try (Session session = null;){
            session = this.getSession();
            List<MenuShift> list = this.findAllActive(session);
            return list;
        }
    }

    public List<MenuShift> findAllActive(Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)MenuShift.PROP_ENABLE, (Object)Boolean.TRUE));
        criteria.addOrder(Order.asc((String)MenuShift.PROP_PRIORITY));
        return criteria.list();
    }
}

