/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.dao.BaseShopFloorDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;

public class ShopFloorDAO
extends BaseShopFloorDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void updateTime(Object object) {
        ShopFloor shopFloor = (ShopFloor)object;
        if (shopFloor.getTables() != null) {
            for (ShopTable shopTable : shopFloor.getTables()) {
                super.updateTime(shopTable);
            }
        }
        super.updateTime(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ShopFloor> findAll() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)ShopFloor.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public boolean hasFloor() {
        Number number = (Number)this.getSession().createCriteria(this.getReferenceClass()).setProjection(Projections.rowCount()).uniqueResult();
        return number.intValue() != 0;
    }

    public void initializeTables(ShopFloor shopFloor) {
        if (shopFloor == null || shopFloor.getId() == null) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)shopFloor);
            Hibernate.initialize(shopFloor.getTables());
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public void delete(ShopFloor shopFloor) throws HibernateException {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.refresh(shopFloor, session);
            shopFloor.setDeleted(Boolean.TRUE);
            Set<ShopTable> set = shopFloor.getTables();
            if (set != null && !set.isEmpty()) {
                for (ShopTable shopTable : set) {
                    shopTable.setFloorId(null);
                    ShopTableDAO.getInstance().update(shopTable, session);
                }
                shopFloor.getTables().removeAll(set);
            }
            this.saveOrUpdate(shopFloor, session);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopFloorDAO.class).error((Object)exception);
            throw new HibernateException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateShopFloors(List<ShopFloor> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ShopFloor shopFloor : list) {
                ShopFloor shopFloor2 = this.get(shopFloor.getId());
                if (shopFloor2 == null) {
                    shopFloor.setUpdateLastUpdateTime(bl);
                    shopFloor.setUpdateSyncTime(bl2);
                    this.save(shopFloor, session);
                } else {
                    if (!BaseDataServiceDao.get().shouldSave(shopFloor.getLastUpdateTime(), shopFloor2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), shopFloor.getName() + " already updated");
                        continue;
                    }
                    shopFloor.setVersion(shopFloor2.getVersion());
                    shopFloor.setUpdateLastUpdateTime(bl);
                    shopFloor.setUpdateSyncTime(bl2);
                }
                shopFloor.setTables(null);
                ShopFloorDAO.getInstance().initializeTables(shopFloor2);
                if (shopFloor2 != null && shopFloor2.getTables() != null && shopFloor2.getTables().size() > 0) {
                    for (ShopTable shopTable : shopFloor2.getTables()) {
                        shopTable.setUpdateLastUpdateTime(false);
                        shopTable.setUpdateSyncTime(false);
                        shopFloor.addTotables(shopTable);
                    }
                }
                this.update(shopFloor, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void saveShopTables(Session session, ShopFloor shopFloor, ShopFloor shopFloor2, Set<ShopTable> set, boolean bl, boolean bl2) {
        if (set != null && set.size() > 0) {
            for (ShopTable shopTable : set) {
                shopTable.setFloor(shopFloor);
                Set<ShopSeat> set2 = shopTable.getSeats();
                List<ShopTableType> list = shopTable.getTypes();
                shopTable.setSeats(null);
                shopTable.setTypes(null);
                ShopTableDAO shopTableDAO = ShopTableDAO.getInstance();
                ShopTable shopTable2 = shopTableDAO.get(shopTable.getId());
                if (shopTable2 == null) {
                    shopTable.setUpdateLastUpdateTime(bl);
                    shopTable.setUpdateSyncTime(bl2);
                    this.save(shopTable, session);
                } else {
                    shopTable.setUpdateLastUpdateTime(bl);
                    shopTable.setUpdateSyncTime(bl2);
                    shopTable.setVersion(shopTable2.getVersion());
                    shopTableDAO.initializeSeats(shopTable2);
                    shopTableDAO.initializeTypes(shopTable2);
                }
                shopTableDAO.saveOrSetVersionShopSeat(session, shopTable, shopTable2, set2);
                shopTableDAO.saveOrSetVersionShopTableTypes(session, shopTable, shopTable2, list);
            }
        }
    }
}

