/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.print;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CategoryBreakOut;
import com.floreantpos.model.DrawerPullVoidEntry;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.AbstractReportDataSource;
import com.floreantpos.report.CurrencyDataRow;
import com.floreantpos.report.KitchenTicketDataSource;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.TicketDataSource;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode128;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.draw.DottedLineSeparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class ITextPrinter {
    private static final int a = 9;
    private static final int b = 16;
    private static final int c = 14;
    private Font d = new Font(1, 11.0f, 1);
    private Font e = new Font(1, 9.0f, 0);
    private Font f = new Font(1, 9.0f, 1);
    private Font g = new Font(1, 9.0f, 0);
    private Font h = new Font(1, 7.0f, 0);
    private Document i = null;
    private PdfWriter j;
    private ByteArrayOutputStream k = new ByteArrayOutputStream();

    public void createReport(ReciptPaperSize reciptPaperSize, Map<String, Object> map, AbstractReportDataSource abstractReportDataSource) throws Exception {
        this.createReport(reciptPaperSize, null, map, abstractReportDataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createReport(ReciptPaperSize reciptPaperSize, PosTransaction posTransaction, Map<String, Object> map, AbstractReportDataSource abstractReportDataSource) throws Exception {
        try {
            this.a(abstractReportDataSource);
            Document document = this.createDocument();
            int n = 19;
            int n2 = 228;
            int n3 = 900;
            int[] nArray = new int[]{138, 50};
            int n4 = nArray[0] + nArray[1];
            Rectangle rectangle = new Rectangle((float)n2, (float)n3);
            document.setPageSize(rectangle);
            document.setMargins((float)n, (float)n, 0.0f, 0.0f);
            document.newPage();
            Paragraph paragraph = new Paragraph(" ");
            Boolean bl = (Boolean)map.get("showQRImageIconOnTop");
            document.add((Element)paragraph);
            this.addText(map, "headerLine1", 1, this.d);
            this.addText(map, "ticketHeader", 1, null, true, bl == null ? false : bl);
            this.addText(map, "additionalOrderInfo", 0);
            document.add((Element)this.a());
            PdfPTable pdfPTable = this.a(2, n4, nArray);
            this.a(abstractReportDataSource, pdfPTable);
            document.add((Element)pdfPTable);
            document.add((Element)paragraph);
            document.add((Element)this.a());
            if (abstractReportDataSource instanceof TicketDataSource) {
                boolean bl2;
                Object object;
                boolean bl3;
                Ticket ticket = ((TicketDataSource)abstractReportDataSource).getTicket();
                int[] nArray2 = new int[]{126, 66};
                PdfPTable pdfPTable2 = this.a(2, n4, nArray2);
                this.a(pdfPTable2, map, "totalText", "grandSubtotal", false);
                this.a(pdfPTable2, map, "discountText", "discountAmount");
                boolean bl4 = Boolean.parseBoolean(String.valueOf(map.get("isShowTaxBreakdown")));
                if (!bl4) {
                    this.a(pdfPTable2, map, "taxText", "taxAmount");
                } else {
                    this.a(ticket, pdfPTable2);
                }
                if (ticket.getRoundedAmount() != 0.0) {
                    this.a(pdfPTable2, map, "Rounding", "roundingAmount", false);
                }
                this.a(pdfPTable2, map, "serviceChargeText", "serviceCharge");
                this.a(pdfPTable2, map, "deliveryChargeText", "deliveryCharge");
                this.a(pdfPTable2, map, "feeAmountText", "feeAmount");
                pdfPTable2.setSpacingAfter(5.0f);
                document.add((Element)pdfPTable2);
                document.add((Element)this.a());
                pdfPTable2 = this.a(2, n4, nArray2);
                this.a(pdfPTable2, map, "netAmountText", "netAmount", false);
                if (map.get("tipAmount") != null) {
                    this.a(pdfPTable2, map, "tipsText", "tipAmount", false);
                    pdfPTable2.setSpacingAfter(5.0f);
                    document.add((Element)pdfPTable2);
                    document.add((Element)this.a());
                    pdfPTable2 = this.a(2, n4, nArray2);
                    this.a(pdfPTable2, map, "grandNetAmountText", "grandNetAmount", false);
                }
                document.add((Element)pdfPTable2);
                pdfPTable2 = this.a(2, n4, nArray2);
                this.a(pdfPTable2, posTransaction, ticket);
                pdfPTable2.setSpacingBefore(7.0f);
                document.add((Element)pdfPTable2);
                pdfPTable2 = this.a(2, n4, nArray2);
                if (map.get("dueAmount") != null) {
                    this.a(pdfPTable2, map, "dueAmountText", "dueAmount", false);
                }
                document.add((Element)pdfPTable2);
                boolean bl5 = ReceiptPrintService.isEnabledMulticurrency(ticket);
                if (bl5) {
                    boolean bl6 = bl3 = posTransaction != null && posTransaction instanceof RefundTransaction && map.get("refundAmount") != null;
                    if (!bl3) {
                        Object object2;
                        if (ticket.getDueAmount() > 0.0 && (object2 = ReceiptPrintService.buildCurrencyBreakdownRows(ticket, CurrencyUtil.getAllCurrency())).size() > 0) {
                            object = new int[]{32, 80, 80};
                            PdfPTable pdfPTable3 = this.a(3, n4, (int[])object);
                            PdfPCell pdfPCell = this.a(Messages.getString("ReceiptPrintService.37"), 2, this.f);
                            pdfPCell.setColspan(3);
                            pdfPCell.setPaddingTop(10.0f);
                            pdfPCell.setPaddingBottom(10.0f);
                            pdfPTable3.addCell(pdfPCell);
                            document.add((Element)pdfPTable3);
                            document.add((Element)this.a(0.0f, 2.0f));
                            PdfPTable pdfPTable4 = this.a(3, n4, (int[])object);
                            pdfPTable4.setExtendLastRow(false);
                            PdfPCell pdfPCell2 = this.a("", 2);
                            pdfPCell2.setPaddingBottom(5.0f);
                            pdfPTable4.addCell(pdfPCell2);
                            PdfPCell pdfPCell3 = this.a(Messages.getString("PosMessage.87"), 2);
                            pdfPCell3.setPaddingBottom(5.0f);
                            pdfPTable4.addCell(pdfPCell3);
                            PdfPCell pdfPCell4 = this.a(Messages.getString("ReceiptPrintService.39"), 2);
                            pdfPCell4.setPaddingBottom(5.0f);
                            pdfPTable4.addCell(pdfPCell4);
                            document.add((Element)pdfPTable4);
                            document.add((Element)this.a(0.0f, 2.0f));
                            PdfPTable pdfPTable5 = this.a(3, n4, (int[])object);
                            Iterator iterator = object2.iterator();
                            while (iterator.hasNext()) {
                                CurrencyDataRow currencyDataRow = (CurrencyDataRow)iterator.next();
                                pdfPTable5.addCell(this.a(currencyDataRow.getCurrencyCode(), 0));
                                pdfPTable5.addCell(this.a(NumberUtil.formatAmount(currencyDataRow.getTotalAmount()), 2));
                                pdfPTable5.addCell(this.a(NumberUtil.formatAmount(currencyDataRow.getDueAmount()), 2));
                            }
                            document.add((Element)pdfPTable5);
                        }
                        if ((object2 = ReceiptPrintService.buildAllMultiCurrency(map, ticket, posTransaction, true, true)) != null) {
                            map.put("additionalProperties", ((StringBuilder)object2).toString());
                        }
                    }
                }
                this.addText(map, "additionalProperties", 2);
                bl3 = Boolean.parseBoolean(String.valueOf(map.get("cardPayment")));
                boolean bl7 = bl2 = bl3 && Boolean.parseBoolean(String.valueOf(map.get("showTipsBlock")));
                if (bl3) {
                    this.addText(map, "approvalCode", 0);
                }
                this.addText(map, "bottomMessage", 0, null, true, (object = (Boolean)map.get("showQRImageIconOnFooter")) == null ? false : (Boolean)object);
                document.add((Element)paragraph);
                this.addText(map, "copyType", 1);
                this.addText(map, "footerMessage", 1);
            } else {
                this.addText(map, "printerName", 0);
                this.addText(map, "bottomMessage", 0);
                document.add((Element)paragraph);
                this.addText(map, "footerMessage", 1);
            }
        }
        finally {
            this.closeDocument();
        }
    }

    private void a(AbstractReportDataSource abstractReportDataSource) {
        if (abstractReportDataSource instanceof KitchenTicketDataSource) {
            this.d.setSize(14.0f);
            this.f.setSize(14.0f);
            this.e.setSize(14.0f);
            this.g.setSize(16.0f);
        } else {
            this.d.setSize(9.0f);
            this.f.setSize(9.0f);
            this.e.setSize(9.0f);
            this.g.setSize(9.0f);
        }
    }

    private void a(AbstractReportDataSource abstractReportDataSource, PdfPTable pdfPTable) {
        Store store = DataProvider.get().getStore();
        List list = abstractReportDataSource.getRows();
        if (list != null) {
            if (abstractReportDataSource instanceof TicketDataSource) {
                TicketDataSource ticketDataSource = (TicketDataSource)abstractReportDataSource;
                for (ITicketItem iTicketItem : list) {
                    String string = ticketDataSource.getColorCode(store, iTicketItem);
                    this.g.setColor(ITextPrinter.decodeHtmlColorString(string));
                    PdfPCell pdfPCell = this.a(iTicketItem.getNameDisplay(), 0);
                    PdfPCell pdfPCell2 = this.a(iTicketItem.getSubTotalAmountDisplay(), 2);
                    pdfPTable.addCell(pdfPCell);
                    pdfPTable.addCell(pdfPCell2);
                }
            } else if (abstractReportDataSource instanceof KitchenTicketDataSource) {
                KitchenTicketDataSource kitchenTicketDataSource = (KitchenTicketDataSource)abstractReportDataSource;
                int n = 0;
                for (KitchenTicketItem kitchenTicketItem : list) {
                    String string = kitchenTicketDataSource.getColorCode(kitchenTicketItem, kitchenTicketItem.getKitchenTicket().getOrderTypeId());
                    this.g.setColor(ITextPrinter.decodeHtmlColorString(string));
                    PdfPCell pdfPCell = this.b("-------------------------------------------------------------------------------", 0);
                    if (!kitchenTicketItem.isModifierItem().booleanValue() && !kitchenTicketItem.isCookingInstruction().booleanValue() && n > 0) {
                        pdfPCell.setColspan(2);
                        pdfPTable.addCell(pdfPCell);
                    }
                    pdfPCell = this.a(kitchenTicketItem.getMenuItemNameDisplay(), 0);
                    pdfPCell.setColspan(2);
                    pdfPTable.addCell(pdfPCell);
                    ++n;
                }
            }
        }
        this.g.setColor(Color.black);
    }

    public static Color decodeHtmlColorString(String string) {
        Color color;
        if (StringUtils.isEmpty((String)string)) {
            return Color.BLACK;
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        switch (string.length()) {
            case 6: {
                int n = Integer.parseInt(string.substring(0, 2), 16);
                int n2 = Integer.parseInt(string.substring(2, 4), 16);
                int n3 = Integer.parseInt(string.substring(4, 6), 16);
                color = new Color(n, n2, n3);
                break;
            }
            case 3: {
                int n = Integer.parseInt(string.substring(0, 1), 16);
                int n4 = Integer.parseInt(string.substring(1, 2), 16);
                int n5 = Integer.parseInt(string.substring(2, 3), 16);
                color = new Color(n, n4, n5);
                break;
            }
            case 1: {
                int n;
                int n6 = n = Integer.parseInt(string.substring(0, 1), 16);
                int n7 = n;
                color = new Color(n7, n6, n);
                break;
            }
            default: {
                return Color.BLACK;
            }
        }
        return color;
    }

    private PdfPTable a(int n, int n2, int[] nArray) throws DocumentException {
        PdfPTable pdfPTable = new PdfPTable(n);
        pdfPTable.setHorizontalAlignment(1);
        pdfPTable.setWidths(nArray);
        pdfPTable.setKeepTogether(true);
        pdfPTable.setTotalWidth((float)n2);
        pdfPTable.setWidthPercentage(100.0f);
        return pdfPTable;
    }

    private Image a(Map<String, Object> map) throws DocumentException {
        Object object = map.get(ReceiptParam.BARCODE.getParamName());
        if (object != null) {
            PdfContentByte pdfContentByte = this.getPdfWriter().getDirectContent();
            Barcode128 barcode128 = new Barcode128();
            barcode128.setBaseline(-1.0f);
            barcode128.setSize(12.0f);
            barcode128.setFont(this.e.getBaseFont());
            barcode128.setCode(String.valueOf(object));
            barcode128.setCodeType(9);
            barcode128.setBarHeight(20.0f);
            barcode128.setX(1.0f);
            barcode128.setTextAlignment(1);
            Image image = barcode128.createImageWithBarcode(pdfContentByte, null, null);
            image.setAlignment(1);
            image.setSpacingBefore(1.0f);
            image.setSpacingAfter(1.0f);
            image.setWidthPercentage(90.0f);
            return image;
        }
        return null;
    }

    private Image a(Map<String, Object> map, int n) throws BadElementException, MalformedURLException, IOException, DocumentException {
        java.awt.Image image = (java.awt.Image)map.get("storeLogoIcon");
        if (image != null) {
            Image image2 = Image.getInstance((java.awt.Image)POSUtil.convertBlackAndWhiteImage(image), null);
            image2.setAlignment(1);
            float f = image2.getWidth();
            float f2 = image2.getHeight();
            if (f > (float)n) {
                f2 = f2 * (float)n / f;
                f = n;
            }
            image2.scaleToFit(f, f2);
            return image2;
        }
        return null;
    }

    private Image b(Map<String, Object> map) throws BadElementException, MalformedURLException, IOException, DocumentException {
        BufferedImage bufferedImage = (BufferedImage)map.get("qrImageIcon");
        if (bufferedImage != null) {
            Image image = Image.getInstance((java.awt.Image)POSUtil.convertBlackAndWhiteImage(bufferedImage), null);
            image.setAlignment(1);
            image.scaleToFit(120.0f, 120.0f);
            return image;
        }
        return null;
    }

    public PdfWriter getPdfWriter() {
        return this.j;
    }

    private void a(PdfPTable pdfPTable, Map<String, Object> map, String string, String string2) {
        this.a(pdfPTable, map, string, string2, true);
    }

    private void a(PdfPTable pdfPTable, Map<String, Object> map, String string, String string2, boolean bl) {
        Object object = map.get(string2);
        if (bl && (object == null || object.equals("null") || object.equals("0.00"))) {
            return;
        }
        pdfPTable.addCell(this.a(String.valueOf(map.get(string)), 0));
        pdfPTable.addCell(this.a(String.valueOf(object), 2));
    }

    private PdfPCell a(String string, int n) {
        return this.a(string, n, this.g);
    }

    private PdfPCell a(String string, int n, Font font) {
        Font font2 = new Font(font);
        if (string != null && string.contains("<br>")) {
            string = string.replaceAll("<br>", "\n");
        }
        PdfPCell pdfPCell = new PdfPCell(new Phrase(string, font2));
        pdfPCell.setHorizontalAlignment(n);
        pdfPCell.setBorder(0);
        return pdfPCell;
    }

    private PdfPCell b(String string, int n) {
        Font font = new Font(this.h);
        PdfPCell pdfPCell = new PdfPCell(new Phrase(string, font));
        pdfPCell.setHorizontalAlignment(n);
        pdfPCell.setBorder(0);
        return pdfPCell;
    }

    private DottedLineSeparator a() {
        return this.a(2.0f, 2.0f);
    }

    private DottedLineSeparator a(float f, float f2) {
        DottedLineSeparator dottedLineSeparator = new DottedLineSeparator();
        dottedLineSeparator.setAlignment(1);
        dottedLineSeparator.setOffset(f);
        dottedLineSeparator.setGap(4.0f);
        dottedLineSeparator.setLineWidth(f2);
        return dottedLineSeparator;
    }

    public Document createDocument() throws Exception {
        this.i = new Document();
        this.j = PdfWriter.getInstance((Document)this.i, (OutputStream)this.k);
        this.i.open();
        return this.i;
    }

    public void closeDocument() {
        if (this.i != null) {
            this.i.close();
            this.i = null;
        }
    }

    public void rendererReport(JPanel jPanel) throws Exception {
        PDDocument pDDocument = PDDocument.load((InputStream)new ByteArrayInputStream(this.getPrintableByteArray()));
        MigLayout migLayout = new MigLayout("fill,hidemode 3,wrap 1,ins 0", "", "[]0px[]");
        JPanel jPanel2 = new JPanel((LayoutManager)migLayout);
        jPanel2.setBackground(Color.WHITE);
        float f = (float)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0f;
        for (int i = 0; i < pDDocument.getNumberOfPages(); ++i) {
            BufferedImage bufferedImage = this.crop(new PDFRenderer(pDDocument).renderImage(i, f), i + 1 == pDDocument.getNumberOfPages() ? 20 : 0);
            if (bufferedImage == null) continue;
            jPanel2.add((Component)new JLabel(new ImageIcon(bufferedImage)), "gap 0");
        }
        jPanel.add(jPanel2);
    }

    public BufferedImage crop(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = this.a(bufferedImage);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3 + n, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((java.awt.Image)bufferedImage, 0, 0, null);
        return bufferedImage2;
    }

    private int a(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = 0;
        block0: for (int i = 0; i < n; ++i) {
            for (int j = n2 - 1; j >= 0; --j) {
                if (bufferedImage.getRGB(i, j) == Color.WHITE.getRGB() || j <= n3) continue;
                n3 = j;
                continue block0;
            }
        }
        return n3;
    }

    public boolean allWhiteRow(int n, BufferedImage bufferedImage, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (bufferedImage.getRGB(i, n) != 255) continue;
            return true;
        }
        return false;
    }

    public boolean allWhiteColumn(int n, BufferedImage bufferedImage, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (bufferedImage.getRGB(i, n) != 255) continue;
            return true;
        }
        return false;
    }

    public byte[] getPrintableByteArray() {
        return this.k.toByteArray();
    }

    public void addText(Map<String, Object> map, String string, int n) throws Exception {
        this.addText(map, string, n, null);
    }

    public Document getDocument() {
        return this.i;
    }

    public void addText(Map<String, Object> map, String string, int n, Font font) throws Exception {
        this.addText(map, string, n, font, true);
    }

    public void addText(Map<String, Object> map, String string, int n, Font font, boolean bl) throws Exception {
        this.addText(map, string, n, font, true, false);
    }

    public void addText(Map<String, Object> map, String string, int n, Font font, boolean bl, boolean bl2) throws Exception {
        Document document = this.getDocument();
        String string2 = String.valueOf(map.get(string));
        if (StringUtils.isEmpty((String)string2) || string2.equals("null")) {
            if (bl2 && map.containsKey("qrImageIcon")) {
                PdfPTable pdfPTable = new PdfPTable(1);
                pdfPTable.setHorizontalAlignment(1);
                pdfPTable.setWidthPercentage(100.0f);
                this.a(pdfPTable);
                this.a(map, pdfPTable);
                document.add((Element)pdfPTable);
            }
            return;
        }
        boolean bl3 = false;
        if (string2.contains("<div>")) {
            string2 = string2.replaceAll("<div>", "").replaceAll("</div>", "<br>").replaceAll("&nbsp;", " ");
            bl3 = true;
        }
        PdfPTable pdfPTable = new PdfPTable(1);
        pdfPTable.setHorizontalAlignment(1);
        pdfPTable.setWidthPercentage(100.0f);
        String[] stringArray = string2.split("<br>");
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                Image image;
                String string3;
                String string4 = stringArray[i];
                if (string4.contains("<b>")) {
                    font = this.f;
                }
                if (font == null) {
                    font = this.e;
                }
                if (StringUtils.isEmpty((String)(string3 = string4.replaceAll("<.*?>", "").replaceAll("</", "").replaceAll("&nbsp;", " ")))) continue;
                if (bl3) {
                    string3 = string3.replaceAll("\n", "");
                }
                if (string4.contains("<strike>")) {
                    string3 = Messages.getString("EscPosPrintService.25") + " " + string3;
                }
                PdfPCell pdfPCell = new PdfPCell(new Phrase(string3, font));
                pdfPCell.setHorizontalAlignment(n);
                pdfPCell.setBorder(0);
                pdfPTable.addCell(pdfPCell);
                if (string4.contains("<barcode>")) {
                    image = this.a(map);
                    if (image != null) {
                        pdfPCell = new PdfPCell(image);
                        pdfPCell.setHorizontalAlignment(n);
                        pdfPCell.setBorder(0);
                        pdfPTable.addCell(pdfPCell);
                    }
                } else if (string4.contains("<storeLogo>") && (image = this.a(map, 200)) != null) {
                    pdfPCell = new PdfPCell(image);
                    pdfPCell.setHorizontalAlignment(n);
                    pdfPCell.setBorder(0);
                    pdfPTable.addCell(pdfPCell);
                }
                if (!string4.contains("</b>")) continue;
                font = this.e;
            }
            if (bl) {
                this.a(pdfPTable);
            }
            if (bl2 && map.containsKey("qrImageIcon")) {
                this.a(map, pdfPTable);
                this.a(pdfPTable);
            }
        }
        document.add((Element)pdfPTable);
    }

    private void a(Map<String, Object> map, PdfPTable pdfPTable) throws BadElementException, MalformedURLException, IOException, DocumentException {
        Image image = this.b(map);
        if (image != null) {
            PdfPCell pdfPCell = new PdfPCell(image);
            pdfPCell.setHorizontalAlignment(1);
            pdfPCell.setBorder(0);
            pdfPTable.addCell(pdfPCell);
        }
    }

    private void a(PdfPTable pdfPTable) {
        PdfPCell pdfPCell = new PdfPCell(new Phrase(Chunk.NEWLINE));
        pdfPCell.setBorder(0);
        pdfPTable.addCell(pdfPCell);
    }

    private Chunk a(String string, Font font) {
        Chunk chunk = new Chunk(string, font);
        chunk.setUnderline(0.5f, 3.0f);
        return chunk;
    }

    public void addTextWithUnderline(PdfPTable pdfPTable, String string) throws DocumentException {
        PdfPCell pdfPCell = this.a("          ", 0);
        PdfPCell pdfPCell2 = this.a(string, 0);
        pdfPCell2.setColspan(2);
        pdfPCell2.setBorder(2);
        pdfPTable.addCell(pdfPCell2);
        pdfPTable.addCell(pdfPCell);
        pdfPTable.addCell(pdfPCell);
    }

    public void addLine(Document document, int n) throws DocumentException {
        for (int i = 0; i < n; ++i) {
            document.add((Element)new Paragraph(" "));
        }
    }

    public static ITextPrinter create() {
        return new ITextPrinter();
    }

    private void a(PdfPTable pdfPTable, PosTransaction posTransaction, Ticket ticket) {
        List<ReceiptPrintService.TransactionDataRow> list = ReceiptPrintService.buildPayments(posTransaction, ticket);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ReceiptPrintService.TransactionDataRow transactionDataRow : list) {
            pdfPTable.addCell(this.a(transactionDataRow.getPaymentType(), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumberAcceptNegative(transactionDataRow.getAmount()), 2));
        }
    }

    private void a(Ticket ticket, PdfPTable pdfPTable) {
        Map<String, Double> map = ReceiptPrintService.populateTaxBreakdownMap(ticket);
        if (map == null || map.isEmpty()) {
            return;
        }
        String string = CurrencyUtil.getCurrencySymbol();
        Boolean bl = ticket.isTaxIncluded();
        String string2 = "(" + POSConstants.RECEIPT_REPORT_TAX_LABEL + ") ";
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            String string3 = NumberUtil.formatNumber(entry.getValue());
            String string4 = entry.getKey();
            string4 = string4 + string;
            if (bl.booleanValue()) {
                string4 = string4 + Messages.getString("ReceiptPrintService.18");
                string3 = " (" + string3 + ")";
            }
            pdfPTable.addCell(this.a(string2 + string4, 0));
            pdfPTable.addCell(this.a(string3, 2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createServerSummaryReport(CashDrawer cashDrawer, HashMap hashMap) throws Exception {
        try {
            Document document = this.createDocument();
            int n = 19;
            int n2 = 228;
            int n3 = 600;
            Font font = new Font(1, 10.0f, 1);
            int[] nArray = new int[]{138, 50};
            int n4 = nArray[0] + nArray[1];
            Rectangle rectangle = new Rectangle((float)n2, (float)n3);
            document.setPageSize(rectangle);
            document.setMargins((float)n, (float)n, 0.0f, 0.0f);
            document.newPage();
            Paragraph paragraph = new Paragraph(" ");
            document.add((Element)paragraph);
            this.addText(hashMap, "headerLine1", 1, this.d, false);
            this.addText(hashMap, "SSReportTitle", 1, this.d, false);
            this.addText(hashMap, "user", 1, this.d, false);
            this.addText(hashMap, "date", 1, this.d, true);
            this.addText(hashMap, "salesBalance", 1, font);
            document.add((Element)this.a());
            PdfPTable pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowGrossSales")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getGrossSales()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowDiscount")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getTotalDiscountSales()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowReturn")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getReturnAmount()), 2));
            pdfPTable.setSpacingAfter(5.0f);
            document.add((Element)pdfPTable);
            document.add((Element)this.a());
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowNetSales")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getNetSales()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowSC")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getServiceCharge()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowSalesTax")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getSalesTax()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowDC")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getDeliveryCharge()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowTips")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getGratuity()), 2));
            if (cashDrawer.getFeeAmount() > 0.0) {
                document.add((Element)pdfPTable);
                pdfPTable = this.a(2, n4, nArray);
                pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowFee")), 0));
                pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getFeeAmount()), 2));
            }
            pdfPTable.setSpacingAfter(5.0f);
            document.add((Element)pdfPTable);
            document.add((Element)this.a());
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowTotal")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getTotalRevenue()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCReceipts")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCashReceiptAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCCards")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCreditCardReceiptAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowDCards")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getDebitCardReceiptAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowMPayments")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCustomerPaymentAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCPayments")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCustomPaymentAmount()), 2));
            document.add((Element)pdfPTable);
            if (cashDrawer.getPromotionAmount() > 0.0) {
                pdfPTable = this.a(2, n4, nArray);
                pdfPTable.addCell(this.a("-PROMOTION", 0));
                pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getPromotionAmount()), 2));
                document.add((Element)pdfPTable);
            }
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowGCert")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getGiftCertChangeAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowRefundPlus")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getRefundAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowTolerance")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getToleranceAmount()), 2));
            pdfPTable.setSpacingAfter(5.0f);
            document.add((Element)pdfPTable);
            document.add((Element)this.a());
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowReceiptDiff")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getReceiptDifferential()), 2));
            pdfPTable.setSpacingAfter(10.0f);
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCashTips")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCashTips()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowChargedTips")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getChargedTips()), 2));
            document.add((Element)pdfPTable);
            this.a(cashDrawer, hashMap, document, font, nArray, n4);
            pdfPTable = this.a(2, n4, nArray);
            PdfPCell pdfPCell = this.b("-----------", 1);
            pdfPCell.setColspan(2);
            pdfPTable.addCell(pdfPCell);
            document.add((Element)pdfPTable);
        }
        finally {
            this.closeDocument();
        }
    }

    private DottedLineSeparator a(float f, float f2, float f3) {
        DottedLineSeparator dottedLineSeparator = new DottedLineSeparator();
        dottedLineSeparator.setAlignment(1);
        dottedLineSeparator.setOffset(f);
        dottedLineSeparator.setGap(f2);
        dottedLineSeparator.setPercentage(f3);
        return dottedLineSeparator;
    }

    private void a(PdfPTable pdfPTable, CashDrawer cashDrawer, HashMap hashMap) {
        for (CategoryBreakOut categoryBreakOut : cashDrawer.getCategoryBreakOut()) {
            String string = categoryBreakOut.getCategoryName();
            PdfPCell pdfPCell = this.a(string != null ? string : "Others", 0);
            pdfPTable.addCell(pdfPCell);
            PdfPCell pdfPCell2 = this.a(NumberUtil.formatNumber(categoryBreakOut.getBreakOutAmt()), 2);
            pdfPTable.addCell(pdfPCell2);
        }
        pdfPTable.setSpacingAfter(5.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCashDrawerReport(CashDrawer cashDrawer, HashMap hashMap) throws Exception {
        try {
            Document document = this.createDocument();
            int n = 19;
            int n2 = 228;
            int n3 = 600;
            Font font = new Font(1, 10.0f, 1);
            int[] nArray = new int[]{138, 50};
            int n4 = nArray[0] + nArray[1];
            Rectangle rectangle = new Rectangle((float)n2, (float)n3);
            document.setPageSize(rectangle);
            document.setMargins((float)n, (float)n, 0.0f, 0.0f);
            document.newPage();
            Paragraph paragraph = new Paragraph(" ");
            document.add((Element)paragraph);
            this.addText(hashMap, "headerLine1", 1, this.d, false);
            this.addText(hashMap, "reportTitle", 1, this.d, false);
            this.addText(hashMap, "user", 1, this.d, false);
            document.add((Element)paragraph);
            this.addText(hashMap, "startTime", 1, this.d, false);
            this.addText(hashMap, "closeTime", 1, this.d, false);
            document.add((Element)paragraph);
            this.addText(hashMap, "date", 1, this.d, true);
            this.addText(hashMap, "salesBalance", 1, font);
            document.add((Element)this.a());
            PdfPTable pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowGrossReceipts")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getGrossReceipts()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCReceipts")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCashReceiptAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCCards")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCreditCardReceiptAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowDCards")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getDebitCardReceiptAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowMPayments")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCustomerPaymentAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCPayments")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCustomPaymentAmount()), 2));
            document.add((Element)pdfPTable);
            if (cashDrawer.getPromotionAmount() > 0.0) {
                pdfPTable = this.a(2, n4, nArray);
                pdfPTable.addCell(this.a("-PROMOTION", 0));
                pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getPromotionAmount()), 2));
                document.add((Element)pdfPTable);
            }
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowGReturns")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getGiftCertReturnAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowGCChange")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getGiftCertChangeAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowRefundPlus")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getRefundAmount()), 2));
            pdfPTable.setSpacingAfter(5.0f);
            document.add((Element)pdfPTable);
            document.add((Element)this.a());
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowReceiptDiff")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getReceiptDifferential()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCashTips")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCashTips()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowChargedTips")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getChargedTips()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowTipsPaid")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getTipsPaid()), 2));
            pdfPTable.setSpacingAfter(5.0f);
            document.add((Element)pdfPTable);
            document.add((Element)this.a());
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowTipsDiff")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getTipsDifferential()), 2));
            document.add((Element)pdfPTable);
            this.addText(hashMap, "cashBalance", 1, font);
            document.add((Element)this.a());
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCash")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCashReceiptAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowTipsPaid")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getTipsPaid()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowPayOut")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getPayOutAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowRefundMinus")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCashBack()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowBeginCash")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getBeginCash()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCashIn")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCashInAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowDBleed")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getDrawerBleedAmount()), 2));
            pdfPTable.setSpacingAfter(5.0f);
            document.add((Element)pdfPTable);
            document.add((Element)this.a());
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowDAcc")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getDrawerAccountable()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowDTips")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getDeclaredTips()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCToDipo")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCashToDeposit()), 2));
            document.add((Element)pdfPTable);
            if (cashDrawer.getCashBreakdownList().size() > 0) {
                this.addText(hashMap, "rowCBreakD", 1, font, false);
                pdfPTable = this.a(2, n4, nArray);
                PdfPCell pdfPCell = this.a(String.valueOf(hashMap.get("rowCSRAmount")), 2);
                pdfPCell.setColspan(2);
                pdfPTable.addCell(pdfPCell);
                pdfPTable.setSpacingAfter(5.0f);
                document.add((Element)pdfPTable);
                document.add((Element)this.a());
                pdfPTable = this.a(2, n4, nArray);
                this.b(pdfPTable, cashDrawer, hashMap);
                document.add((Element)pdfPTable);
                document.add((Element)this.a());
            }
        }
        finally {
            this.closeDocument();
        }
    }

    private void b(PdfPTable pdfPTable, CashDrawer cashDrawer, HashMap hashMap) {
        for (CashBreakdown cashBreakdown : cashDrawer.getCashBreakdownList()) {
            pdfPTable.addCell(this.a(cashBreakdown.getCurrencyName(), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashBreakdown.getBalance()), 2));
        }
        pdfPTable.setSpacingAfter(5.0f);
    }

    private double c(PdfPTable pdfPTable, CashDrawer cashDrawer, HashMap hashMap) {
        PdfPCell pdfPCell = this.a(String.valueOf(hashMap.get("rowVRAmount")), 2);
        pdfPCell.setColspan(2);
        pdfPTable.addCell(pdfPCell);
        double d = 0.0;
        for (DrawerPullVoidEntry drawerPullVoidEntry : cashDrawer.getVoidEntries()) {
            pdfPTable.addCell(this.a(drawerPullVoidEntry.getReason(), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(drawerPullVoidEntry.getAmount()), 2));
            d += drawerPullVoidEntry.getAmount().doubleValue();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStoreSessionSummaryReport(CashDrawer cashDrawer, HashMap hashMap) throws Exception {
        try {
            Document document = this.createDocument();
            int n = 19;
            int n2 = 228;
            int n3 = 600;
            Font font = new Font(1, 10.0f, 1);
            int[] nArray = new int[]{138, 50};
            int n4 = nArray[0] + nArray[1];
            Rectangle rectangle = new Rectangle((float)n2, (float)n3);
            document.setPageSize(rectangle);
            document.setMargins((float)n, (float)n, 0.0f, 0.0f);
            document.newPage();
            Paragraph paragraph = new Paragraph(" ");
            document.add((Element)paragraph);
            this.addText(hashMap, "headerLine1", 1, this.d, false);
            this.addText(hashMap, "reportTitle", 1, this.d, false);
            this.addText(hashMap, "user", 1, this.e, false);
            this.addText(hashMap, "startTime", 1, this.e, cashDrawer.getReportTime() == null);
            this.addText(hashMap, "reportUser", 1, this.e, false);
            this.addText(hashMap, "date", 1, this.e, true);
            this.addText(hashMap, "salesBalance", 1, font);
            document.add((Element)this.a());
            PdfPTable pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowGrossSales")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getGrossSales()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowDiscount")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getTotalDiscountAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowReturn")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getReturnAmount()), 2));
            pdfPTable.setSpacingAfter(5.0f);
            document.add((Element)pdfPTable);
            document.add((Element)this.a());
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowNetSales")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getNetSales()), 2));
            pdfPTable.setSpacingAfter(5.0f);
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowSalesTax")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getSalesTax()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowSC")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getServiceCharge()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowFee")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getFeeAmount()), 2));
            pdfPTable.setSpacingAfter(5.0f);
            document.add((Element)pdfPTable);
            document.add((Element)this.a());
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowTotal")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getTotalRevenue()), 2));
            pdfPTable.setSpacingAfter(5.0f);
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowTips")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCashTips() + cashDrawer.getChargedTips()), 2));
            pdfPTable.setSpacingAfter(5.0f);
            document.add((Element)pdfPTable);
            document.add((Element)this.a());
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowGReceivable")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getGrossReceipts() + cashDrawer.getChargedTips()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCReceipts")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCashReceiptAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCCards")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCreditCardReceiptAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowDCards")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getDebitCardReceiptAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowMPayments")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCustomerPaymentAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCPayments")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCustomPaymentAmount()), 2));
            document.add((Element)pdfPTable);
            if (cashDrawer.getPromotionAmount() > 0.0) {
                pdfPTable = this.a(2, n4, nArray);
                pdfPTable.addCell(this.a("-PROMOTION", 0));
                pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getPromotionAmount()), 2));
                document.add((Element)pdfPTable);
            }
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowGCert")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getGiftCertChangeAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowRefundPlus")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getRefundAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowTolerance")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getToleranceAmount()), 2));
            pdfPTable.setSpacingAfter(5.0f);
            document.add((Element)pdfPTable);
            document.add((Element)this.a());
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowReceiptDiff")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getReceiptDifferential()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCashTips")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCashTips()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowChargedTips")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getChargedTips()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowTipsPaid")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getTipsPaid()), 2));
            pdfPTable.setSpacingAfter(5.0f);
            document.add((Element)pdfPTable);
            document.add((Element)this.a());
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowTipsDiff")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getTipsDifferential()), 2));
            document.add((Element)pdfPTable);
            this.addText(hashMap, "cashBalance", 1, font);
            document.add((Element)this.a());
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCash")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCashReceiptAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowTipsPaid")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getTipsPaid()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowPayOut")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getPayOutAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowRefundMinus")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCashBack()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowBeginCash")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getBeginCash()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowCashIn")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getCashInAmount()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowDBleed")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getDrawerBleedAmount()), 2));
            pdfPTable.setSpacingAfter(5.0f);
            document.add((Element)pdfPTable);
            document.add((Element)this.a());
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowDAcc")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getDrawerAccountable()), 2));
            document.add((Element)pdfPTable);
            pdfPTable = this.a(2, n4, nArray);
            pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowDTips")), 0));
            pdfPTable.addCell(this.a(NumberUtil.formatNumber(cashDrawer.getDeclaredTips()), 2));
            document.add((Element)pdfPTable);
            if (cashDrawer.getCashBreakdownList().size() > 0) {
                this.addText(hashMap, "rowCBreakD", 1, font, false);
                pdfPTable = this.a(2, n4, nArray);
                PdfPCell pdfPCell = this.a(String.valueOf(hashMap.get("rowCSRAmount")), 2);
                pdfPCell.setColspan(2);
                pdfPTable.addCell(pdfPCell);
                pdfPTable.setSpacingAfter(5.0f);
                document.add((Element)pdfPTable);
                document.add((Element)this.a());
                pdfPTable = this.a(2, n4, nArray);
                this.b(pdfPTable, cashDrawer, hashMap);
                document.add((Element)pdfPTable);
                document.add((Element)this.a());
            }
            if (cashDrawer.getVoidEntries() != null && cashDrawer.getVoidEntries().size() > 0) {
                this.addText(hashMap, "rowVRExceptions", 1, font);
                this.addText(hashMap, "rowVRTax", 1, font);
                document.add((Element)this.a());
                pdfPTable = this.a(2, n4, nArray);
                double d = this.c(pdfPTable, cashDrawer, hashMap);
                pdfPTable.setSpacingAfter(5.0f);
                document.add((Element)pdfPTable);
                document.add((Element)this.a());
                pdfPTable = this.a(2, n4, nArray);
                pdfPTable.addCell(this.a(String.valueOf(hashMap.get("rowVRTotal")), 2));
                pdfPTable.addCell(this.a(NumberUtil.formatNumber(d), 2));
                document.add((Element)pdfPTable);
            }
            this.a(cashDrawer, hashMap, document, font, nArray, n4);
        }
        finally {
            this.closeDocument();
        }
    }

    private void a(CashDrawer cashDrawer, HashMap<String, Object> hashMap, Document document, Font font, int[] nArray, int n) throws Exception, DocumentException {
        Store store = DataProvider.get().getStore();
        if (POSUtil.getBoolean(store.getProperty("show_category_breakout.in_server_Summary")) && cashDrawer.getCategoryBreakOut().size() > 0) {
            this.addText(hashMap, "TitleCatBreakOut", 1, font);
            document.add((Element)this.a(2.0f, 2.0f, 100.0f));
            PdfPTable pdfPTable = this.a(2, n, nArray);
            this.a(pdfPTable, cashDrawer, hashMap);
            document.add((Element)pdfPTable);
            document.add((Element)this.a(2.0f, 2.0f, 100.0f));
        }
    }
}

