/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.BalanceForwardTransaction;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.CustomerAccountReportModel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXDatePicker;

public class CustomerAccountReportView
extends TransparentPanel {
    private JButton a;
    private JXDatePicker b;
    private JXDatePicker c;
    private JPanel d;
    private JPanel e;
    private JTextField f;

    public CustomerAccountReportView() {
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() {
        try {
            BalanceUpdateTransaction balanceUpdateTransaction;
            Object object;
            Serializable serializable2;
            Date date = this.b.getDate();
            Date date2 = this.c.getDate();
            DateUtil.validateDate(date, date2);
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date);
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            date = calendar.getTime();
            calendar.clear();
            calendar2.setTime(date2);
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            date2 = calendar.getTime();
            String string = this.f.getText().trim();
            List<Object> list = new ArrayList();
            if (StringUtils.isBlank((CharSequence)string)) {
                this.d.removeAll();
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("CustomerAccountReportView.0"));
                return;
            }
            list = CustomerDAO.getInstance().findCustomerIdsByNameOrEmail(string);
            if (list == null || list.size() < 1) {
                this.d.removeAll();
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("CustomerPaymentReportView.0"));
                return;
            }
            List<BalanceUpdateTransaction> list2 = PosTransactionDAO.getInstance().findMemberAccountTransactionsV2(list, date, date2, false);
            if (list2 == null || list2.size() < 1) {
                this.d.removeAll();
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("CustomerPaymentReportView.0"));
                return;
            }
            ArrayList<BalanceUpdateTransaction> arrayList = new ArrayList<BalanceUpdateTransaction>();
            String string2 = "";
            for (Serializable serializable2 : list2) {
                object = serializable2.getAccountNumber();
                if (StringUtils.isNotBlank((CharSequence)object) && !string2.equals(object)) {
                    balanceUpdateTransaction = this.a((BalanceUpdateTransaction)serializable2);
                    arrayList.add(balanceUpdateTransaction);
                    string2 = object;
                }
                arrayList.add((BalanceUpdateTransaction)serializable2);
            }
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("customer-account-report"));
            serializable2 = new HashMap();
            ReportUtil.populateRestaurantProperties((Map<String, Object>)((Object)serializable2), true);
            ReportUtil.populateReportTime((HashMap<String, Object>)serializable2, date, date2);
            ReportUtil.populateReportFooter((HashMap<String, Object>)serializable2);
            this.a((HashMap<String, Object>)serializable2);
            object = new CustomerAccountReportModel();
            ((ListTableModel)object).setRows(arrayList);
            balanceUpdateTransaction = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)((Object)serializable2), (JRDataSource)new JRTableModelDataSource((TableModel)object));
            JRViewer jRViewer = new JRViewer((JasperPrint)balanceUpdateTransaction);
            this.d.removeAll();
            this.d.add((Component)jRViewer);
            this.d.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private BalanceUpdateTransaction a(BalanceUpdateTransaction balanceUpdateTransaction) {
        BalanceForwardTransaction balanceForwardTransaction = new BalanceForwardTransaction();
        if (balanceUpdateTransaction != null) {
            balanceForwardTransaction.setAccountNumber(balanceUpdateTransaction.getAccountNumber());
            balanceForwardTransaction.setAmount(balanceUpdateTransaction.getBalanceBefore());
            balanceForwardTransaction.setPaymentTypeString(balanceUpdateTransaction.getPaymentTypeString());
        }
        balanceForwardTransaction.setTicketId(Messages.getString("GiftCardDAO.1"));
        return balanceForwardTransaction;
    }

    private void a(HashMap<String, Object> hashMap) {
        hashMap.put("reportTitle", Messages.getString("CUSTOMER_ACCOUNT_REPORT"));
        hashMap.put("totalAmount", Messages.getString("CustomerPaymentReportView.17") + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("colCName", Messages.getString("CustomerName"));
        hashMap.put("colCId", Messages.getString("CustomerAccountReportView.1"));
        hashMap.put("colTicketNo", Messages.getString("TicketNo"));
        hashMap.put("colTransNo", Messages.getString("TransNo"));
        hashMap.put("colPaymentTypeName", Messages.getString("PaymentTypeName"));
        hashMap.put("colDate", POSConstants.DATE);
        hashMap.put("colTotal", Messages.getString("CustomerAccountReportView.4"));
        hashMap.put("colDescription", Messages.getString("CustomerAccountReportView.2"));
    }

    private void b() {
        this.b = UiUtil.getCurrentMonthStart();
        this.c = UiUtil.getDeafultDate();
        this.c.setDate(new Date());
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(actionEvent -> this.a());
        JLabel jLabel = new JLabel(Messages.getString("CustomerAccountReportView.3"));
        this.f = new JTextField(15);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(jLabel);
        jPanel.add(this.f);
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.b.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.b);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.e;
    }
}

