/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.AbstractReportDataSource;
import com.floreantpos.util.NumberUtil;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public class KitchenTicketDataSource
extends AbstractReportDataSource {
    private Store a = DataProvider.get().getStore();

    public KitchenTicketDataSource(KitchenTicket kitchenTicket) {
        super(new String[]{"groupId", "groupName", "itemNo", "itemName", "itemQty", "colorCode", "isVoidItem", "isModifier", "isCookingInstruction"});
        this.a(kitchenTicket);
    }

    private void a(KitchenTicket kitchenTicket) {
        Terminal terminal;
        OrderType orderType = kitchenTicket.getOrderType();
        if (orderType != null && !orderType.isAllowSeatBasedOrder().booleanValue() && (terminal = Application.getInstance().getTerminal()) != null && terminal.isGroupByCatagoryKitReceipt().booleanValue()) {
            Collections.sort(kitchenTicket.getTicketItems(), new Comparator<KitchenTicketItem>(){

                @Override
                public int compare(KitchenTicketItem kitchenTicketItem, KitchenTicketItem kitchenTicketItem2) {
                    return kitchenTicketItem.getMenuItemGroupName().compareTo(kitchenTicketItem2.getMenuItemGroupName());
                }
            });
        }
        this.setRows(kitchenTicket.getTicketItems());
    }

    @Override
    public Object getValueAt(int n, int n2) {
        KitchenTicketItem kitchenTicketItem = (KitchenTicketItem)this.rows.get(n);
        switch (n2) {
            case 0: {
                return kitchenTicketItem.getMenuItemGroupName();
            }
            case 1: {
                String string = kitchenTicketItem.getMenuItemGroupName();
                if (StringUtils.isBlank((String)string)) {
                    string = Messages.getString("Ungrouped");
                }
                return string;
            }
            case 2: {
                return kitchenTicketItem.getMenuItemCode();
            }
            case 3: {
                return kitchenTicketItem.getMenuItemNameDisplay().replaceAll("\n", "<br>");
            }
            case 4: {
                return NumberUtil.trimDecilamIfNotNeeded(kitchenTicketItem.getQuantity());
            }
            case 5: {
                Ticket ticket = kitchenTicketItem.getKitchenTicket().getParentTicket();
                String string = "";
                if (ticket != null && ticket.getOrderType() != null) {
                    string = ticket.getOrderType().getId();
                }
                return this.getColorCode(kitchenTicketItem, string);
            }
            case 6: {
                return kitchenTicketItem.isVoided();
            }
            case 7: {
                return kitchenTicketItem.isModifierItem();
            }
            case 8: {
                return kitchenTicketItem.isCookingInstruction();
            }
        }
        return null;
    }

    public String getColorCode(KitchenTicketItem kitchenTicketItem, String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            string = string + ".";
        }
        if (kitchenTicketItem.isModifierItem().booleanValue()) {
            return this.a.getProperty(string + "kitchen_ticket.modifier.color");
        }
        if (kitchenTicketItem.isCookingInstruction().booleanValue()) {
            return this.a.getProperty(string + "kitchen_ticket.instruction.color");
        }
        if (kitchenTicketItem.getMenuItemName().contains("Seat**")) {
            return this.a.getProperty(string + "kitchen_ticket.seat.color");
        }
        return Messages.getString("KitchenTicketDataSource.7");
    }
}

