/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesDetailedReport;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class SalesDetailReportView
extends JPanel {
    private JXDatePicker a = UiUtil.getCurrentMonthStart();
    private JXDatePicker b = UiUtil.getCurrentMonthEnd();
    private JButton c = new JButton(POSConstants.GO);
    private JPanel d;

    public SalesDetailReportView() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        jPanel.add((Component)this.a);
        jPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        jPanel.add((Component)this.b);
        jPanel.add((Component)this.c, "skip 1, al right");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
        this.c.addActionListener(actionEvent -> this.a());
    }

    private void a() {
        try {
            Date date = this.a.getDate();
            Date date2 = this.b.getDate();
            DateUtil.validateDate(date, date2);
            date = DateUtil.startOfDay(date);
            date2 = DateUtil.endOfDay(date2);
            ReportService reportService = new ReportService();
            SalesDetailedReport salesDetailedReport = reportService.getSalesDetailedReport(date, date2);
            JasperReport jasperReport = ReportUtil.getReport("sales_summary_balance_detailed_2");
            JasperReport jasperReport2 = ReportUtil.getReport("sales_summary_balance_detailed_3");
            JasperReport jasperReport3 = ReportUtil.getReport("sales_summary_balance_detailed_4");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ReportUtil.populateRestaurantProperties(hashMap, true);
            ReportUtil.populateReportHeader(hashMap, null, date, date2, null);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap);
            hashMap.put("giftCertReturnCount", salesDetailedReport.getGiftCertReturnCount());
            hashMap.put("giftCertReturnAmount", salesDetailedReport.getGiftCertReturnAmount());
            hashMap.put("giftCertChangeCount", salesDetailedReport.getGiftCertChangeCount());
            hashMap.put("giftCertChangeAmount", salesDetailedReport.getGiftCertChangeAmount());
            hashMap.put("tipsCount", salesDetailedReport.getTipsCount());
            hashMap.put("tipsAmount", salesDetailedReport.getChargedTips());
            hashMap.put("tipsPaidAmount", salesDetailedReport.getTipsPaid());
            hashMap.put("creditCardReport", jasperReport);
            hashMap.put("creditCardReportDatasource", new JRTableModelDataSource((TableModel)salesDetailedReport.getCreditCardDataTableModel()));
            hashMap.put("customPaymentReport", jasperReport2);
            hashMap.put("customPaymentReportDatasource", new JRTableModelDataSource((TableModel)salesDetailedReport.getOtherPaymentDataTableModel()));
            hashMap.put("returnPaymentReport", jasperReport3);
            hashMap.put("returnPaymentReportDatasource", new JRTableModelDataSource((TableModel)salesDetailedReport.getRefundPaymentDataTableModel()));
            JasperReport jasperReport4 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_detail_report"));
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport4, hashMap, (JRDataSource)new JREmptyDataSource());
            JRViewer jRViewer = new JRViewer(jasperPrint);
            this.d.removeAll();
            this.d.add((Component)jRViewer);
            this.d.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(HashMap hashMap) {
        hashMap.put("SDRTitle", Messages.getString("PosMessage.237"));
        hashMap.put("MRGCR", Messages.getString("MRGCR"));
        hashMap.put("MRGCC", Messages.getString("MRGCC"));
        hashMap.put("MRTCT", Messages.getString("MRTCT"));
        hashMap.put("MRTP", Messages.getString("DrawerPullReportExplorer.26"));
        hashMap.put("MRCount", Messages.getString("MRCount"));
        hashMap.put("MRAmount", Messages.getString("MRAmount"));
        hashMap.put("SRDPRTitle", Messages.getString("SRDPRTitle"));
        hashMap.put("SRDPRCount", POSConstants.COUNT);
        hashMap.put("SRDPRIdeal", Messages.getString("SRDPRIdeal"));
        hashMap.put("SRDPRActual", Messages.getString("SRDPRActual"));
        hashMap.put("SRDPRVariant", Messages.getString("SalesDetailReportView.2"));
        hashMap.put("SRDPRTDP", Messages.getString("SRDPRTDP"));
        hashMap.put("SRCCardTitle", Messages.getString("SalesDetailReportView.4"));
        hashMap.put("SRCCard", Messages.getString("SalesDetailReportView.6"));
        hashMap.put("SRSCount", Messages.getString("SalesCount"));
        hashMap.put("SRSAmount", Messages.getString("SalesAmount"));
        hashMap.put("SRRCount", Messages.getString("SRRefundCount"));
        hashMap.put("SRRAmount", Messages.getString("SRRefundAmount"));
        hashMap.put("SRNAmount", Messages.getString("SRNAmount"));
        hashMap.put("SRNTips", Messages.getString("SRSTips"));
        hashMap.put("SRCPaymentTitle", Messages.getString("SalesDetailReportView.8"));
        hashMap.put("SRCPayment", Messages.getString("SalesDetailReportView.1"));
        hashMap.put("SRTotal", POSConstants.TOTAL);
        hashMap.put("SRCRefundPaymentTitle", Messages.getString("SalesDetailReportView.0"));
        hashMap.put("SRDPRTermenalName", Messages.getString("SalesDetailReportView.3"));
        hashMap.put("SRDPROpenTime", Messages.getString("SalesDetailReportView.5"));
        hashMap.put("SRTotalAmount", POSConstants.TOTAL);
    }
}

