/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.model.PaymentType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.CustomerPaymentReportView;
import com.floreantpos.swing.ListTableModel;
import org.apache.commons.lang.WordUtils;

public class CustomerPaymentReportModel
extends ListTableModel {
    public CustomerPaymentReportModel() {
        super(new String[]{"customerName", "customerId", "ticketNo", "transNo", "transTime", "tips", "total", "paymentType"});
    }

    @Override
    public Object getValueAt(int n, int n2) {
        CustomerPaymentReportView.CustomerAccountTransactionItem customerAccountTransactionItem = (CustomerPaymentReportView.CustomerAccountTransactionItem)this.rows.get(n);
        switch (n2) {
            case 0: {
                return customerAccountTransactionItem.getCustomerName();
            }
            case 1: {
                return customerAccountTransactionItem.getCustomerId();
            }
            case 2: {
                return customerAccountTransactionItem.getTicketNo();
            }
            case 3: {
                return customerAccountTransactionItem.getTransactionNo();
            }
            case 4: {
                return DateUtil.formatReportDateAsString(customerAccountTransactionItem.getDate());
            }
            case 5: {
                return customerAccountTransactionItem.getTips();
            }
            case 6: {
                if (customerAccountTransactionItem.getTransactionType().equalsIgnoreCase(TransactionType.DEBIT.name())) {
                    return -1.0 * customerAccountTransactionItem.getTotalAmount();
                }
                return customerAccountTransactionItem.getTotalAmount();
            }
            case 7: {
                String string = customerAccountTransactionItem.getPaymentTypeName();
                if (string.equals(PaymentType.CUSTOM_PAYMENT.name())) {
                    return customerAccountTransactionItem.getCustomPaymentName();
                }
                String string2 = null;
                string = string.equals(PaymentType.MEMBER_ACCOUNT.name()) ? PaymentType.MEMBER_ACCOUNT.getDisplayString() : string.replaceAll("_", " ");
                string2 = WordUtils.capitalizeFully((String)string);
                return string2;
            }
        }
        return null;
    }
}

