/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.model.PosColor;
import com.floreantpos.swing.PosUIManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.ComboPopup;

public class POSColorComboBox
extends JComboBox
implements ItemListener {
    private Boolean a = Boolean.TRUE;

    public POSColorComboBox() {
        this(true);
    }

    public POSColorComboBox(Boolean bl) {
        this.setHeight(40);
        this.a = bl;
        DefaultComboBoxModel<PosColor> defaultComboBoxModel = new DefaultComboBoxModel<PosColor>();
        for (PosColor posColor : PosColor.values()) {
            if (bl != false ? posColor.equals((Object)PosColor.Foreground) : posColor.equals((Object)PosColor.Background)) continue;
            defaultComboBoxModel.addElement(posColor);
        }
        this.setModel(defaultComboBoxModel);
        this.setRenderer(new ColorRenderer());
        this.setOpaque(true);
        this.setSelectedIndex(0);
        this.addItemListener(this);
    }

    public void setHeight(int n) {
        this.setMinimumSize(PosUIManager.getSize(60, 40));
        Accessible accessible = this.getUI().getAccessibleChild(this, 0);
        if (accessible instanceof ComboPopup) {
            JList<Object> jList = ((ComboPopup)((Object)accessible)).getList();
            jList.setFixedCellHeight(PosUIManager.getSize(n));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            PosColor posColor = (PosColor)((Object)itemEvent.getItem());
            if (this.a.booleanValue()) {
                this.setBackground(posColor.getColor());
            } else {
                this.setForeground(posColor.getColor());
            }
        }
    }

    public Integer getSelectedColorCode() {
        PosColor posColor = (PosColor)((Object)this.getSelectedItem());
        if (posColor == null) {
            return null;
        }
        if (posColor.equals((Object)PosColor.Foreground)) {
            return null;
        }
        if (posColor.equals((Object)PosColor.Background)) {
            return null;
        }
        return posColor.getColor().getRGB();
    }

    class ColorRenderer
    extends JLabel
    implements ListCellRenderer {
        public ColorRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            PosColor posColor = PosColor.fromString(string, POSColorComboBox.this.a != false ? PosColor.Background : PosColor.Foreground);
            jList.setSelectionBackground(null);
            jList.setSelectionForeground(null);
            if (bl) {
                this.setBorder(BorderFactory.createEtchedBorder());
            } else {
                this.setBorder(null);
            }
            Color color = posColor.getColor();
            this.setBackground(color);
            this.setText(string);
            this.setForeground(Color.black);
            if (posColor.equals((Object)PosColor.Black) || posColor.equals((Object)PosColor.Dark_gray)) {
                this.setForeground(Color.white);
            }
            if (color.equals(Color.black)) {
                this.setForeground(Color.white);
            }
            return this;
        }
    }
}

