/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.Messages;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class POSFileChooser
extends JFileChooser {
    FileNameExtensionFilter a = new FileNameExtensionFilter(Messages.getString("POSFileChooser.0"), "jpg", "jpeg", "png", "gif");

    public POSFileChooser() {
        this.setDialogTitle(VersionInfo.getAppName());
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(this.a);
        this.setAccessory(new ImagePreview(this));
        this.setFileView(new FileView(){

            @Override
            public Icon getIcon(File file) {
                return FileSystemView.getFileSystemView().getSystemIcon(file);
            }
        });
    }

    public POSFileChooser(String string) {
        super(string);
        this.setDialogTitle(VersionInfo.getAppName());
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(this.a);
        this.setAccessory(new ImagePreview(this));
        this.setFileView(new FileView(){

            @Override
            public Icon getIcon(File file) {
                return FileSystemView.getFileSystemView().getSystemIcon(file);
            }
        });
    }

    public class ImagePreview
    extends JLabel
    implements PropertyChangeListener {
        public ImagePreview(JFileChooser jFileChooser) {
            this.setPreferredSize(new Dimension(300, 200));
            jFileChooser.addPropertyChangeListener(this);
            this.setHorizontalAlignment(0);
        }

        public void loadImage(File file) {
            if (file == null) {
                this.setIcon(null);
                return;
            }
            ImageIcon imageIcon = new ImageIcon(file.getPath());
            this.setIcon(imageIcon);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("directoryChanged".equals(string)) {
                this.loadImage(null);
            } else if ("SelectedFileChangedProperty".equals(string)) {
                File file = (File)propertyChangeEvent.getNewValue();
                this.loadImage(file);
            }
        }
    }
}

