/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.DrawerAssignmentAction;
import com.floreantpos.actions.StoreSessionReportAction;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.base.BaseStoreSession;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.CashDrawerReportDialog;
import com.floreantpos.ui.dialog.DrawerAndStaffBankReportHistoryDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.ServerOpenTicketListDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class DrawerAndStaffBankReportDialog
extends POSDialog {
    private TitlePanel a;
    private JTable b;
    private DrawerReportTableModel c;
    private List<CashDrawer> d;
    private DefaultListSelectionModel e;
    private PosButton f;
    private PosButton g;
    private User h;
    private Terminal i;

    public DrawerAndStaffBankReportDialog(User user) {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(Messages.getString("DrawerAndStaffBankReportDialog.0"));
        this.h = user;
        this.c();
        this.initData();
    }

    public void initData() {
        this.i = Application.getInstance().getTerminal();
        this.e = new DefaultListSelectionModel();
        this.e.setSelectionMode(0);
        this.b.getSelectionModel().setSelectionMode(0);
        this.b.setDefaultRenderer(Object.class, new TableRenderer());
        this.c = new DrawerReportTableModel();
        this.b.setModel(this.c);
        this.b.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setSelected(Boolean.valueOf(object.toString()));
                jCheckBox.setHorizontalAlignment(0);
                if (bl) {
                    return jCheckBox;
                }
                jCheckBox.setBackground(jTable.getBackground());
                return jCheckBox;
            }
        });
        this.a();
        boolean bl = StoreUtil.isStoreOpen() && this.h.hasPermission(UserPermission.OPEN_CLOSE_STORE);
        this.g.setVisible(bl);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawerAndStaffBankReportDialog.this.a(Integer.parseInt(actionEvent.getActionCommand()));
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn(this.b, abstractAction, 4){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return super.getTableCellRendererComponent(jTable, object, false, bl2, n, n2);
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                return super.getTableCellEditorComponent(jTable, object, false, n, n2);
            }
        };
        MatteBorder matteBorder = BorderFactory.createMatteBorder(5, 15, 5, 15, this.b.getBackground());
        MatteBorder matteBorder2 = BorderFactory.createMatteBorder(5, 15, 5, 15, this.b.getBackground());
        CompoundBorder compoundBorder = new CompoundBorder(matteBorder, this.g.getBorder());
        CompoundBorder compoundBorder2 = new CompoundBorder(matteBorder2, this.g.getBorder());
        buttonColumn.setUnselectedBorder(compoundBorder);
        buttonColumn.setFocusBorder(compoundBorder2);
        this.b();
    }

    private void a() {
        StoreSession storeSession = StoreUtil.getCurrentStoreSession();
        if (storeSession == null) {
            return;
        }
        this.d = new ArrayList<CashDrawer>();
        List<Terminal> list = TerminalDAO.getInstance().findCashDrawerTerminals();
        List<CashDrawer> list2 = CashDrawerDAO.getInstance().findByStoreOperationData(storeSession, true);
        for (CashDrawer comparable : list2) {
            if (comparable.getReportTime() != null) continue;
            this.d.add(comparable);
        }
        for (Terminal terminal : list) {
            if (terminal.getCurrentCashDrawer() != null) continue;
            CashDrawer cashDrawer = new CashDrawer();
            cashDrawer.setTerminal(terminal);
            cashDrawer.setAssignedUser(this.h);
            cashDrawer.setOutletId(DataProvider.get().getCurrentOutletId());
            this.d.add(cashDrawer);
        }
        this.c.setRows(this.d);
        this.c.fireTableDataChanged();
    }

    private void b() {
        this.b.setAutoResizeMode(4);
        this.a(1, PosUIManager.getSize(100));
        this.a(2, PosUIManager.getSize(150));
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.b.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    private void c() {
        TransparentPanel transparentPanel = new TransparentPanel();
        this.a = new TitlePanel();
        TransparentPanel transparentPanel2 = new TransparentPanel();
        TransparentPanel transparentPanel3 = new TransparentPanel((LayoutManager)new MigLayout("al center, hidemode 3", "sg, fill", ""));
        JSeparator jSeparator = new JSeparator();
        PosButton posButton = new PosButton();
        JScrollPane jScrollPane = new JScrollPane();
        this.b = new JTable();
        this.b.setRowHeight(PosUIManager.getSize(40));
        this.b.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 40));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        transparentPanel.setLayout(new BorderLayout(5, 5));
        transparentPanel.add((Component)jSeparator, "North");
        PosButton posButton2 = new PosButton(Messages.getString("DrawerAndStaffBankReportDialog.2"));
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoreSessionReportAction storeSessionReportAction = new StoreSessionReportAction(StoreUtil.getCurrentStoreSession());
                storeSessionReportAction.execute();
            }
        });
        this.f = new PosButton(Messages.getString("DrawerAndStaffBankReportDialog.3"));
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawerAndStaffBankReportHistoryDialog drawerAndStaffBankReportHistoryDialog = new DrawerAndStaffBankReportHistoryDialog(Application.getPosWindow(), DrawerAndStaffBankReportDialog.this.h, StoreUtil.getCurrentStoreSession());
                drawerAndStaffBankReportHistoryDialog.setInfo(Messages.getString("DrawerAndStaffBankReportDialog.4"));
                drawerAndStaffBankReportHistoryDialog.setSize(PosUIManager.getSize(880, 580));
                drawerAndStaffBankReportHistoryDialog.open();
            }
        });
        this.g = new PosButton(Messages.getString("DrawerAndStaffBankReportDialog.5"));
        this.g.addActionListener(actionEvent -> this.d());
        transparentPanel3.add(posButton2);
        transparentPanel3.add(this.f);
        transparentPanel3.add(this.g);
        posButton.setText(POSConstants.SAVE_BUTTON_TEXT);
        posButton.addActionListener(actionEvent -> this.a(actionEvent));
        transparentPanel3.add(posButton);
        transparentPanel.add((Component)transparentPanel3, "Center");
        this.getContentPane().add((Component)transparentPanel, "South");
        transparentPanel2.setLayout(new BorderLayout());
        transparentPanel2.add((Component)this.a, "North");
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(10, 15, 10, 15), jScrollPane.getBorder()));
        jScrollPane.setViewportView(this.b);
        transparentPanel2.add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)transparentPanel2, "Center");
        this.setSize(PosUIManager.getSize(830, 550));
    }

    private void a(CashDrawer cashDrawer) {
        if (cashDrawer == null) {
            return;
        }
        if (cashDrawer.getDrawerType() == DrawerType.STAFF_BANK) {
            this.b(cashDrawer);
        } else {
            this.c(cashDrawer);
        }
    }

    private void d() {
        try {
            boolean bl;
            Object object;
            int n;
            Object object2;
            PosWindow posWindow = Application.getPosWindow();
            Store store = DataProvider.get().getStore();
            boolean bl2 = POSUtil.getBoolean(store.getProperty("do_not_allow_close_store_with.open_tickets"));
            boolean bl3 = POSUtil.getBoolean(store.getProperty("do_not_allow_user_clock_out_with.open_tickets"));
            if (bl3 && TicketDAO.getInstance().hasOpenTickets()) {
                POSMessageDialog.showError(Messages.getString("DrawerAndStaffBankReportDialog.7"));
                return;
            }
            List<Ticket> list = TicketDAO.getInstance().findOpenTickets();
            if (list != null && list.size() > 0) {
                object2 = new ServerOpenTicketListDialog(this.h, this.h, false);
                ((ServerOpenTicketListDialog)object2).setTitle(Messages.getString("ClockInOutDialog.121"));
                ((Window)object2).setSize(PosUIManager.getSize(830, 550));
                ((ServerOpenTicketListDialog)object2).setStoreCloseMode(true, !bl2);
                ((ServerOpenTicketListDialog)object2).initData();
                ((POSDialog)object2).open();
                this.a();
                if (((POSDialog)object2).isCanceled()) {
                    return;
                }
            }
            if (PosTransactionDAO.getInstance().hasUnauthorizedTransactions(null).booleanValue() && (n = POSMessageDialog.showYesNoQuestionDialog(this, (String)(object2 = Messages.getString("DrawerAndStaffBankReportDialog.6")), Messages.getString("CONFIRM"))) != 0) {
                return;
            }
            object2 = StoreUtil.getCurrentStoreSession();
            List<CashDrawer> list2 = CashDrawerDAO.getInstance().findByStoreOperationData((StoreSession)object2, true);
            if (list2 != null) {
                object = list2.iterator();
                while (object.hasNext()) {
                    CashDrawer cashDrawer = (CashDrawer)object.next();
                    if (cashDrawer.getReportTime() != null) continue;
                    String string = Messages.getString("DrawerAndStaffBankReportDialog.8");
                    POSMessageDialog.showMessage(this, string);
                    return;
                }
            }
            boolean bl4 = bl = (object = UserDAO.getInstance().findClockedInUsers()) != null && object.size() > 0;
            if (bl && object.size() == 1) {
                boolean bl5 = bl = !((User)object.get(0)).getId().equals(this.h.getId());
            }
            if (bl) {
                String string = Messages.getString("DrawerAndStaffBankReportDialog.9");
                POSMessageDialog.showMessage(this, string);
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("DrawerAndStaffBankReportDialog.10"), Messages.getString("CONFIRM")) != 0) {
                return;
            }
            if (this.h.isClockedIn().booleanValue()) {
                this.a(this.h);
            }
            ((BaseStoreSession)object2).setCloseTime(new Date());
            ((StoreSession)object2).setClosedBy(this.h);
            StoreUtil.closeStore(this.h);
            PosPrintService.printStoreSessionSummaryReport((StoreSession)object2);
            String string = Messages.getString("DrawerAndStaffBankReportDialog.15");
            if (POSMessageDialog.showMessageAndPromtToPrint(string)) {
                PosPrintService.printStoreSessionSummaryReport((StoreSession)object2);
            }
            this.dispose();
            posWindow.updateStatusBarFooterMessage("");
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void a(User user) {
        UserDAO.getInstance().refresh(user);
        AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
        AttendenceHistory attendenceHistory = attendenceHistoryDAO.findByLastClockInTime(user);
        if (attendenceHistory == null) {
            attendenceHistory = AttendenceHistoryDAO.createNewHistory(user, Application.getInstance().getTerminal(), user.getCurrentShift());
        }
        Shift shift = user.getCurrentShift();
        Calendar calendar = Calendar.getInstance();
        user.doClockOut(attendenceHistory, shift, calendar);
        String string = user.getFirstName();
        String string2 = user.getLastName();
        POSMessageDialog.showMessage(Messages.getString("USER") + " " + string + " " + string2 + Messages.getString("ClockInOutAction.10"));
    }

    private void b(CashDrawer cashDrawer) {
        try {
            CashDrawerReportDialog cashDrawerReportDialog = new CashDrawerReportDialog(this.h, cashDrawer);
            cashDrawerReportDialog.setTitle(cashDrawer.getDrawerType() == DrawerType.STAFF_BANK ? Messages.getString("DrawerAndStaffBankReportDialog.19") : POSConstants.DRAWER_PULL_BUTTON_TEXT);
            cashDrawerReportDialog.refreshReport();
            cashDrawerReportDialog.setDefaultCloseOperation(2);
            cashDrawerReportDialog.openFullScreen();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void c(CashDrawer cashDrawer) {
        try {
            if (cashDrawer.getTerminal() == null) {
                return;
            }
            CashDrawerReportDialog cashDrawerReportDialog = new CashDrawerReportDialog(this.h, cashDrawer);
            cashDrawerReportDialog.setTitle(POSConstants.DRAWER_PULL_BUTTON_TEXT);
            cashDrawerReportDialog.refreshReport();
            cashDrawerReportDialog.setDefaultCloseOperation(2);
            cashDrawerReportDialog.openFullScreen();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    public void setInfo(String string) {
        this.a.setTitle(string);
    }

    private void a(ActionEvent actionEvent) {
        this.dispose();
    }

    private void a(int n) {
        try {
            CashDrawer cashDrawer = (CashDrawer)this.c.getRowData(n);
            if (cashDrawer.getId() != null) {
                this.a(cashDrawer);
            } else {
                if (!this.h.isClockedIn().booleanValue()) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DrawerAndStaffBankReportDialog.1"));
                    return;
                }
                DrawerAssignmentAction drawerAssignmentAction = new DrawerAssignmentAction(cashDrawer.getTerminal(), this.h);
                drawerAssignmentAction.execute();
            }
            this.a();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        private SimpleDateFormat b = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");

        TableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            Terminal terminal;
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setIcon(null);
            if (n2 == 0 && (terminal = ((CashDrawer)(object2 = (CashDrawer)DrawerAndStaffBankReportDialog.this.d.get(n))).getTerminal()) != null) {
                if (((CashDrawer)object2).getDrawerType() != DrawerType.STAFF_BANK && terminal.getId().intValue() == DrawerAndStaffBankReportDialog.this.i.getId().intValue()) {
                    jLabel.setIcon(IconFactory.getIcon("/ui_icons/", "check_mark.png"));
                } else if (terminal.getDeviceType() == 1) {
                    jLabel.setIcon(IconFactory.getIcon("/ui_icons/", "mobile_32px.png"));
                }
            }
            if (object instanceof Date) {
                object2 = this.b.format(object);
                jLabel.setText((String)object2);
                jLabel.setHorizontalAlignment(4);
            }
            if (object instanceof Double) {
                jLabel.setHorizontalAlignment(4);
            } else {
                jLabel.setHorizontalAlignment(2);
            }
            if (n2 == 1 || n2 == 2) {
                jLabel.setHorizontalAlignment(0);
            }
            return jLabel;
        }
    }

    class DrawerReportTableModel
    extends ListTableModel<CashDrawer> {
        public DrawerReportTableModel() {
            super(new String[]{Messages.getString("DrawerAndStaffBankReportDialog.20"), Messages.getString("LOCK"), Messages.getString("Type"), Messages.getString("DrawerAndStaffBankReportDialog.22"), ""});
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 1) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public int getRowCount() {
            if (DrawerAndStaffBankReportDialog.this.d == null) {
                return 0;
            }
            int n = DrawerAndStaffBankReportDialog.this.d.size();
            return n;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 4;
        }

        public CashDrawer getSelectedRow() {
            int n = DrawerAndStaffBankReportDialog.this.b.getSelectedRow();
            if (n < 0) {
                return null;
            }
            n = DrawerAndStaffBankReportDialog.this.b.convertRowIndexToModel(n);
            return (CashDrawer)DrawerAndStaffBankReportDialog.this.c.getRowData(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (DrawerAndStaffBankReportDialog.this.d == null) {
                return "";
            }
            CashDrawer cashDrawer = (CashDrawer)DrawerAndStaffBankReportDialog.this.d.get(n);
            User user = cashDrawer.getAssignedUser();
            switch (n2) {
                case 0: {
                    if (cashDrawer.getDrawerType() == DrawerType.DRAWER) {
                        return Messages.getString("DrawerAndStaffBankReportDialog.24") + cashDrawer.getTerminal();
                    }
                    return cashDrawer.getAssignedUser();
                }
                case 1: {
                    return cashDrawer.isLocked();
                }
                case 2: {
                    String string = cashDrawer.getDrawerType().toString();
                    string = StringUtils.isBlank((CharSequence)string) ? "" : string.replaceAll("_", " ");
                    string = string.toLowerCase();
                    DrawerType drawerType = cashDrawer.getDrawerType();
                    if (drawerType == DrawerType.STAFF_BANK) {
                        return string;
                    }
                    Terminal terminal = DataProvider.get().getCurrentTerminal();
                    if (terminal.isSecondCashDrawerAssigned()) {
                        return Messages.getString("SECONDERY") + " " + string;
                    }
                    if (terminal.isTwoCashDrawersEnable()) {
                        return Messages.getString("PRIMARY") + " " + string;
                    }
                    return StringUtils.capitalize((String)string);
                }
                case 3: {
                    if (cashDrawer.getId() == null) {
                        return Messages.getString("DrawerAndStaffBankReportDialog.25");
                    }
                    if (user != null) {
                        return cashDrawer.getReportTime() == null ? Messages.getString("DrawerAndStaffBankReportDialog.26") : Messages.getString("DrawerAndStaffBankReportDialog.27");
                    }
                }
                case 4: {
                    if (cashDrawer.getId() == null) {
                        return Messages.getString("DrawerAndStaffBankReportDialog.28");
                    }
                    return Messages.getString("DrawerAndStaffBankReportDialog.29");
                }
            }
            return "";
        }
    }
}

