/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ItemSearchDialog
extends OkCancelOptionDialog {
    private static final String a = "isdy";
    private static final String b = "isdx";
    private static final String c = "isdheight";
    private static final String d = "isdidth";
    private JTextField e;
    private PosButton f;
    private JTable g;
    private BeanTableModel<MenuItem> h;
    private MenuItem i;
    private OrderType j;
    private static ItemSearchDialog k;

    private ItemSearchDialog() {
        super(POSUtil.getFocusedWindow(), Messages.getString("ItemSearchDialog.4"));
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(PosUIManager.getSize(900, 700));
        this.a();
    }

    private ItemSearchDialog(Frame frame) {
        super((Window)frame, POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(PosUIManager.getSize(900, 700));
        this.a();
    }

    private void a() {
        this.setTitle(Messages.getString("TicketView.7"));
        this.setResizable(false);
        JPanel jPanel = this.getContentPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 15, 0, 15));
        MigLayout migLayout = new MigLayout("fillx, inset 0");
        jPanel.setLayout((LayoutManager)migLayout);
        this.g = new JTable();
        this.g.setRowHeight(40);
        this.g.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 30));
        this.g.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ItemSearchDialog.this.doOk();
                }
            }
        });
        this.g.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ItemSearchDialog.this.doOk();
                }
            }
        });
        this.h = new BeanTableModel(MenuItem.class, 20);
        this.h.addColumn(Messages.getString("ItemSearchDialog.1").toUpperCase(), "barcode");
        this.h.addColumn(Messages.getString("ItemSearchDialog.2"), "sku");
        this.h.addColumn(POSConstants.NAME.toUpperCase(), "displayName");
        this.h.addColumn(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")", "calculatedPrice");
        this.h.addColumn(Messages.getString("MenuItemExplorer.14").toUpperCase(), "availableUnit");
        this.g.setModel(this.h);
        this.e = new JTextField();
        this.e.setFont(this.e.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        this.e.setBackground(Color.WHITE);
        this.f = new PosButton(Messages.getString("Search"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ItemSearchDialog.this.d();
            }
        };
        this.e.addActionListener(actionListener);
        this.f.addActionListener(actionListener);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (ItemSearchDialog.this.e.getText().length() > 2) {
                    ItemSearchDialog.this.d();
                } else if (ItemSearchDialog.this.e.getText().isEmpty()) {
                    ItemSearchDialog.this.h.removeAll();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        };
        this.e.addKeyListener(keyListener);
        jPanel.add((Component)this.e, "spanx,split 2, grow");
        jPanel.add((Component)this.f, "gaptop 0, wrap");
        jPanel.add((Component)new PosScrollPane(this.g), "span, grow");
        QwertyKeyPad qwertyKeyPad = new QwertyKeyPad();
        qwertyKeyPad.setKeyPadListener(keyListener);
        jPanel.add((Component)((Object)qwertyKeyPad), "spanx ,grow");
        this.resizeColumnWidth(this.g);
        this.e.setFocusable(true);
        this.e.requestFocus();
        this.setSize(PosUIManager.getSize(1024, 768));
        this.pack();
    }

    public static synchronized ItemSearchDialog getInstance() {
        if (k == null) {
            k = new ItemSearchDialog();
            k.positionWindow();
            k.pack();
        }
        return k;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.c().get(i));
        }
    }

    public void updateFilterPanel(OrderType orderType) {
        this.j = orderType;
        this.b();
    }

    private void b() {
        try {
            TableColumn tableColumn = this.g.getColumnModel().getColumn(3);
            tableColumn.setHeaderValue(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")");
            this.g.getTableHeader().repaint();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private List c() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(100);
        arrayList.add(100);
        arrayList.add(250);
        arrayList.add(50);
        arrayList.add(50);
        return arrayList;
    }

    @Override
    public void doOk() {
        int n = this.g.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("ItemSearchDialog.3"));
            return;
        }
        this.i = this.h.getRow(n);
        this.h.removeAll();
        this.e.setText("");
        this.setCanceled(false);
        this.dispose();
    }

    public MenuItem getMenuItem() {
        return this.i;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.i = menuItem;
    }

    private void d() {
        String string = this.e.getText();
        if (StringUtils.isEmpty((String)string)) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("ItemSearchDialog.0"));
            return;
        }
        this.h.removeAll();
        MenuItemDAO menuItemDAO = new MenuItemDAO();
        List<MenuItem> list = menuItemDAO.getMenuItemsByNameOrBarcode(this.j, string, true);
        if (list != null && list.size() > 0) {
            this.h.addRows(list);
        }
        this.g.repaint();
    }

    @Override
    public void doCancel() {
        this.e.setText("");
        this.e();
        super.doCancel();
    }

    public void positionWindow() {
        int n = AppConfig.getInt(d, 900);
        int n2 = AppConfig.getInt(c, 650);
        this.setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = dimension.width - n >> 1;
        int n4 = dimension.height - n2 >> 1;
        n3 = AppConfig.getInt(b, n3);
        n4 = AppConfig.getInt(a, n4);
        this.setLocation(n3, n4);
    }

    private void e() {
        AppConfig.putInt(d, this.getWidth());
        AppConfig.putInt(c, this.getHeight());
        AppConfig.putInt(b, this.getX());
        AppConfig.putInt(a, this.getY());
    }
}

