/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.inv;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.services.InventoryService;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TreeDisplayDialog;
import com.floreantpos.ui.inv.InventoryItemEntryDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXTable;

public class InventoryStockInForm
extends BeanEditor<InventoryTransaction> {
    private JButton a;
    private POSTextField b;
    private JLabel c;
    private DefaultMutableTreeNode d;
    private JLabel e;
    private JComboBox<InventoryVendor> f;
    private POSTextField g;
    private JLabel h;
    private InventoryLocation i;
    private TitledBorder j;
    private JXTable k;
    private BeanTableModel<InventoryTransaction> l;
    private JTextField m;
    private JButton n;
    private JButton o;
    private InventoryTransaction p;
    private JComboBox<String> q;
    private List<InventoryTransaction> r;

    public InventoryStockInForm() {
        this((InventoryTransaction)null);
    }

    public InventoryStockInForm(InventoryTransaction inventoryTransaction) {
        InventoryUnit inventoryUnit;
        MenuItem menuItem;
        this.p = inventoryTransaction;
        if (inventoryTransaction != null && StringUtils.isBlank((String)inventoryTransaction.getId()) && (menuItem = inventoryTransaction.getMenuItem()) != null && !menuItem.getUnit().isStockCountable() && (inventoryUnit = menuItem.getBaseUnit()) != null) {
            inventoryTransaction.setUnit(inventoryUnit.getCode());
            inventoryTransaction.setUnitCost(menuItem.getItemCost());
            inventoryTransaction.calculateTotal(inventoryUnit);
        }
        this.d();
        this.a();
        this.setBean(inventoryTransaction);
    }

    private void a() {
        if (this.p.getMenuItem() != null) {
            this.l.addRow(this.p);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < InventoryTransaction.REASON_IN.length; ++i) {
            arrayList.add(InventoryTransaction.REASON_IN[i]);
        }
        this.q.setModel(new ComboBoxModel(arrayList));
        InventoryVendorDAO inventoryVendorDAO = new InventoryVendorDAO();
        ArrayList<InventoryVendor> arrayList2 = new ArrayList<InventoryVendor>();
        arrayList2.add(null);
        arrayList2.addAll(inventoryVendorDAO.findAllEnabled());
        this.f.setModel(new ComboBoxModel(arrayList2));
        this.b.setEditable(false);
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InventoryStockInForm.this.d = InventoryStockInForm.this.b();
                if (InventoryStockInForm.this.d == null) {
                    return;
                }
                InventoryStockInForm.this.i = (InventoryLocation)InventoryStockInForm.this.d.getUserObject();
                InventoryStockInForm.this.b.setText(InventoryStockInForm.this.i.getName());
            }
        });
        InventoryLocation inventoryLocation = InventoryLocationDAO.getInstance().getDefaultInInventoryLocation();
        if (inventoryLocation != null) {
            this.i = inventoryLocation;
            this.b.setText(inventoryLocation.getName());
        }
        this.c();
    }

    private DefaultMutableTreeNode b() {
        List<InventoryLocation> list = InventoryLocationDAO.getInstance().getRootLocations();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (InventoryLocation inventoryLocation : list) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(inventoryLocation);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.a(defaultMutableTreeNode2);
        }
        JTree jTree = new JTree(defaultMutableTreeNode);
        for (int i = 1; i < jTree.getRowCount() * 2; ++i) {
            jTree.expandRow(i);
        }
        jTree.setRootVisible(false);
        TreeDisplayDialog treeDisplayDialog = new TreeDisplayDialog(jTree);
        treeDisplayDialog.setPreferredSize(PosUIManager.getSize(500, 600));
        treeDisplayDialog.open();
        if (treeDisplayDialog.isCanceled()) {
            return null;
        }
        return treeDisplayDialog.getPath();
    }

    private void c() {
        double d = 0.0;
        List<InventoryTransaction> list = this.l.getRows();
        if (list == null) {
            return;
        }
        for (InventoryTransaction inventoryTransaction : list) {
            d += inventoryTransaction.getQuantity() * inventoryTransaction.getUnitCost();
        }
        this.m.setText(NumberUtil.formatNumber(d));
        this.k.repaint();
    }

    private void d() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2", "[][grow][]", ""));
        this.j = new TitledBorder("");
        jPanel.setBorder(this.j);
        this.add((Component)jPanel, "North");
        this.h = new JLabel(Messages.getString("InventoryStockInForm.4"));
        jPanel.add((Component)this.h, "alignx trailing");
        this.g = new POSTextField();
        jPanel.add((Component)this.g, "growx, wrap");
        this.e = new JLabel(Messages.getString("InventoryStockInForm.7"));
        jPanel.add((Component)this.e, "alignx trailing");
        this.f = new JComboBox();
        this.f.setMinimumSize(PosUIManager.getSize(100, 0));
        jPanel.add(this.f, "wrap");
        JLabel jLabel = new JLabel(Messages.getString("InventoryStockInForm.10"));
        jPanel.add((Component)jLabel, "alignx trailing");
        this.q = new JComboBox();
        this.q.setMinimumSize(PosUIManager.getSize(100, 0));
        jPanel.add(this.q, "wrap");
        this.c = new JLabel(Messages.getString("InventoryStockInForm.13"));
        jPanel.add((Component)this.c, "alignx trailing");
        this.b = new POSTextField();
        jPanel.add((Component)this.b, "split 3,growx");
        this.b.setEditable(false);
        this.a = new JButton(Messages.getString("SELECT"));
        jPanel.add(this.a);
        JButton jButton = new JButton(Messages.getString("InventoryStockInForm.17"));
        jPanel.add(jButton);
        jButton.addActionListener(actionEvent -> this.f());
        this.l = new BeanTableModel(InventoryTransaction.class);
        this.l.addColumn(Messages.getString("InventoryStockInForm.0"), "sku");
        this.l.addColumn(Messages.getString("InventoryStockInForm.19"), "itemName");
        this.l.addColumn(Messages.getString("InventoryStockInForm.21"), "quantity", BeanTableModel.EditMode.EDITABLE, 11, BeanTableModel.DataType.NUMBER);
        this.l.addColumn(Messages.getString("InventoryStockInForm.23"), "unitCost", BeanTableModel.EditMode.EDITABLE, 11, BeanTableModel.DataType.MONEY);
        this.l.addColumn(Messages.getString("InventoryStockInForm.25"), "unit");
        this.l.addColumn(Messages.getString("InventoryStockInForm.27"), "total", 11, BeanTableModel.DataType.MONEY);
        this.k = new InventoryTransactionTable(this.l);
        this.l.initTableRenderer((JTable)this.k);
        this.add(new JScrollPane((Component)this.k));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3"));
        this.n = new JButton(Messages.getString("InventoryStockInForm.30"));
        JButton jButton2 = new JButton(Messages.getString("InventoryStockInForm.31"));
        this.o = new JButton(Messages.getString("InventoryStockInForm.32"));
        this.n.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InventoryTransaction inventoryTransaction = new InventoryTransaction();
                inventoryTransaction.setTransactionType(((InventoryTransaction)InventoryStockInForm.this.getBean()).getTransactionType());
                InventoryItemEntryDialog inventoryItemEntryDialog = new InventoryItemEntryDialog(inventoryTransaction);
                inventoryItemEntryDialog.setSize(500, 400);
                inventoryItemEntryDialog.open();
                if (inventoryItemEntryDialog.isCanceled()) {
                    return;
                }
                InventoryStockInForm.this.l.addRow(inventoryItemEntryDialog.getInventoryTransaction());
                InventoryStockInForm.this.c();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (InventoryStockInForm.this.k.getRowCount() == 0) {
                    String string = Messages.getString("InventoryStockInForm.1");
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), string);
                    return;
                }
                int n = InventoryStockInForm.this.k.getSelectedRow();
                if (n == -1) {
                    String string = Messages.getString("InventoryStockInForm.2");
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), string);
                    return;
                }
                int n2 = InventoryStockInForm.this.k.convertRowIndexToModel(n);
                InventoryTransaction inventoryTransaction = (InventoryTransaction)InventoryStockInForm.this.l.getRow(n2);
                if (inventoryTransaction == null) {
                    return;
                }
                InventoryItemEntryDialog inventoryItemEntryDialog = new InventoryItemEntryDialog(inventoryTransaction);
                inventoryItemEntryDialog.setSize(500, 400);
                inventoryItemEntryDialog.open();
                if (inventoryItemEntryDialog.isCanceled()) {
                    return;
                }
                InventoryStockInForm.this.k.repaint();
                InventoryStockInForm.this.c();
            }
        });
        this.o.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (InventoryStockInForm.this.k.getRowCount() == 0) {
                    String string = Messages.getString("InventoryStockInForm.3");
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), string);
                    return;
                }
                int n = InventoryStockInForm.this.k.getSelectedRow();
                if (n == -1) {
                    String string = Messages.getString("InventoryStockInForm.2");
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), string);
                    return;
                }
                int n2 = InventoryStockInForm.this.k.convertRowIndexToModel(n);
                InventoryTransaction inventoryTransaction = (InventoryTransaction)InventoryStockInForm.this.l.getRow(n2);
                if (inventoryTransaction == null) {
                    return;
                }
                InventoryStockInForm.this.l.removeRow(n2);
            }
        });
        jPanel2.add((Component)this.n, "split 3,left");
        jPanel2.add(jButton2);
        jPanel2.add(this.o);
        this.m = new JTextField(16);
        this.m.setHorizontalAlignment(4);
        this.m.setEditable(false);
        jPanel2.add((Component)new JLabel(Messages.getString("InventoryStockInForm.34") + " (" + CurrencyUtil.getCurrencySymbol() + ")"), "split 2,right");
        jPanel2.add((Component)this.m, "");
        this.add((Component)jPanel2, "South");
    }

    private void e() {
        this.k.setAutoResizeMode(4);
        this.a(0, PosUIManager.getSize(100));
        this.a(2, PosUIManager.getSize(80));
        this.a(3, PosUIManager.getSize(100));
        this.a(4, PosUIManager.getSize(80));
        this.a(5, PosUIManager.getSize(120));
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.k.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    private void a(DefaultMutableTreeNode defaultMutableTreeNode) {
        InventoryLocation inventoryLocation = (InventoryLocation)defaultMutableTreeNode.getUserObject();
        List<InventoryLocation> list = null;
        if (inventoryLocation != null) {
            list = inventoryLocation.getChildren();
        }
        if (list == null) {
            return;
        }
        for (InventoryLocation inventoryLocation2 : list) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(inventoryLocation2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.a(defaultMutableTreeNode2);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            InventoryTransactionDAO.getInstance().saveInventoryTransactionList(this.r);
            Store store = DataProvider.get().getStore();
            if (store != null && this.r != null) {
                this.r.forEach(inventoryTransaction -> {
                    MenuItem menuItem = inventoryTransaction.getMenuItem();
                    String string = inventoryTransaction.getUnit();
                    IUnit iUnit = DataProvider.get().getUnitByCode(string);
                    InventoryUnit inventoryUnit = null;
                    if (iUnit instanceof InventoryUnit) {
                        inventoryUnit = (InventoryUnit)iUnit;
                    }
                    InventoryService.getInstance().adjustMenuItemCost(menuItem, inventoryTransaction.getUnitCost(), inventoryTransaction.getQuantity(), inventoryUnit);
                    MenuItemDAO.getInstance().saveOrUpdate(menuItem);
                });
            }
            return true;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(exception.getMessage());
            return false;
        }
    }

    @Override
    public void updateView() {
        InventoryTransaction inventoryTransaction = (InventoryTransaction)this.getBean();
        if (inventoryTransaction == null) {
            return;
        }
        if (inventoryTransaction.getReason() != null) {
            this.q.setSelectedItem(inventoryTransaction.getReason());
        }
        this.c();
    }

    @Override
    public boolean updateModel() {
        this.k.editingStopped(null);
        this.r = this.l.getRows();
        if (this.r == null || this.r.size() == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("InventoryStockInForm.39"));
            return false;
        }
        if (this.i == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("InventoryStockInForm.40"));
            return false;
        }
        for (InventoryTransaction inventoryTransaction : this.r) {
            inventoryTransaction.setOutletId(DataProvider.get().getCurrentOutletId());
            inventoryTransaction.setToInventoryLocation(this.i);
            if (inventoryTransaction.getQuantity() <= 0.0) {
                POSMessageDialog.showMessage(this.getParent(), Messages.getString("InventoryStockInForm.41"));
                return false;
            }
            if (inventoryTransaction.getUnit().isEmpty()) {
                POSMessageDialog.showMessage(this.getParent(), Messages.getString("InventoryStockInForm.42"));
                return false;
            }
            inventoryTransaction.setTransactionDate(new Date());
            String string = (String)this.q.getSelectedItem();
            if (StringUtils.isEmpty((String)string)) {
                POSMessageDialog.showMessage(this.getParent(), Messages.getString("InventoryStockInForm.43"));
                return false;
            }
            inventoryTransaction.setReason(string);
            inventoryTransaction.setVendor((InventoryVendor)this.f.getSelectedItem());
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("InventoryStockInForm.44");
    }

    private void f() {
        this.i = null;
        this.b.setText("");
    }

    private class InventoryTransactionTable
    extends PosTable {
        public InventoryTransactionTable(BeanTableModel<InventoryTransaction> beanTableModel) {
            super(beanTableModel);
        }

        public void setValueAt(Object object, int n, int n2) {
            InventoryTransaction inventoryTransaction = (InventoryTransaction)InventoryStockInForm.this.l.getRow(n);
            String string = object.toString();
            if (string.isEmpty()) {
                return;
            }
            double d = NumberUtil.parseDouble(string);
            if (n2 == 2) {
                if (d < 0.0) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NegativeValueNotAllowed"));
                    return;
                }
                if (!inventoryTransaction.getMenuItem().isFractionalUnit().booleanValue() && NumberUtil.isFractional(d).booleanValue()) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("FractionalQuantityNotAllowed"));
                    return;
                }
                inventoryTransaction.setQuantity(d);
                inventoryTransaction.setTotal(inventoryTransaction.getQuantity() * inventoryTransaction.getUnitCost());
                InventoryStockInForm.this.c();
            }
            if (n2 == 3) {
                if (d < 0.0) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuItemForm.11"));
                    return;
                }
                inventoryTransaction.setUnitCost(d);
                inventoryTransaction.setTotal(inventoryTransaction.getQuantity() * inventoryTransaction.getUnitCost());
                InventoryStockInForm.this.c();
            }
        }
    }
}

