/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.LogoutAction;
import com.floreantpos.actions.ShowOrderStatusAction;
import com.floreantpos.config.TerminalProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.kitchendisplay.KitchenActionButton;
import com.floreantpos.ui.kitchendisplay.KitchenDisplayConfigDialog;
import com.floreantpos.ui.kitchendisplay.KitchenDisplayView;
import com.floreantpos.ui.kitchendisplay.KitchenFilterDialog;
import com.floreantpos.ui.kitchendisplay.KitchenTicketActionListener;
import com.floreantpos.ui.kitchendisplay.KitchenTicketView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.KitchenTicketUtill;
import com.floreantpos.util.OrgJsonUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import com.orocube.rest.service.mqtt.OroMqttDataListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jiconfont.IconCode;
import jiconfont.icons.FontAwesome;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.hibernate.StaleStateException;
import org.json.JSONObject;

public class KitchenTicketListPanel
extends JPanel
implements KitchenTicketActionListener,
OroMqttDataListener,
ActionListener {
    private static final int a = 0;
    private static final int b = 0;
    private PaginatedListModel c = new PaginatedListModel();
    private JPanel d;
    private TitledBorder e;
    private KitchenActionButton f;
    private KitchenActionButton g;
    private KitchenActionButton h;
    private KitchenActionButton i;
    private KitchenActionButton j;
    private KitchenActionButton k;
    private KitchenActionButton l;
    private KitchenActionButton m;
    private KitchenActionButton n;
    private JLabel o;
    private int p = 4;
    private List<VirtualPrinter> q;
    private List<OrderType> r;
    private PosBlinkButton s;
    private KitchenActionButton t;
    private Stack<KitchenTicket> u = new Stack();
    private static final Color v = Color.white;
    private static final Color w = Color.black;
    private KitchenActionButton x;
    private boolean y;

    public KitchenTicketListPanel() {
        this.e = new TitledBorder("");
        this.e.setTitleJustification(2);
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(new CompoundBorder(this.e, new EmptyBorder(0, 0, 0, 0)));
        this.d = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.d.setOpaque(false);
        this.add(this.d);
        Dimension dimension = PosUIManager.getSize(90, 40);
        Color color = Color.white;
        Color color2 = Color.white;
        Color color3 = Color.white;
        this.f = new KitchenActionButton("", v, w);
        this.g = new KitchenActionButton(Messages.getString("KitchenTicketListPanel.6"), v, w);
        this.j = new KitchenActionButton(POSConstants.CLOSE, v, w);
        this.i = new KitchenActionButton(Messages.getString("KitchenTicketListPanel.2"), v, w);
        this.h = new KitchenActionButton(POSConstants.FILTER, color3);
        this.x = new KitchenActionButton(Messages.getString("OPTION"), color2);
        this.t = new KitchenActionButton(Messages.getString("KitchenTicketListPanel.1"), color);
        this.m = new KitchenActionButton(POSConstants.CAPITAL_PREV, v, w);
        this.k = new KitchenActionButton(POSConstants.CAPITAL_NEXT, v, w);
        this.l = new KitchenActionButton(Messages.getString("KitchenTicketListPanel.3") + " 1", v, w);
        this.n = new KitchenActionButton(Messages.getString("BUMP_ALL"), v, w);
        this.o = new JLabel();
        this.s = new PosBlinkButton(){

            @Override
            public Color getBackground() {
                if (KitchenTicketListPanel.this.s == null) {
                    return Color.white;
                }
                return super.getBackground();
            }

            @Override
            public Color getForeground() {
                if (KitchenTicketListPanel.this.s == null || !KitchenTicketListPanel.this.s.isBlinking()) {
                    return Color.black;
                }
                return Color.white;
            }
        };
        this.s.setFont(this.s.getFont().deriveFont(1));
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KitchenTicketListPanel.this.e();
            }
        });
        this.i.setBtnToogle(true);
        this.i.setCellButton(false);
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KitchenTicketListPanel.this.setDispatchMode(!KitchenTicketListPanel.this.i.isSelected());
            }
        });
        this.x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KitchenDisplayConfigDialog kitchenDisplayConfigDialog = new KitchenDisplayConfigDialog();
                kitchenDisplayConfigDialog.pack();
                kitchenDisplayConfigDialog.open();
                if (kitchenDisplayConfigDialog.isCanceled()) {
                    return;
                }
                KitchenTicketListPanel.this.c.setCurrentRowIndex(0);
                KitchenTicketListPanel.this.updateKDSView();
                KitchenDisplayView.getInstance().updateView();
            }
        });
        this.n.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KitchenTicketListPanel.this.d();
            }
        });
        this.f.setAction(new LogoutAction(true, false));
        this.f.setText(POSConstants.LOGOUT);
        this.g.setAction(new ShowOrderStatusAction());
        this.t.setEnabled(false);
        this.t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KitchenTicketListPanel.this.unbump();
            }
        });
        this.s.setText(POSConstants.REFRESH);
        this.s.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KitchenTicketListPanel.this.c.setCurrentRowIndex(0);
                KitchenTicketListPanel.this.updateKDSView();
            }
        });
        this.s.setBorder(null);
        this.s.setOpaque(true);
        ScrollAction scrollAction = new ScrollAction();
        this.m.addActionListener(scrollAction);
        this.k.addActionListener(scrollAction);
        this.k.setEnabled(false);
        this.m.setEnabled(false);
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KitchenTicketListPanel.this.a();
            }
        });
        int n = PosUIManager.getSize(16);
        this.m.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.BACKWARD, (float)n));
        this.k.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.FORWARD, (float)n));
        this.k.setHorizontalTextPosition(2);
        this.s.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.REFRESH, (float)n));
        this.h.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.FILTER, (float)n));
        this.t.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.UNDO, (float)n));
        this.j.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.WINDOW_CLOSE, (float)n));
        this.f.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.ARROW_CIRCLE_O_LEFT, (float)n));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 0,hidemode 3", "[]2px[]", ""));
        jPanel.setOpaque(false);
        String string = "w " + (dimension.width + 7) + "!, growy,gap 1";
        jPanel.add(this.f);
        jPanel.add((Component)this.j, string);
        jPanel.add(this.g);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3, ins 0 2 3 2", "[][grow][]", "[]"));
        JSeparator jSeparator = new JSeparator();
        jSeparator.setBackground(Color.white);
        jSeparator.setForeground(Color.white);
        jSeparator.setPreferredSize(PosUIManager.getSize(0, 5));
        jPanel2.add((Component)jSeparator, "growx,span");
        jPanel2.add((Component)jPanel, "growy");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("ins 0 2 3 2,hidemode 3", "[]1[]", ""));
        jPanel3.setOpaque(false);
        jPanel3.add((Component)this.n, string);
        jPanel3.add((Component)this.i, string);
        jPanel3.add((Component)this.h, string);
        jPanel3.add((Component)this.x, string);
        jPanel3.add((Component)this.t, string);
        jPanel3.add((Component)this.s, string);
        jPanel2.add((Component)jPanel3, "center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        jPanel4.add(this.m);
        jPanel4.add(this.l);
        jPanel4.add(this.k);
        jPanel4.add(this.o);
        jPanel2.add((Component)jPanel4, "right");
        this.add((Component)jPanel2, "South");
        jPanel2.setBackground(Color.black);
    }

    public void setBackButtonVisible(boolean bl) {
        this.j.setVisible(bl);
        this.f.setVisible(!bl);
    }

    private void a() {
        KitchenFilterDialog kitchenFilterDialog = new KitchenFilterDialog();
        kitchenFilterDialog.open();
        if (kitchenFilterDialog.isCanceled()) {
            return;
        }
        this.q = kitchenFilterDialog.getPrinter();
        this.r = kitchenFilterDialog.getOrderType();
        this.g();
    }

    public void updateKDSView() {
        this.reset();
        try {
            Terminal terminal = Application.getInstance().getTerminal();
            int n = TerminalProperties.getKDSTicketsPerPage(terminal);
            this.p = (int)Math.round((double)n / 2.0);
            this.c.setPageSize(n);
            KitchenTicketDAO.getInstance().loadItems(terminal, this.y ? true : this.i.isSelected(), this.c, TerminalProperties.isKDSShowOldestTicketFirst(terminal));
            this.s.setBlinking(false);
            this.setDataModel(this.c);
            this.u.clear();
            PosLog.info(this.getClass(), "Undo stack is cleared");
            this.refreshUndoRedo();
            this.b();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    protected void setDataModel(PaginatedListModel paginatedListModel) {
        this.c = paginatedListModel;
        this.renderItems();
    }

    protected void updateButton() {
        boolean bl = this.c.hasNext();
        boolean bl2 = this.c.hasPrevious();
        this.k.setVisible(bl || bl2);
        this.m.setVisible(bl || bl2);
        this.m.setEnabled(bl2);
        this.k.setEnabled(bl);
    }

    public PaginatedListModel getDataModel() {
        return this.c;
    }

    public void reset() {
        Component[] componentArray;
        for (Component component : componentArray = this.d.getComponents()) {
            if (!(component instanceof KitchenTicketView)) continue;
            KitchenTicketView kitchenTicketView = (KitchenTicketView)component;
            kitchenTicketView.stopTimer();
        }
        this.d.removeAll();
        this.d.repaint();
        this.k.setEnabled(false);
        this.m.setEnabled(false);
    }

    protected void renderItems() {
        try {
            int n;
            this.reset();
            Terminal terminal = Application.getInstance().refreshAndGetTerminal();
            if (this.c == null || this.c.getSize() == 0) {
                this.k.setEnabled(this.c.hasNext());
                this.m.setEnabled(this.c.hasPrevious());
                return;
            }
            int n2 = TerminalProperties.getKDSTicketsPerPage(terminal);
            if (n2 <= 5) {
                this.d.setLayout(new GridLayout(1, n2, 5, 5));
            } else {
                n = (int)Math.ceil((double)n2 / 2.0);
                this.d.setLayout(new GridLayout(2, n, 5, 5));
            }
            this.d.setOpaque(false);
            for (n = 0; n < n2; ++n) {
                TransparentPanel transparentPanel;
                if (n >= this.c.getSize()) {
                    transparentPanel = new TransparentPanel();
                    this.d.add(transparentPanel);
                    continue;
                }
                transparentPanel = this.c.getElementAt(n);
                JPanel jPanel = this.createKitchenTicket(transparentPanel, n);
                if (jPanel == null) continue;
                this.d.add(jPanel);
            }
            this.k.setEnabled(this.c.hasNext());
            this.m.setEnabled(this.c.hasPrevious());
            this.refreshUndoRedo();
            this.revalidate();
            this.repaint();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    protected void scrollDown() {
        if (!this.c.hasNext()) {
            return;
        }
        this.u.clear();
        PosLog.info(this.getClass(), "Undo stack is cleared");
        this.c.setCurrentRowIndex(this.c.getNextRowIndex());
        this.updateKDSView();
    }

    private void b() {
        String string = Messages.getString("KitchenTicketListPanel.3");
        String string2 = String.valueOf(this.c.getCurrentRowIndex() / this.c.getPageSize() + 1);
        int n = (int)Math.ceil((double)this.c.getNumRows() / (double)this.c.getPageSize());
        this.l.setText(string + " " + string2 + " of " + n);
    }

    protected void scrollUp() {
        if (!this.c.hasPrevious()) {
            return;
        }
        this.u.clear();
        PosLog.info(this.getClass(), "Undo stack is cleared");
        this.c.setCurrentRowIndex(this.c.getPreviousRowIndex());
        this.updateKDSView();
    }

    protected JPanel createKitchenTicket(Object object, int n) {
        KitchenTicket kitchenTicket = (KitchenTicket)object;
        kitchenTicket.setSortOrder(n);
        if (kitchenTicket.getId() == null) {
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            return jPanel;
        }
        KitchenTicketView kitchenTicketView = new KitchenTicketView(kitchenTicket, this);
        kitchenTicketView.putClientProperty("key", n + 1);
        return kitchenTicketView;
    }

    public void scrollKitchenTicket(int n) {
        Component[] componentArray = this.d.getComponents();
        if (componentArray.length == 0) {
            return;
        }
        for (Component component : componentArray) {
            KitchenTicketView kitchenTicketView;
            if (!(component instanceof KitchenTicketView) || !(kitchenTicketView = (KitchenTicketView)component).isKeySelected()) continue;
            if (n == 40) {
                kitchenTicketView.scrollKitchenTicket(0, 1);
            } else if (n == 38) {
                kitchenTicketView.scrollKitchenTicket(0, -1);
            }
            return;
        }
    }

    public void setSelectedKey(int n) {
        if (PosGuiUtil.isModalDialogShowing()) {
            return;
        }
        if (n == 10) {
            this.updateKDSView();
            return;
        }
        if (n == 81) {
            Application.getInstance().doLogout();
            return;
        }
        if (n == 85 && !this.i.isSelected()) {
            this.unbump();
            return;
        }
        Component[] componentArray = this.d.getComponents();
        if (componentArray.length == 0) {
            return;
        }
        if (n == 78) {
            this.scrollDown();
            return;
        }
        if (n == 80) {
            this.scrollUp();
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (Component component : componentArray) {
            if (component instanceof KitchenTicketView) {
                boolean bl3;
                KitchenTicketView kitchenTicketView = (KitchenTicketView)component;
                if (kitchenTicketView.isKeySelected() && (n == 66 || n == 32)) {
                    kitchenTicketView.fireBumpSelected();
                    return;
                }
                if (n != 37 && n != 39 && n != 40 && n != 38 && (bl3 = kitchenTicketView.keySelected(n))) {
                    bl2 = true;
                }
                if (kitchenTicketView.isKeySelected()) {
                    bl = true;
                    n3 = n4;
                    n2 = n4;
                }
            }
            ++n4;
        }
    }

    public PaginatedListModel getModel() {
        return this.c;
    }

    public void refreshUndoRedo() {
        PosLog.info(this.getClass(), "Refresh undo status: undo stack size: " + this.u.size());
        this.t.setEnabled(!this.u.isEmpty());
    }

    @Override
    public boolean isDispatchMode() {
        if (this.i != null) {
            return this.i.isSelected();
        }
        return false;
    }

    @Override
    public void dispatch(KitchenTicketView kitchenTicketView) {
        try {
            KitchenTicket kitchenTicket = kitchenTicketView.getTicket();
            Ticket ticket = TicketDAO.getInstance().loadFullTicket(kitchenTicket.getTicketId());
            KitchenTicketDAO.getInstance().bumpOrUnbump(kitchenTicket, KitchenStatus.DISPATCHED, KitchenStatus.DISPATCHED, false);
            KitchenTicketDAO.getInstance().delete(kitchenTicket);
            this.updateKDSView();
            this.a(kitchenTicket, ticket);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("KitchenTicketListPanel.0"), staleStateException);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void bump(KitchenTicketView kitchenTicketView) {
        try {
            KitchenTicket kitchenTicket = kitchenTicketView.getTicket();
            KitchenTicketUtill.bumpOrUnbumpKitchenTicket(kitchenTicket);
            PosLog.info(this.getClass(), "Pusing into undo stack");
            this.u.push(kitchenTicket);
            PosLog.info(this.getClass(), "Undo stack size: " + this.u.size());
            this.c.getDataList().set(kitchenTicket.getSortOrder(), new KitchenTicket());
            this.renderItems();
            this.c();
            OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "REFRESH_DISPATCH_VIEW");
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("KitchenTicketListPanel.0"), staleStateException);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void c() throws Exception {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("terminalKey", (Object)TerminalUtil.getSystemUID());
            jSONObject.put("command", (Object)"3");
            jSONObject.put("isKds", (Object)Boolean.TRUE);
            OroMqttClient.getInstance().publishData("MQTT-COMMAND-KIT-DIS-UPDATE", jSONObject.toString());
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void a(Set<Ticket> set) throws Exception {
        for (Ticket ticket : set) {
            KitchenTicketUtill.printKitchenTicketOnBump(ticket);
        }
    }

    private void a(KitchenTicket kitchenTicket, Ticket ticket) throws Exception {
    }

    public void bumpAll() {
        try {
            List list = this.c.getDataList();
            if (list.isEmpty()) {
                POSMessageDialog.showError(this, Messages.getString("KitchenTicketListPanel.4"));
                return;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("KitchenTicketListPanel.5"), Messages.getString("CONFIRM"));
            if (n != 0) {
                return;
            }
            HashSet<Ticket> hashSet = new HashSet<Ticket>();
            for (KitchenTicket kitchenTicket : list) {
                if (kitchenTicket.getId() == null) continue;
                Ticket ticket = TicketDAO.getInstance().loadFullTicket(kitchenTicket.getTicketId());
                KitchenTicketDAO.getInstance().bumpOrUnbump(kitchenTicket, ticket, KitchenStatus.BUMP, KitchenStatus.BUMP, true);
                this.a(kitchenTicket, ticket);
                if (ticket == null) continue;
                hashSet.add(ticket);
            }
            this.a(hashSet);
            this.c.getDataList().clear();
            this.renderItems();
            this.c.getDataList().clear();
            this.renderItems();
            this.refreshUndoRedo();
            this.c();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("KitchenTicketListPanel.0"), staleStateException);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void d() {
        try {
            if (this.i.isSelected()) {
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("KitchenTicketListPanel.7"), Messages.getString("CONFIRM"));
                if (n != 0) {
                    return;
                }
                KitchenTicketDAO.getInstance().dispatchAll();
                this.updateKDSView();
            } else {
                this.bumpAll();
                this.updateKDSView();
            }
            OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "REFRESH_DISPATCH_VIEW");
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    public void unbump() {
        PosLog.info(this.getClass(), "Unbump: Undo stack size: " + this.u.size());
        if (this.u.isEmpty()) {
            return;
        }
        KitchenTicket kitchenTicket = this.u.pop();
        try {
            KitchenTicketDAO.getInstance().refresh(kitchenTicket);
            KitchenTicketDAO.getInstance().bumpOrUnbump(kitchenTicket, KitchenStatus.WAITING, KitchenStatus.WAITING, false);
            this.c.getDataList().set(kitchenTicket.getSortOrder(), kitchenTicket);
            this.renderItems();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    public boolean isBlinkingRefreshButton() {
        return this.s.isBlinking();
    }

    public void setBlinkingRefreshButton(boolean bl) {
        this.s.setBlinking(bl);
        Window window = SwingUtilities.getWindowAncestor(this);
        window.toFront();
    }

    private void e() {
        Window window = this.f();
        if (window == null) {
            RootView.getInstance().showDefaultView();
        } else {
            window.dispose();
        }
    }

    private Window f() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JFrame) {
            return window;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (PosGuiUtil.isModalDialogShowing()) {
            return;
        }
        this.d.repaint();
        if (this.isBlinkingRefreshButton()) {
            return;
        }
        Date date = KitchenTicketDAO.getInstance().getLastUpdateDate();
        if (date == null) {
            return;
        }
    }

    public void subscribeToNotificationService() {
        PosLog.info(this.getClass(), "subscribing to update notification");
        OroMqttClient.getInstance().addDataListener(this);
        if (OroMqttClient.getInstance().isConnectedToServer()) {
            this.mqttConnected();
        } else {
            this.mqttConnectionLost();
        }
    }

    public void unsubscribeFromNotificationService() {
        PosLog.info(this.getClass(), "unsubscribing from update notification");
        OroMqttClient.getInstance().removeDataListener(this);
    }

    @Override
    public void refreshKDSRequestReceived(String string, MqttMessage mqttMessage) {
        if (!this.a(mqttMessage)) {
            return;
        }
        Terminal terminal = Application.getInstance().getTerminal();
        if (TerminalProperties.isKDSAutoRefresh(terminal)) {
            Toolkit.getDefaultToolkit().beep();
            this.c.setCurrentRowIndex(0);
            this.updateKDSView();
        } else {
            this.s.setBlinking(true);
        }
    }

    private boolean a(MqttMessage mqttMessage) {
        String string = new String(mqttMessage.getPayload());
        JSONObject jSONObject = new JSONObject(string);
        String string2 = OrgJsonUtil.getString(jSONObject, "terminalKey");
        if (StringUtils.isEmpty((String)string2)) {
            return false;
        }
        String string3 = OrgJsonUtil.getString(jSONObject, "command");
        if (StringUtils.isEmpty((String)string3)) {
            return false;
        }
        boolean bl = OrgJsonUtil.getBoolean(jSONObject, "isKds");
        return !bl || !string2.equals(TerminalUtil.getSystemUID());
    }

    @Override
    public void refreshDispatchView(String string, MqttMessage mqttMessage) {
        if (!this.y) {
            return;
        }
        Terminal terminal = Application.getInstance().getTerminal();
        if (TerminalProperties.isKDSAutoRefresh(terminal)) {
            Toolkit.getDefaultToolkit().beep();
            this.g();
        } else {
            this.s.setBlinking(this.y);
        }
    }

    @Override
    public void pushToStacK(KitchenTicket kitchenTicket) {
        if (kitchenTicket != null) {
            PosLog.info(this.getClass(), "Pushing into undo stack");
            this.u.push(kitchenTicket);
            PosLog.info(this.getClass(), "Undo stack size: " + this.u.size());
        }
        this.refreshUndoRedo();
    }

    public void setDispatchMode(boolean bl) {
        this.y = bl;
        this.i.setSelected(bl);
        if (bl) {
            this.n.setText(Messages.getString("DISPATCH_ALL"));
        } else {
            this.n.setText(Messages.getString("BUMP_ALL"));
        }
        this.g();
    }

    private void g() {
        this.getDataModel().setCurrentRowIndex(0);
        this.updateKDSView();
    }

    public void setDispatchButtonVisible(boolean bl) {
        this.i.setVisible(bl);
    }

    public JLabel getLblMqttIcon() {
        return this.o;
    }

    @Override
    public void mqttConnectionLost() {
        this.o.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NOTIFICATIONS_OFF, (float)PosUIManager.getSize(32), (Color)Color.white));
        this.o.setToolTipText("Notification service off.");
    }

    @Override
    public void mqttConnected() {
        this.o.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NOTIFICATIONS_ACTIVE, (float)PosUIManager.getSize(32), (Color)Color.white));
        this.o.setToolTipText("Notification service on.");
    }

    private class ScrollAction
    implements ActionListener {
        private ScrollAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Object object = actionEvent.getSource();
                if (object == KitchenTicketListPanel.this.m) {
                    KitchenTicketListPanel.this.scrollUp();
                } else if (object == KitchenTicketListPanel.this.k) {
                    KitchenTicketListPanel.this.scrollDown();
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
            }
        }
    }
}

