/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.Currency;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.AutoCompletionComboBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class CurrencyForm
extends BeanEditor<Currency> {
    private FixedLengthTextField a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private DoubleTextField d;
    private DoubleTextField e;
    private JCheckBox f;
    private AutoCompletionComboBox g;
    private JLabel h;
    private JLabel i;

    public CurrencyForm() {
        this(new Currency());
    }

    public CurrencyForm(Currency currency) {
        this.a(currency);
        this.a();
        this.setBean(currency);
    }

    private void a() {
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        comboBoxModel.setDataList(CurrencyUtil.getAllPreFillCurrencies());
        this.g.setModel(comboBoxModel);
    }

    private void a(Currency currency) {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        JLabel jLabel = new JLabel(Messages.getString("CurrencyForm.1"));
        this.a = new FixedLengthTextField(10);
        JLabel jLabel2 = new JLabel(POSConstants.NAME + ":");
        this.b = new FixedLengthTextField();
        this.h = new JLabel(Messages.getString("CurrencyForm.3"));
        this.d = new DoubleTextField();
        this.i = new JLabel(Messages.getString("CurrencyForm.4"));
        this.e = new DoubleTextField();
        JLabel jLabel3 = new JLabel(Messages.getString("CurrencyForm.5"));
        this.c = new FixedLengthTextField(8);
        this.f = new JCheckBox(Messages.getString("CurrencyForm.6"));
        this.f.setEnabled(currency.isMain() == false);
        this.g = new AutoCompletionComboBox();
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Currency currency = (Currency)jComboBox.getSelectedItem();
                CurrencyForm.this.b.setText(currency.getName());
                CurrencyForm.this.c.setText(currency.getSymbol());
                CurrencyForm.this.a.setText(currency.getCode());
                CurrencyForm.this.d.setText(NumberUtil.format6DigitNumber(currency.getExchangeRate()));
                CurrencyForm.this.e.setText(NumberUtil.formatNumber(currency.getTolerance()));
            }
        });
        jPanel.add((Component)new JLabel(Messages.getString("CurrencyForm.7")), "");
        jPanel.add((Component)this.g, "grow, wrap");
        jPanel.add((Component)jLabel2, "");
        jPanel.add((Component)this.b, "grow, wrap");
        jPanel.add((Component)jLabel, "");
        jPanel.add((Component)this.a, "grow, wrap");
        jPanel.add((Component)jLabel3, "");
        jPanel.add((Component)this.c, "grow, wrap");
        jPanel.add((Component)this.h, "");
        jPanel.add((Component)this.d, "grow, wrap");
        jPanel.add((Component)this.i, "");
        jPanel.add((Component)this.e, "grow, wrap");
        jPanel.add((Component)this.f, "");
        this.add(jPanel);
        this.f.addActionListener(actionEvent -> {
            int n;
            Currency currency = CurrencyDAO.getInstance().getMainCurrency();
            if (this.f.isSelected() && (n = POSMessageDialog.showYesNoQuestionDialog(String.format(Messages.getString("CurrencyForm.11"), currency.getName()), POSConstants.CONFIRM)) != 0) {
                this.f.setSelected(false);
                return;
            }
        });
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Currency currency = (Currency)this.getBean();
            CurrencyDAO currencyDAO = new CurrencyDAO();
            currencyDAO.saveOrUpdate(currency);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
            return false;
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Currency currency = (Currency)this.getBean();
        if (currency == null || StringUtils.isEmpty((String)currency.getId())) {
            return;
        }
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.g.getModel();
        List list = comboBoxModel.getDataList();
        for (Currency currency2 : list) {
            if (!currency2.getCode().equals(currency.getCode())) continue;
            this.g.setSelectedItem((Object)currency2);
        }
        this.a.setText(currency.getCode());
        this.b.setText(currency.getName());
        this.c.setText(currency.getSymbol());
        this.d.setText(NumberUtil.format6DigitNumber(currency.getExchangeRate()));
        this.e.setText(NumberUtil.formatNumber(currency.getTolerance()));
        this.f.setSelected(currency.isMain());
    }

    @Override
    protected boolean updateModel() {
        Currency currency = (Currency)this.getBean();
        if (currency == null) {
            return false;
        }
        String string = this.b.getText();
        String string2 = this.a.getText();
        if (POSUtil.isBlankOrNull(string2)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CurrencyForm.0"));
            return false;
        }
        String string3 = this.c.getText();
        if (POSUtil.isBlankOrNull(string3)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CurrencyForm.65"));
            return false;
        }
        double d = this.d.getDoubleOrZero();
        if (d <= 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CurrencyForm.8"));
            return false;
        }
        if (this.f.isSelected() && d != 1.0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CurrencyForm.2"));
            return false;
        }
        double d2 = this.e.getDoubleOrZero();
        if (d2 < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CurrencyForm.9"));
            return false;
        }
        if (d2 > 2.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CurrencyForm.10") + string3 + ".");
            return false;
        }
        GenericDAO.getInstance().checkIdOrNameExists(currency.getId(), string, Currency.class);
        GenericDAO.getInstance().checkDifferentObjectExists(currency.getId(), string2, Currency.class, Currency.PROP_CODE);
        GenericDAO.getInstance().checkDifferentObjectExists(currency.getId(), string3, Currency.class, Currency.PROP_SYMBOL);
        currency.setCode(string2);
        currency.setName(string);
        currency.setSymbol(string3);
        currency.setMain(this.f.isSelected());
        if (d == 0.0) {
            currency.setExchangeRate(1.0);
        } else {
            currency.setExchangeRate(d);
        }
        currency.setTolerance(d2);
        return true;
    }

    @Override
    public String getDisplayText() {
        Currency currency = (Currency)this.getBean();
        if (currency.getId() == null) {
            return Messages.getString("CurrencyForm.20");
        }
        return Messages.getString("CurrencyForm.21");
    }

    public void setSimpleMode(boolean bl) {
        this.h.setVisible(!bl);
        this.d.setVisible(!bl);
        this.i.setVisible(!bl);
        this.e.setVisible(!bl);
        this.f.setVisible(!bl);
    }
}

