/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.InventoryPlugin;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PosColor;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.base.BaseMenuItemSize;
import com.floreantpos.model.base.BasePizzaCrust;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IUpdatebleView;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.POSColorComboBox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PizzaPriceView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.menuitem.OrderTypeBaseTaxPanel;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.ui.model.TaxForm;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumnModel;
import modifiertab.ModifierTabView;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PizzaItemForm
extends BeanEditor<MenuItem>
implements ChangeListener {
    private JTabbedPane a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private DoubleTextField d;
    private DoubleTextField e;
    private FixedLengthTextField f;
    private JCheckBox g;
    private IntegerTextField h;
    private OverflowCombobox i;
    private OverflowCombobox j;
    private JTextArea k;
    private JLabel l;
    private JButton m;
    private JCheckBox n;
    private JCheckBox o;
    private JCheckBox p;
    private JLabel q;
    private POSColorComboBox r;
    private POSColorComboBox s;
    private final MenuItem t;
    private ImageResource u;
    private JComboBox<MenuGroup> v;
    private OrderTypeBaseTaxPanel w;
    private JLabel x;
    private FixedLengthTextField y = new FixedLengthTextField(10, 20);
    private JComboBox z;
    private InventoryPlugin A = (InventoryPlugin)ExtensionManager.getPlugin(InventoryPlugin.class);
    private ModifierTabView B;
    private PizzaPriceView C;

    public PizzaItemForm() throws Exception {
        this(new MenuItem());
    }

    public PizzaItemForm(MenuItem menuItem) throws Exception {
        this.t = menuItem;
        menuItem.setPizzaType(true);
        this.b();
        this.a();
    }

    private void a() {
        List<MenuGroup> list = MenuGroupDAO.getInstance().findAll();
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        for (MenuGroup serializable2 : list) {
            comboBoxModel.addElement(serializable2);
        }
        this.v.setModel(comboBoxModel);
        List<TaxGroup> list2 = TaxGroupDAO.getInstance().findAll();
        ComboBoxModel comboBoxModel2 = new ComboBoxModel();
        comboBoxModel2.addElement((Object)null);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            TaxGroup taxGroup = (TaxGroup)iterator.next();
            comboBoxModel2.addElement(taxGroup);
        }
        this.j.setModel(comboBoxModel2);
        this.w.setTaxGroups(list2);
        this.setBean(this.t);
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog imageGalleryDialog = ImageGalleryDialog.getInstance();
        imageGalleryDialog.setSelectBtnVisible(true);
        imageGalleryDialog.setTitle(VersionInfo.getAppName());
        imageGalleryDialog.setResizable(false);
        imageGalleryDialog.openFullScreen();
        if (imageGalleryDialog.isCanceled()) {
            return;
        }
        this.u = imageGalleryDialog.getImageResource();
        if (this.u != null) {
            this.l.setIcon(this.u.getButtonImage(100, 100));
        }
    }

    protected void doClearImage() {
        this.l.setIcon(null);
        this.u = null;
    }

    private void b() {
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Messages.getString("MenuItemForm.19"));
        this.a = new JTabbedPane();
        JPanel jPanel = new JPanel();
        JLabel jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(11);
        this.b = new FixedLengthTextField(20);
        this.k = new JTextArea(new FixedLengthDocument(220));
        this.C = new PizzaPriceView(this.t);
        JLabel jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(11);
        this.i = new OverflowCombobox();
        this.j = new OverflowCombobox();
        JButton jButton = new JButton();
        JPanel jPanel2 = new JPanel();
        JButton jButton2 = new JButton();
        ArrayList<PrinterGroup> arrayList = new ArrayList<PrinterGroup>();
        arrayList.add(null);
        List<PrinterGroup> list = PrinterGroupDAO.getInstance().findAll();
        if (list != null && list.size() > 0) {
            arrayList.addAll(list);
        }
        ComboBoxModel comboBoxModel = new ComboBoxModel(arrayList);
        this.i.setModel(comboBoxModel);
        this.h = new IntegerTextField(10);
        this.c = new FixedLengthTextField(20);
        this.c.setLength(120);
        this.d = new DoubleTextField();
        this.d.setEditable(false);
        this.e = new DoubleTextField();
        this.e.setEditable(false);
        this.q = new JLabel(Messages.getString("MenuItemForm.27"));
        jLabel2.setText(Messages.getString("NAME"));
        this.b.setLength(120);
        JLabel jLabel4 = new JLabel(Messages.getString("MenuItemForm.lblTranslatedName.text"));
        this.r = new POSColorComboBox();
        this.s = new POSColorComboBox(Boolean.FALSE);
        this.r.setPreferredSize(PosUIManager.getSize(228, 40));
        this.s.setPreferredSize(PosUIManager.getSize(228, 40));
        JLabel jLabel5 = new JLabel(Messages.getString("MenuItemForm.lblTextColor.text"));
        this.n = new JCheckBox(Messages.getString("MenuItemForm.40"));
        this.n.setActionCommand(Messages.getString("MenuItemForm.41"));
        jLabel3.setText(Messages.getString("PizzaItemForm.1"));
        jButton.setText("...");
        jButton.setText("...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaItemForm.this.a(actionEvent);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jScrollPane.setBorder(null);
        this.a.addTab(POSConstants.GENERAL, jScrollPane);
        this.a.setPreferredSize(PosUIManager.getSize(750, 470));
        jPanel.setLayout((LayoutManager)new MigLayout("insets 0,hidemode 3,fillx", "[][]20px[][]"));
        jPanel.setBorder(BorderFactory.createTitledBorder("-"));
        JLabel jLabel6 = new JLabel(Messages.getString("MenuItemForm.28"));
        jLabel6.setHorizontalAlignment(11);
        jPanel.add((Component)jLabel6, "cell 0 0 ,right");
        this.l = new JLabel("");
        this.l.setHorizontalAlignment(0);
        this.l.setBorder(new EtchedBorder(1, null, null));
        this.l.setPreferredSize(PosUIManager.getSize(100, 100));
        int n = PosUIManager.getSize(100);
        jPanel.add((Component)this.l, "cell 1 0, h  " + n + "!,w  " + n + "!");
        JButton jButton3 = new JButton("...");
        this.m = new JButton(Messages.getString("MenuItemForm.34"));
        jPanel.add((Component)this.m, "cell  1 0");
        jPanel.add((Component)jButton3, "cell 1 0");
        jPanel.add((Component)jLabel2, "cell 0 1 ,right");
        jPanel.add((Component)this.b, "cell 1 1,grow");
        jPanel.add((Component)jLabel4, "cell 0 2,right");
        jPanel.add((Component)this.c, "cell 1 2,grow");
        this.x = new JLabel(Messages.getString("PizzaItemForm.14"));
        jPanel.add((Component)this.x, "cell 0 3,right,");
        jPanel.add(this.c(), "cell 1 3,growy,width 198!");
        JLabel jLabel7 = new JLabel();
        jLabel7.setHorizontalAlignment(11);
        jLabel7.setText(Messages.getString("LABEL_GROUP"));
        jPanel.add((Component)jLabel7, "cell 0 4,alignx right");
        this.v = new JComboBox();
        jPanel.add(this.v, "cell 1 4,growy,width 198!");
        JButton jButton4 = new JButton();
        jButton4.setText("...");
        jButton4.addActionListener(actionEvent -> this.b(actionEvent));
        jPanel.add((Component)jButton4, "cell 1 4");
        JLabel jLabel8 = new JLabel(Messages.getString("MenuItemForm.lblBarcode.text"));
        jPanel.add((Component)jLabel8, "cell 0 5,alignx right");
        this.f = new FixedLengthTextField(20);
        jPanel.add((Component)this.f, "cell 1 5,grow");
        jPanel.add((Component)new JLabel(Messages.getString("PizzaItemForm.11")), "cell 0 6,right");
        jPanel.add((Component)this.h, "cell 1 6,grow");
        this.g = new JCheckBox();
        this.g.setText(POSConstants.VISIBLE);
        this.g.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.g.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add((Component)this.g, "cell 1 7");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel3.add((Component)this.q, "cell 0 0,right");
        jPanel3.add((Component)this.i, "cell 1 0,width 228!");
        jPanel3.add((Component)jLabel3, "cell 0 1,right");
        jPanel3.add((Component)this.j, "cell 1 1,width 228!");
        jPanel3.add((Component)new JLabel(Messages.getString("MenuItemForm.29")), "cell 0 2,alignx right");
        JScrollPane jScrollPane2 = new JScrollPane(this.k, 20, 30);
        jScrollPane2.setPreferredSize(PosUIManager.getSize(228, 70));
        this.k.setLineWrap(true);
        jPanel3.add((Component)jScrollPane2, "cell 1 2,w 300!");
        this.o = new JCheckBox(Messages.getString("MenuItemForm.89"));
        jPanel3.add((Component)this.o, "cell 0 3,skip 1");
        this.p = new JCheckBox(Messages.getString("MenuItemForm.90"));
        jPanel3.add((Component)this.p, "cell 0 4, skip 1");
        jPanel.add((Component)jPanel3, "cell 2 0 2 8,top");
        this.add(this.a);
        this.addRecepieExtension();
        this.initModifiers();
        jButton2.setText(Messages.getString("MenuItemForm.7"));
        jPanel.add((Component)this.C, "cell 1 8, newline,span 4");
        this.a.addChangeListener(this);
        jPanel2.setLayout((LayoutManager)new MigLayout("insets 10", "[][]100[][][][]", "[][][center][][][]"));
        jPanel2.add((Component)jLabel, "cell 0 2,right");
        jPanel2.add((Component)this.r, "cell 1 2,grow");
        jPanel2.add((Component)jLabel5, "cell 0 3,right");
        jPanel2.add((Component)this.s, "cell 1 3");
        jPanel2.add((Component)this.n, "cell 1 4");
        jButton3.addActionListener(actionEvent -> this.doSelectImageFile());
        this.m.addActionListener(actionEvent -> this.doClearImage());
        this.r.addActionListener(actionEvent -> {
            PosColor posColor = (PosColor)((Object)((Object)this.r.getSelectedItem()));
            Color color = posColor.getColor();
            if (color != null) {
                this.s.setBackground(color);
            }
        });
        this.s.addActionListener(actionEvent -> {
            PosColor posColor = (PosColor)((Object)((Object)this.s.getSelectedItem()));
            Color color = posColor.getColor();
            if (color != null) {
                this.r.setForeground(color);
                this.s.setForeground(color);
            }
        });
        this.a.addTab(Messages.getString("MenuItemForm.26"), jPanel2);
        this.initOrderTypeBaseTaxTab();
    }

    public void initModifiers() {
        this.B = new ModifierTabView(this.t);
        this.a.addTab(Messages.getString("MenuItemForm.52"), this.B);
    }

    private Component c() {
        this.z = new JComboBox();
        if (this.A == null) {
            this.z.setVisible(false);
            return this.y;
        }
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        for (InventoryUnit inventoryUnit : InventoryUnitDAO.getInstance().findAll()) {
            comboBoxModel.addElement(inventoryUnit);
        }
        this.z.setModel(comboBoxModel);
        return this.z;
    }

    public void initOrderTypeBaseTaxTab() {
        this.w = new OrderTypeBaseTaxPanel();
        this.a.addTab(Messages.getString("MenuItemForm.22"), this.w);
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.d().get(i));
        }
    }

    private List d() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(100);
        arrayList.add(50);
        arrayList.add(50);
        return arrayList;
    }

    public void addRecepieExtension() {
        if (this.A == null) {
            return;
        }
        this.A.addRecepieView(this.a);
    }

    private void a(ActionEvent actionEvent) {
        TaxForm taxForm = new TaxForm();
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)taxForm);
        beanEditorDialog.open();
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.j.getModel();
        comboBoxModel.setDataList(TaxGroupDAO.getInstance().findAll());
    }

    private void b(ActionEvent actionEvent) {
        MenuGroupForm menuGroupForm = new MenuGroupForm();
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuGroupForm);
        beanEditorDialog.open();
        if (!beanEditorDialog.isCanceled()) {
            MenuGroup menuGroup = (MenuGroup)menuGroupForm.getBean();
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.v.getModel();
            comboBoxModel.addElement(menuGroup);
            comboBoxModel.setSelectedItem(menuGroup);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuItem menuItem = (MenuItem)this.getBean();
            MenuItemDAO menuItemDAO = new MenuItemDAO();
            menuItemDAO.saveOrUpdate(menuItem);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), posException.getMessage());
            return false;
        }
        catch (Exception exception) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Color color;
        MenuItem menuItem = (MenuItem)this.getBean();
        MenuItemDAO.getInstance().initialize(menuItem);
        this.b.setText(menuItem.getName());
        this.k.setText(menuItem.getDescription());
        this.c.setText(menuItem.getTranslatedName());
        this.d.setText(NumberUtil.formatAmount(menuItem.calculateDefaultPizzaPrice()));
        this.e.setText(NumberUtil.formatAmount(menuItem.calculateDefaultPizzaCost()));
        this.f.setText(menuItem.getBarcode());
        this.g.setSelected(menuItem.isVisible());
        this.n.setSelected(menuItem.isShowImageOnly());
        this.o.setSelected(menuItem.isShouldPrintToKitchen());
        this.p.setSelected(menuItem.isPrintKitchenSticker());
        this.u = ImageResourceDAO.getInstance().findById(menuItem.getImageId());
        if (this.u != null) {
            this.l.setIcon(this.u.getButtonImage(100, 100));
        }
        if (menuItem.getId() == null) {
            this.h.setText(String.valueOf(100));
        } else {
            this.h.setText(String.valueOf(menuItem.getDefaultSellPortion()));
        }
        PosGuiUtil.selectComboItemById(this.v, menuItem.getMenuGroupId());
        this.j.setSelectedItem(menuItem.getTaxGroup());
        this.i.setSelectedItem(menuItem.getPrinterGroup());
        Color color2 = menuItem.getButtonColor();
        if (color2 != null) {
            this.r.setSelectedItem((Object)PosColor.fromColor(color2, PosColor.Background));
            this.r.setBackground(color2);
            this.s.setBackground(color2);
        }
        if ((color = menuItem.getTextColor()) != null) {
            this.s.setSelectedItem((Object)PosColor.fromColor(color, PosColor.Foreground));
            this.s.setForeground(color);
            this.r.setForeground(color);
        }
        if (menuItem.getUnit() != null) {
            if (this.z != null) {
                this.z.setSelectedItem(menuItem.getUnit());
            }
            this.y.setText(menuItem.getUnit().getCode());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean updateModel() {
        void var7_17;
        String string = this.b.getText();
        int n = this.h.getInteger();
        if (POSUtil.isBlankOrNull(string)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.NAME_REQUIRED);
            return false;
        }
        if (!this.C.isValidModifier(true)) {
            return false;
        }
        List<PizzaPrice> list = this.C.doSaveAndGetPizzaPrice();
        boolean bl = false;
        for (PizzaPrice object2 : list) {
            if (!object2.isIsDefault().booleanValue()) continue;
            bl = object2.isIsDefault();
            break;
        }
        if (!bl) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PizzaItemForm.18"));
            return false;
        }
        MenuItem menuItem = (MenuItem)this.getBean();
        menuItem.setName(string);
        if (StringUtils.isNotBlank((String)this.k.getText())) {
            menuItem.setDescription(this.k.getText().trim());
        }
        if (n == 0) {
            n = 100;
        }
        if (n < 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PizzaItemForm.19"));
            return false;
        }
        if (n > 100) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PizzaItemForm.20"));
            return false;
        }
        if (this.z != null && this.z.isVisible()) {
            InventoryUnit n2 = (InventoryUnit)this.z.getSelectedItem();
            menuItem.setUnit(n2);
        } else {
            menuItem.setUnitName(this.y.getText());
        }
        menuItem.setBarcode(this.f.getText());
        menuItem.setMenuGroup((MenuGroup)this.v.getSelectedItem());
        menuItem.setTaxGroup((TaxGroup)this.j.getSelectedItem());
        menuItem.setVisible(this.g.isSelected());
        menuItem.setShowImageOnly(this.n.isSelected());
        menuItem.setDefaultSellPortion(n);
        menuItem.setTranslatedName(this.c.getText());
        menuItem.setButtonColorCode(this.r.getSelectedColorCode());
        menuItem.setTextColorCode(this.s.getSelectedColorCode());
        menuItem.setShouldPrintToKitchen(this.o.isSelected());
        menuItem.setPrintKitchenSticker(this.p.isSelected());
        if (this.B.isViewInitialized()) {
            if (!this.B.isValidAndSave()) {
                return false;
            }
            List list2 = this.B.getSpecLists();
            if (list2 != null) {
                List<MenuItemModifierSpec> list3 = menuItem.getMenuItemModiferSpecs();
                if (list3 != null) {
                    list3.clear();
                    list3.addAll(list2);
                } else {
                    menuItem.setMenuItemModiferSpecs(list2);
                }
            }
        }
        this.a(menuItem);
        if (menuItem.getPizzaPriceList() != null) {
            menuItem.getPizzaPriceList().clear();
        }
        for (PizzaPrice pizzaPrice : list) {
            menuItem.addTopizzaPriceList(pizzaPrice);
            if (!pizzaPrice.isIsDefault().booleanValue()) continue;
            menuItem.setDeafultPizzaCrust(pizzaPrice.getCrust().getId());
            menuItem.setDeafultPizzaSize(pizzaPrice.getSize().getId());
            menuItem.setPrice(pizzaPrice.getPrice());
            menuItem.setCost(pizzaPrice.getCost());
        }
        int n2 = this.a.getTabCount();
        boolean bl2 = false;
        while (var7_17 < n2) {
            IUpdatebleView iUpdatebleView;
            Component component = this.a.getComponent((int)var7_17);
            if (component instanceof IUpdatebleView && !(iUpdatebleView = (IUpdatebleView)((Object)component)).updateModel(menuItem)) {
                return false;
            }
            ++var7_17;
        }
        menuItem.setPrinterGroup((PrinterGroup)this.i.getSelectedItem());
        menuItem.setPizzaType(true);
        if (this.u != null) {
            menuItem.setImageId(this.u.getId());
        } else {
            menuItem.setImageId("");
        }
        menuItem.setInventoryItem(false);
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuItem menuItem = (MenuItem)this.getBean();
        if (menuItem.getId() == null) {
            return Messages.getString("PizzaItemForm.15");
        }
        return Messages.getString("PizzaItemForm.10") + this.t.getName();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    PizzaItemForm.this.setCursor(Cursor.getPredefinedCursor(3));
                    Component component = PizzaItemForm.this.a.getSelectedComponent();
                    String string = PizzaItemForm.this.a.getTitleAt(PizzaItemForm.this.a.getSelectedIndex());
                    if (StringUtils.isNotBlank((String)string) && string.equals(Messages.getString("MenuItemForm.52"))) {
                        PizzaItemForm.this.B.initUI();
                    }
                    if (!(component instanceof IUpdatebleView)) {
                        return;
                    }
                    IUpdatebleView iUpdatebleView = (IUpdatebleView)((Object)component);
                    MenuItem menuItem = (MenuItem)PizzaItemForm.this.getBean();
                    iUpdatebleView.initView(menuItem);
                }
                finally {
                    PizzaItemForm.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
    }

    private List<PizzaPrice> e() {
        List<MenuItemSize> list = MenuItemSizeDAO.getInstance().findAll();
        List<PizzaCrust> list2 = PizzaCrustDAO.getInstance().findAll();
        ArrayList<PizzaPrice> arrayList = new ArrayList<PizzaPrice>();
        Comparator<MenuItemSize> comparator = Comparator.comparing(BaseMenuItemSize::getSortOrder);
        Collections.sort(list, comparator);
        Comparator<PizzaCrust> comparator2 = Comparator.comparing(BasePizzaCrust::getSortOrder);
        Collections.sort(list2, comparator2);
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < list2.size(); ++j) {
                PizzaPrice pizzaPrice = new PizzaPrice();
                pizzaPrice.setSize(list.get(i));
                pizzaPrice.setCrust(list2.get(j));
                pizzaPrice.setPrice(0.0);
                arrayList.add(pizzaPrice);
            }
        }
        return arrayList;
    }

    private void a(MenuItem menuItem) {
        List<MenuItemModifierSpec> list = menuItem.getMenuItemModiferSpecs();
        boolean bl = list != null && list.size() > 0;
        menuItem.setHasModifiers(bl);
        menuItem.setHasMandatoryModifiers(false);
        if (menuItem.hasModifiers()) {
            for (MenuItemModifierSpec menuItemModifierSpec : list) {
                if (menuItemModifierSpec.getMinQuantity() <= 0 && !menuItemModifierSpec.isAutoShow().booleanValue()) continue;
                menuItem.setHasMandatoryModifiers(true);
                break;
            }
        }
    }
}

