/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.setup;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.main.Application;
import com.floreantpos.main.ProcessUtil;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.setup.DownloadDialog;
import com.floreantpos.ui.setup.PosWizardPage;
import com.floreantpos.ui.setup.TitledPageTemplate;
import com.floreantpos.ui.setup.pages.ConfigureDatabasePage1;
import com.floreantpos.ui.setup.pages.ConfigureDatabasePage2;
import com.floreantpos.ui.setup.pages.ConfigureDatabasePage3;
import com.floreantpos.ui.setup.pages.ConfigurePostgreSQLPage1;
import com.floreantpos.ui.setup.pages.ConfigurePostgreSQLPage2;
import com.floreantpos.ui.setup.pages.DatabaseServerListDialog;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.POSUtil;
import com.github.cjwizard.PageFactory;
import com.github.cjwizard.StackWizardSettings;
import com.github.cjwizard.WizardContainer;
import com.github.cjwizard.WizardListener;
import com.github.cjwizard.WizardPage;
import com.github.cjwizard.WizardSettings;
import com.github.cjwizard.pagetemplates.PageTemplate;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class DatabaseSetupWizard
extends POSDialog
implements ConfigureDatabasePage3.DatabaseConfigListener,
PageFactory,
WizardListener {
    private static final String b = "https://orodev.net/postgresql-10.20-2-windows-x64.exe";
    private static final String c = "https://orodev.net/postgresql-10.20-2-windows-x64.checkum";
    List<PosWizardPage> a = new ArrayList<PosWizardPage>();
    private WizardContainer d;
    private DownloadDialog e;
    private boolean f = true;
    private Database g;
    private boolean h = true;

    public DatabaseSetupWizard() {
        super((Frame)Application.getPosWindow(), true);
        this.setTitle(Messages.getString("ConfigureDatabasePage1.0"));
        this.a.add(new ConfigureDatabasePage1());
        this.a.add(new ConfigurePostgreSQLPage1());
        this.a.add(new ConfigureDatabasePage2());
        this.a.add(new ConfigureDatabasePage3(this));
        this.a.add(new ConfigurePostgreSQLPage2());
        this.d = new WizardContainer((PageFactory)this, (PageTemplate)new TitledPageTemplate(), (WizardSettings)new StackWizardSettings());
        this.d.addWizardListener((WizardListener)this);
        this.d.setFinishEnabled(false);
        this.add((Component)this.d);
        this.setSize(PosUIManager.getSize(500, 330));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DatabaseSetupWizard.this.onCanceled(null, null);
            }
        });
    }

    public WizardPage createPage(List<WizardPage> list, WizardSettings wizardSettings) {
        PosWizardPage posWizardPage = null;
        if (list.isEmpty()) {
            posWizardPage = this.a.get(0);
        } else {
            WizardPage wizardPage = list.get(list.size() - 1);
            ConfigureDatabasePage2 configureDatabasePage2 = (ConfigureDatabasePage2)this.a.get(2);
            if (wizardPage instanceof ConfigureDatabasePage1) {
                posWizardPage = this.a.get(0);
                this.g = ((ConfigureDatabasePage1)wizardPage).getSelectedOption();
                switch (this.g) {
                    case POSTGRES: {
                        if (SystemUtils.IS_OS_WINDOWS) {
                            posWizardPage = this.a.get(1);
                            break;
                        }
                        configureDatabasePage2.setDatabase(Database.POSTGRES);
                        configureDatabasePage2.setStartDerbyServerVisible(false);
                        posWizardPage = configureDatabasePage2;
                        break;
                    }
                    case MYSQL: {
                        configureDatabasePage2.setDatabase(Database.MYSQL);
                        configureDatabasePage2.setStartDerbyServerVisible(false);
                        posWizardPage = configureDatabasePage2;
                        break;
                    }
                    case MS_SQL: {
                        configureDatabasePage2.setDatabase(Database.MS_SQL);
                        configureDatabasePage2.setStartDerbyServerVisible(false);
                        posWizardPage = configureDatabasePage2;
                        break;
                    }
                    case DERBY_SERVER: {
                        configureDatabasePage2.setDatabase(Database.DERBY_SERVER);
                        configureDatabasePage2.setStartDerbyServerVisible(true);
                        posWizardPage = configureDatabasePage2;
                        break;
                    }
                    case DERBY_SINGLE: {
                        posWizardPage = this.a.get(3);
                    }
                }
            }
            if (wizardPage instanceof ConfigurePostgreSQLPage1) {
                switch (((ConfigurePostgreSQLPage1)wizardPage).getSelectedOption()) {
                    case 1: {
                        configureDatabasePage2.setDatabase(Database.POSTGRES);
                        configureDatabasePage2.setStartDerbyServerVisible(false);
                        posWizardPage = configureDatabasePage2;
                        break;
                    }
                    case 2: {
                        posWizardPage = this.a.get(4);
                    }
                }
            }
            if (wizardPage instanceof ConfigureDatabasePage2) {
                posWizardPage = this.a.get(3);
            }
        }
        try {
            posWizardPage.initialize();
            if (this.g != null) {
                posWizardPage.setTitle(Messages.getString("PosMessage.98") + " " + this.g.getProviderName());
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
        return posWizardPage;
    }

    public boolean isTransient(List<WizardPage> list, WizardSettings wizardSettings) {
        return true;
    }

    public void onPageChanged(WizardPage wizardPage, List<WizardPage> list) {
        if (wizardPage instanceof ConfigureDatabasePage3) {
            wizardPage.getController().setNextEnabled(false);
            wizardPage.getController().setFinishEnabled(true);
        } else if (wizardPage instanceof ConfigurePostgreSQLPage2) {
            wizardPage.getController().setNextEnabled(false);
            wizardPage.getController().setFinishEnabled(true);
        } else {
            wizardPage.getController().setNextEnabled(true);
            wizardPage.getController().setFinishEnabled(false);
        }
    }

    public void onFinished(List<WizardPage> list, WizardSettings wizardSettings) {
        WizardPage wizardPage = list.get(list.size() - 1);
        if (wizardPage instanceof ConfigureDatabasePage3) {
            DatabaseConfigurationDialog.DbInfo dbInfo = this.b();
            try {
                Class.forName(dbInfo.driverClass);
                if (this.g.equals((Object)Database.DERBY_SINGLE)) {
                    String string;
                    dbInfo.connectionString = string = "jdbc:derby:database/derby-single/" + dbInfo.databaseName;
                    dbInfo.createDbConnectionString = string + ";create=true";
                }
                DriverManager.getConnection(dbInfo.connectionString, dbInfo.user, dbInfo.pass);
                int n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("DatabaseConfigurationView.0"));
                if (n != 0) {
                    return;
                }
                DatabaseConfigurationDialog.saveConfig(dbInfo);
                ProcessUtil.restart();
            }
            catch (SQLException sQLException) {
                int n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("DatabaseSetupWizard.4") + dbInfo.databaseName + Messages.getString("DatabaseSetupWizard.5"));
                if (n != 0) {
                    return;
                }
                n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("DatabaseConfigurationDialog.4"));
                boolean bl = n == 0;
                this.a(dbInfo, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                POSMessageDialog.showError(classNotFoundException.getMessage());
            }
        } else if (wizardPage instanceof ConfigurePostgreSQLPage2) {
            Object object;
            String string = "localhost";
            String string2 = "5432";
            ConfigurePostgreSQLPage2 configurePostgreSQLPage2 = (ConfigurePostgreSQLPage2)this.a.get(4);
            String string3 = configurePostgreSQLPage2.getUserName();
            String string4 = configurePostgreSQLPage2.getPassword();
            String string5 = configurePostgreSQLPage2.getDatabaseName();
            if (StringUtils.isBlank((CharSequence)string3)) {
                POSMessageDialog.showError(Messages.getString("DatabaseSetupWizard.1"));
                return;
            }
            if (StringUtils.isBlank((CharSequence)string4)) {
                POSMessageDialog.showError(Messages.getString("DatabaseSetupWizard.2"));
                return;
            }
            if (StringUtils.isBlank((CharSequence)string5)) {
                POSMessageDialog.showError(Messages.getString("DatabaseSetupWizard.0"));
                return;
            }
            boolean bl = DatabaseServerListDialog.isDbServerAvailable(string, Integer.parseInt(string2));
            if (!bl) {
                POSMessageDialog.showMessage(Messages.getString("DatabaseSetupWizard.3"));
                object = System.getProperty("java.io.tmpdir");
                String string6 = FilenameUtils.getName((String)b);
                if (!new File((String)object + string6).exists()) {
                    this.a((String)object);
                } else {
                    try {
                        if (!this.a((String)object, string6)) {
                            this.a((String)object);
                        }
                    }
                    catch (IOException iOException) {
                        POSMessageDialog.showError(iOException.getMessage());
                    }
                }
                if (!this.f) {
                    return;
                }
                if (!this.a(string2, string3, string4, (String)object + string6)) {
                    return;
                }
            }
            object = this.a(string, string2, string5, string3, string4);
            int n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("DatabaseConfigurationDialog.4"));
            boolean bl2 = n == 0;
            this.a((DatabaseConfigurationDialog.DbInfo)object, bl2);
        }
    }

    private void a(final String string) {
        this.e = new DownloadDialog();
        this.e.setTitle(Messages.getString("DatabaseSetupWizard.6"));
        SwingWorker<String, Void> swingWorker = new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() throws Exception {
                DatabaseSetupWizard.this.f = false;
                return DatabaseSetupWizard.this.a(new URL(DatabaseSetupWizard.b), string);
            }

            @Override
            protected void done() {
                try {
                    String string2 = (String)this.get();
                    if (!DatabaseSetupWizard.this.a(string, string2)) {
                        POSMessageDialog.showError(Messages.getString("DatabaseSetupWizard.7"));
                        return;
                    }
                    DatabaseSetupWizard.this.f = true;
                }
                catch (ExecutionException executionException) {
                    DatabaseSetupWizard.this.f = false;
                    Throwable throwable = executionException.getCause();
                    POSMessageDialog.showError(throwable.getMessage());
                }
                catch (Exception exception) {
                    DatabaseSetupWizard.this.f = false;
                    POSMessageDialog.showError(exception.getMessage());
                }
                finally {
                    DatabaseSetupWizard.this.e.dispose();
                }
                super.done();
            }
        };
        swingWorker.execute();
        this.e.setVisible(true);
    }

    private String a(URL uRL, String string) throws MalformedURLException, IOException {
        int n;
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        String string2 = FilenameUtils.getName((String)uRL.getPath());
        File file = new File(string + string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[512];
        long l = 0L;
        int n2 = 0;
        long l2 = uRLConnection.getContentLength();
        while ((n = inputStream.read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
            n2 = (int)((l += (long)n) * 100L / l2);
            this.e.setProgressValue(n2);
        }
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
        return string2;
    }

    private boolean a(String string, String string2) throws IOException {
        String string3 = "0";
        String string4 = "1";
        Object object = new FileInputStream(string + string2);
        Object object2 = null;
        try {
            string3 = DigestUtils.md5Hex((InputStream)object);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((FileInputStream)object).close();
                }
            }
        }
        object = new URL(c);
        object2 = ((URL)object).openConnection();
        try (InputStream inputStream = ((URLConnection)object2).getInputStream();){
            string4 = IOUtils.toString((InputStream)inputStream).trim();
        }
        return string3.equals(string4);
    }

    private boolean a(String string, String string2, String string3, String string4) {
        Object object;
        String string5 = "";
        JFileChooser jFileChooser = new JFileChooser(){

            @Override
            public void approveSelection() {
                if (this.getSelectedFile().list().length > 0) {
                    POSMessageDialog.showError(Messages.getString("DatabaseSetupWizard.10") + this.getSelectedFile().getName() + Messages.getString("DatabaseSetupWizard.11"));
                    return;
                }
                super.approveSelection();
            }
        };
        jFileChooser.setDialogTitle(Messages.getString("DatabaseSetupWizard.8"));
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(POSUtil.getFocusedWindow());
        if (n == 0) {
            object = jFileChooser.getSelectedFile();
            string5 = ((File)object).getAbsolutePath();
            POSMessageDialog.showMessage(Messages.getString("DatabaseSetupWizard.9"));
        } else if (n == 1) {
            POSMessageDialog.showMessage(Messages.getString("DatabaseSetupWizard.14"));
            return false;
        }
        object = string5 + "\\data";
        String string6 = string4 + " --prefix " + string5 + " --datadir " + (String)object + " --serverport " + string + " --servicename postgres_service --locale C --superaccount " + string2 + " --superpassword " + string3 + " --unattendedmodeui minimal --debuglevel 2 --mode unattended ";
        try {
            Process process = Runtime.getRuntime().exec("cmd /c " + string6);
            process.waitFor();
            if (process.exitValue() == 0) {
                this.b((String)object, this.a());
                POSMessageDialog.showMessage(Messages.getString("DatabaseSetupWizard.12"));
                return true;
            }
            String string7 = IOUtils.toString((InputStream)process.getErrorStream());
            POSMessageDialog.showMessage(Messages.getString("DatabaseSetupWizard.13") + "\n" + string7);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
        }
        return false;
    }

    private void b(String string, String string2) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + "\\pg_hba.conf", true));){
            bufferedWriter.write("host    all             all             " + string2 + ".0/24          md5");
            bufferedWriter.newLine();
        }
    }

    private String a() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string = inetAddress.getHostAddress();
        String string2 = new String();
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) != '.') continue;
            string2 = string.substring(0, i);
            break;
        }
        return string2;
    }

    private void a(DatabaseConfigurationDialog.DbInfo dbInfo, boolean bl) {
        Connection connection = null;
        try {
            Class.forName(dbInfo.driverClass);
            switch (this.g) {
                case POSTGRES: {
                    connection = DriverManager.getConnection("jdbc:postgresql://" + dbInfo.databaseURL + ":" + dbInfo.databasePort + "/postgres", dbInfo.user, dbInfo.pass);
                    Statement statement = connection.createStatement();
                    statement.executeUpdate("CREATE DATABASE " + dbInfo.databaseName);
                    break;
                }
                case MYSQL: {
                    connection = DriverManager.getConnection("jdbc:mysql://" + dbInfo.databaseURL + ":" + dbInfo.databasePort + "/mysql?characterEncoding=UTF-8", dbInfo.user, dbInfo.pass);
                    Statement statement = connection.createStatement();
                    statement.executeUpdate("CREATE DATABASE " + dbInfo.databaseName);
                    break;
                }
                case MS_SQL: {
                    connection = DriverManager.getConnection("jdbc:jtds:sqlserver://" + dbInfo.databaseURL + ":" + dbInfo.databasePort + "/master", dbInfo.user, dbInfo.pass);
                    Statement statement = connection.createStatement();
                    statement.executeUpdate("CREATE DATABASE " + dbInfo.databaseName);
                    break;
                }
                case DERBY_SERVER: {
                    connection = DriverManager.getConnection(dbInfo.createDbConnectionString, dbInfo.user, dbInfo.pass);
                    break;
                }
                case DERBY_SINGLE: {
                    connection = DriverManager.getConnection(dbInfo.createDbConnectionString, dbInfo.user, dbInfo.pass);
                }
            }
            this.doCreateDb(dbInfo, bl);
            DatabaseConfigurationDialog.saveConfig(dbInfo);
            ProcessUtil.restart();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
        }
    }

    public void doCreateDb(final DatabaseConfigurationDialog.DbInfo dbInfo, final boolean bl) {
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setTitle(Messages.getString("DatabaseSetupWizard.16"));
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                boolean bl2 = DatabaseUtil.createDatabase(dbInfo.createDbConnectionString, dbInfo.hibernateDialect, dbInfo.driverClass, dbInfo.user, dbInfo.pass, bl);
                return bl2;
            }

            @Override
            protected void done() {
                try {
                    Boolean bl2 = (Boolean)this.get();
                    busyDialog.dispose();
                    if (bl2.booleanValue()) {
                        String string = String.format(Messages.getString("DatabaseConfigurationDialog.6"), "1111");
                        POSMessageDialog.showMessage(string);
                    } else {
                        POSMessageDialog.showError(Messages.getString("DatabaseConfigurationDialog.36"));
                    }
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    POSMessageDialog.showMessage(throwable.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showMessage(exception.getMessage());
                }
                super.done();
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    public void onCanceled(List<WizardPage> list, WizardSettings wizardSettings) {
        if (this.isCloseSetupWizerdAndPosShutdown()) {
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DatabaseSetupWizard.15"), POSConstants.CONFIRM);
            if (n == 0) {
                System.exit(0);
            }
        } else {
            this.dispose();
        }
    }

    public PosWizardPage getPage(int n) {
        return this.a.get(n);
    }

    public List<PosWizardPage> getPages() {
        return this.a;
    }

    private DatabaseConfigurationDialog.DbInfo a(String string, String string2, String string3, String string4, String string5) {
        DatabaseConfigurationDialog.DbInfo dbInfo = new DatabaseConfigurationDialog.DbInfo();
        dbInfo.providerName = this.g.getProviderName();
        dbInfo.databaseURL = string;
        dbInfo.databasePort = string2;
        dbInfo.databaseName = string3;
        dbInfo.user = string4;
        dbInfo.pass = string5;
        dbInfo.connectionString = this.g.getConnectString(dbInfo.databaseURL, dbInfo.databasePort, dbInfo.databaseName);
        dbInfo.createDbConnectionString = this.g.getCreateDbConnectString(dbInfo.databaseURL, dbInfo.databasePort, dbInfo.databaseName);
        dbInfo.hibernateDialect = this.g.getHibernateDialect();
        dbInfo.driverClass = this.g.getHibernateConnectionDriverClass();
        return dbInfo;
    }

    private DatabaseConfigurationDialog.DbInfo b() {
        String string;
        String string2;
        String string3;
        String string4;
        ConfigureDatabasePage2 configureDatabasePage2 = (ConfigureDatabasePage2)this.a.get(2);
        ConfigureDatabasePage3 configureDatabasePage3 = (ConfigureDatabasePage3)this.a.get(3);
        if (this.g.equals((Object)Database.DERBY_SINGLE)) {
            string4 = AppConfig.getDatabaseHost();
            string3 = this.g.getDefaultPort();
            string2 = AppConfig.getDatabaseUser();
            string = AppConfig.getDatabasePassword();
        } else {
            string4 = configureDatabasePage2.getServerAddress();
            string3 = configureDatabasePage2.getServerPort();
            string2 = configureDatabasePage2.getUserName();
            string = configureDatabasePage2.getPassword();
        }
        String string5 = configureDatabasePage3.getDatabaseName();
        if (string5 == null || string5.isEmpty()) {
            POSMessageDialog.showError(Messages.getString("DatabaseSetupWizard.0"));
            return null;
        }
        return this.a(string4, string3, string5, string2, string);
    }

    @Override
    public void connectionTest(String string) {
        ConfigureDatabasePage2 configureDatabasePage2 = (ConfigureDatabasePage2)this.a.get(2);
        configureDatabasePage2.setDatabase(this.g);
        if (configureDatabasePage2.doTestConnection(string, this.g.equals((Object)Database.DERBY_SINGLE))) {
            POSMessageDialog.showMessage(Messages.getString("DatabaseConfigurationDialog.31"));
        }
    }

    @Override
    public void createDatabase(String string) {
        DatabaseConfigurationDialog.DbInfo dbInfo = this.b();
        try {
            Class.forName(dbInfo.driverClass);
            if (this.g.equals((Object)Database.DERBY_SINGLE)) {
                String string2;
                dbInfo.connectionString = string2 = "jdbc:derby:database/derby-single/" + dbInfo.databaseName;
                dbInfo.createDbConnectionString = string2 + ";create=true";
            }
            DriverManager.getConnection(dbInfo.connectionString, dbInfo.user, dbInfo.pass);
            POSMessageDialog.showError(String.format(Messages.getString("DatabaseSetupWizard.17"), string));
            return;
        }
        catch (SQLException sQLException) {
            int n = POSMessageDialog.showYesNoQuestionDialog(String.format(Messages.getString("DatabaseSetupWizard.18"), dbInfo.databaseName));
            if (n != 0) {
                return;
            }
            n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("DatabaseConfigurationDialog.4"));
            boolean bl = n == 0;
            this.a(dbInfo, bl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            POSMessageDialog.showError(classNotFoundException.getMessage());
        }
    }

    @Override
    public void updateDatabase(String string) {
        final DatabaseConfigurationDialog.DbInfo dbInfo = this.b();
        try {
            Class.forName(dbInfo.driverClass);
            if (this.g.equals((Object)Database.DERBY_SINGLE)) {
                String string2;
                dbInfo.connectionString = string2 = "jdbc:derby:database/derby-single/" + dbInfo.databaseName;
                dbInfo.createDbConnectionString = string2 + ";create=true";
            }
            DriverManager.getConnection(dbInfo.connectionString, dbInfo.user, dbInfo.pass);
        }
        catch (ClassNotFoundException | SQLException exception) {
            POSMessageDialog.showError(String.format(Messages.getString("DatabaseSetupWizard.19"), string));
            return;
        }
        int n = POSMessageDialog.showYesNoQuestionDialog(String.format(Messages.getString("DatabaseSetupWizard.20"), dbInfo.databaseName));
        if (n != 0) {
            return;
        }
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setTitle(Messages.getString("DatabaseSetupWizard.21"));
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                boolean bl = DatabaseUtil.updateDatabase(dbInfo.connectionString, dbInfo.hibernateDialect, dbInfo.driverClass, dbInfo.user, dbInfo.pass);
                return bl;
            }

            @Override
            protected void done() {
                try {
                    Boolean bl = (Boolean)this.get();
                    busyDialog.dispose();
                    if (bl.booleanValue()) {
                        POSMessageDialog.showMessage(DatabaseSetupWizard.this, Messages.getString("DatabaseConfigurationDialog.2"));
                    } else {
                        POSMessageDialog.showError(DatabaseSetupWizard.this, Messages.getString("DatabaseConfigurationDialog.3"));
                    }
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    POSMessageDialog.showMessage(throwable.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showMessage(exception.getMessage());
                }
                super.done();
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    public boolean isCloseSetupWizerdAndPosShutdown() {
        return this.h;
    }

    public void setCloseSetupWizerdAndPosShutdown(boolean bl) {
        this.h = bl;
    }
}

