/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.setup.pages;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class SetupMenuDialog
extends OkCancelOptionDialog {
    private FixedLengthTextField a;
    private DoubleTextField b;

    public SetupMenuDialog() {
        this.setCaption(Messages.getString("SetupMenuDialog.0"));
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout((LayoutManager)new MigLayout());
        this.a = new FixedLengthTextField(20, 200);
        this.b = new DoubleTextField(10, 10);
        jPanel.add(new JLabel(Messages.getString("SetupMenuDialog.1")));
        jPanel.add((Component)this.a, "wrap");
        jPanel.add(new JLabel(Messages.getString("SetupMenuDialog.3")));
        jPanel.add((Component)this.b, "wrap");
    }

    @Override
    public void doOk() {
        String string = this.a.getText();
        double d = this.b.getDoubleOrZero();
        if (StringUtils.isBlank((String)string)) {
            throw new PosException(Messages.getString("SetupMenuDialog.5"));
        }
        if (d < 0.0) {
            throw new PosException(Messages.getString("NegativePriceNotAllowed"));
        }
        InventoryUnit inventoryUnit = InventoryUnitDAO.getInstance().get("each");
        MenuGroup menuGroup = MenuGroupDAO.getInstance().get("group1");
        TaxGroup taxGroup = TaxGroupDAO.getInstance().get("taxgroup1");
        MenuItem menuItem = new MenuItem();
        menuItem.setMenuGroup(menuGroup);
        menuItem.setUnit(inventoryUnit);
        menuItem.setVisible(true);
        menuItem.setTaxGroup(taxGroup);
        menuItem.setInventoryItem(true);
        menuItem.setName(string);
        menuItem.setPrice(this.b.getDoubleOrZero());
        MenuItemDAO.getInstance().save(menuItem);
        POSMessageDialog.showMessage(Messages.getString("SetupMenuDialog.9"));
        this.setCanceled(false);
        this.dispose();
    }
}

