/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.tableselection;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.Store;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.tableselection.TableSelectionListener;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import org.apache.commons.lang.StringUtils;

public class DefaultShopTableButton
extends PosButton
implements ActionListener {
    private ShopTable a;
    private User b;
    private Ticket d;
    private TableSelectionListener e;
    public List<Integer> removeTableListModel = new ArrayList<Integer>();

    public DefaultShopTableButton(ShopTable shopTable) {
        this.a = shopTable;
        this.setPreferredSize(PosUIManager.getSize(157, 138));
        this.setBorder(null);
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ShopTableStatus shopTableStatus = this.a.getShopTableStatus();
        if (!TerminalDAO.getInstance().isVersionEqual(ShopTableStatus.class, shopTableStatus.getId(), shopTableStatus.getVersion())) {
            POSMessageDialog.showMessage(Messages.getString("DefaultShopTableButton.0"));
            return;
        }
        if (this.e == null) {
            return;
        }
        AbstractButton abstractButton = this.e.getTableActionButton();
        if (abstractButton == null) {
            shopTableStatus = ShopTableStatusDAO.getInstance().get(shopTableStatus.getId());
            this.e.tableSelected(this.a);
        } else {
            POSToggleButton pOSToggleButton = (POSToggleButton)abstractButton;
            Object object = pOSToggleButton.getClientProperty("ticketAction");
            if (object == null) {
                this.a(pOSToggleButton);
            } else {
                PosAction posAction = (PosAction)pOSToggleButton.getClientProperty("ticketAction");
                if (shopTableStatus.getTicketId() == null) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DefaultTableSelectionView.2"));
                } else {
                    this.e.tableActionSelected(this.a, posAction, this.a());
                }
            }
        }
        this.updateView();
    }

    private void a(POSToggleButton pOSToggleButton) {
        ShopTableStatus shopTableStatus = this.a.getShopTableStatus();
        String string = (String)pOSToggleButton.getClientProperty("buttonAction");
        if (string.equals(TableSelectionListener.GROUP)) {
            List list = this.e.getAddedTableList();
            if (list.contains(shopTableStatus.getId())) {
                list.remove(shopTableStatus.getId());
                this.setSelected(false);
                Store store = DataProvider.get().getStore();
                if (this.a.getTableStatus().equals((Object)TableStatus.Booked)) {
                    this.setBackground(store.getTableBookBGColor());
                    this.setForeground(store.getTableBookForeColor());
                } else if (this.a.getTableStatus().equals((Object)TableStatus.Seat)) {
                    this.setBackground(store.getTableSeatBGColor());
                    this.setForeground(store.getTableSeatForeColor());
                } else if (this.a.getTableStatus().equals((Object)TableStatus.Serving)) {
                    this.setBackground(store.getTableServingBGColor());
                    this.setForeground(store.getTableServingForeColor());
                } else {
                    this.setBackground(store.getTableFreeBGColor());
                    this.setForeground(store.getTableFreeForeColor());
                }
                this.repaint();
                this.revalidate();
                return;
            }
            list.add(shopTableStatus.getId());
        } else if (string.equals(TableSelectionListener.UNGROUP)) {
            if (shopTableStatus.getTicketId() == null) {
                return;
            }
            List list = this.e.getReleasesTableList();
            for (Integer n : list) {
                Ticket ticket = this.e.getTicket(n);
                if (shopTableStatus.getTicketId().equals(ticket.getId())) continue;
                return;
            }
            if (list.size() >= this.getTicket().getTableNumbers().size() - 1) {
                return;
            }
            list.add(shopTableStatus.getId());
        } else if (string.equals(TableSelectionListener.RELEASE)) {
            if (shopTableStatus.getTicketId() == null) {
                POSMessageDialog.showMessage(Messages.getString("DefaultShopTableButton.4"));
                return;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DefaultShopTableButton.5"), Messages.getString("DefaultShopTableButton.6"));
            if (0 != n) {
                return;
            }
            ShopTable shopTable = this.getShopTable();
            shopTable.setTableStatus(TableStatus.Available);
            this.removeTableListModel.add(shopTable.getId());
            ShopTableDAO.getInstance().updateTableStatus(this.removeTableListModel, null, null, false);
            this.setTicket(null);
        }
    }

    public void setTableSelectionListener(TableSelectionListener tableSelectionListener) {
        this.e = tableSelectionListener;
    }

    public int getId() {
        return this.a.getId();
    }

    public void setShopTable(ShopTable shopTable) {
        this.a = shopTable;
    }

    public ShopTable getShopTable() {
        return this.a;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefaultShopTableButton)) {
            return false;
        }
        DefaultShopTableButton defaultShopTableButton = (DefaultShopTableButton)object;
        return this.a.equals(defaultShopTableButton.a);
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    @Override
    public String toString() {
        return this.a.toString();
    }

    public void updateView() {
        ShopTableStatus shopTableStatus = this.a.getShopTableStatus();
        TableStatus tableStatus = shopTableStatus.getTableStatus();
        this.setBackground(tableStatus == null ? Color.WHITE : tableStatus.getBgColor());
        this.setForeground(tableStatus == null ? Color.BLACK : tableStatus.getTextColor());
        if (this.e != null && (this.e.getAddedTableList().contains(shopTableStatus.getId()) || this.e.getReleasesTableList().contains(shopTableStatus.getId()))) {
            this.setBackground(Color.GREEN);
            this.setForeground(Color.BLACK);
        }
        String string = "<html><center><font size='36'>";
        string = string + this.a.getTableNumber();
        if (shopTableStatus.getTicketId() != null && StringUtils.isNotEmpty((String)shopTableStatus.getUserId())) {
            boolean bl;
            string = string + "</font><br/><strong>" + shopTableStatus.getUserName();
            boolean bl2 = bl = this.e != null && this.e.getAddedTableList().contains(shopTableStatus.getId());
            if (!shopTableStatus.getUserId().toString().equals(Application.getCurrentUser().getId().toString()) && !bl) {
                this.setBackground(new Color(139, 0, 139));
                this.setForeground(Color.WHITE);
            }
        }
        if (StringUtils.isNotEmpty((String)shopTableStatus.getTicketId())) {
            string = string + "</font><br><strong>Token# " + shopTableStatus.getTokenNo();
        }
        string = string + "</center></html>";
        this.setText(string);
    }

    public void setUser(User user) {
        if (user != null) {
            this.b = user;
        }
    }

    public User getUser() {
        String string;
        ShopTableStatus shopTableStatus = this.a.getShopTableStatus();
        User user = Application.getCurrentUser();
        String string2 = user.getId();
        if (string2.equals(string = shopTableStatus.getUserId())) {
            this.b = user;
        }
        if (this.b == null) {
            this.b = UserDAO.getInstance().get(this.b.getId());
        }
        return this.b;
    }

    public boolean hasUserAccess() {
        User user = this.getUser();
        if (user == null) {
            return false;
        }
        User user2 = Application.getCurrentUser();
        if (user2.hasPermission(UserPermission.PERFORM_MANAGER_TASK) || user2.hasPermission(UserPermission.PERFORM_ADMINISTRATIVE_TASK)) {
            return true;
        }
        String string = PasswordEntryDialog.show(Application.getPosWindow(), Messages.getString("PosAction.0"));
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        String string2 = UserDAO.getInstance().findUserBySecretKey(string).getId();
        if (!string2.equals(user.getId())) {
            POSMessageDialog.showError(Application.getPosWindow(), "Incorrect password");
            return false;
        }
        return true;
    }

    public void initializeUser() {
        ShopTableStatus shopTableStatus = this.a.getShopTableStatus();
        String string = shopTableStatus.getUserId();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        if (this.b != null && this.b.getId().equals(string)) {
            return;
        }
        this.b = UserDAO.getInstance().get(shopTableStatus.getUserId());
    }

    private Ticket a() {
        ShopTableStatus shopTableStatus = this.a.getShopTableStatus();
        String string = shopTableStatus.getTicketId();
        if (StringUtils.isEmpty((String)string)) {
            this.d = null;
        }
        if (this.d != null && this.d.getId().equals(shopTableStatus.getTicketId())) {
            return this.d;
        }
        this.d = TicketService.getTicket(shopTableStatus.getTicketId());
        return this.d;
    }

    public Ticket getTicket() {
        return this.a();
    }

    public void setTicket(Ticket ticket) {
        this.d = ticket;
        ShopTableStatus shopTableStatus = this.a.getShopTableStatus();
        if (ticket == null) {
            shopTableStatus.setTableStatus(TableStatus.Available);
            shopTableStatus.setTicketId(null);
        } else {
            shopTableStatus.setTableStatus(TableStatus.Serving);
            shopTableStatus.setTableTicket(ticket.getId(), ticket.getTokenNo(), ticket.getOwner().getId(), ticket.getOwner().getFirstName(), ticket.getCreateDate());
        }
        this.updateView();
    }
}

