/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.GiftCardExplorer;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.GiftCardGeneratorView;
import com.floreantpos.util.DateTimePicker;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class GiftCardImportCheckingDialog
extends POSDialog {
    private BeanTableModel<GiftCard> a;
    private JXTable b;
    private File c;
    private List<GiftCard> d;
    private TitlePanel e;
    private boolean f;
    private List<GiftCard> g;

    public GiftCardImportCheckingDialog(File file) {
        this.c = file;
        this.b();
        this.a();
    }

    private void a() {
        try {
            List<GiftCard> list = this.a(this.c.toURI().toURL());
            if (list == null) {
                return;
            }
            this.a.setRows(list);
            this.a(list);
            this.a(list.size());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardImportCheckingDialog.0"), exception);
        }
    }

    private void a(int n) {
        this.e.setTitle(Messages.getString("GiftCardImportCheckingDialog.1") + n + Messages.getString("GiftCardImportCheckingDialog.2"));
    }

    private void b() {
        this.setTitle(VersionInfo.getAppName());
        this.e = new TitlePanel();
        this.a = new BeanTableModel(GiftCard.class);
        this.a.addColumn(Messages.getString("GiftCardExplorer.42"), "customCardNumber");
        this.a.addColumn(Messages.getString("GiftCardExplorer.44"), "ownerName", BeanTableModel.EditMode.EDITABLE);
        this.a.addColumn(Messages.getString("GiftCardExplorer.46"), "pinNumber", BeanTableModel.EditMode.EDITABLE);
        this.a.addColumn(Messages.getString("GiftCardExplorer.48"), "batchNo", BeanTableModel.EditMode.EDITABLE);
        this.a.addColumn(Messages.getString("GiftCardExplorer.50"), "balance", BeanTableModel.EditMode.EDITABLE, 11, BeanTableModel.DataType.MONEY);
        this.a.addColumn(Messages.getString("GiftCardExplorer.52"), "issueDate", BeanTableModel.EditMode.EDITABLE);
        this.a.addColumn(Messages.getString("GiftCardExplorer.54"), "activationDate", BeanTableModel.EditMode.EDITABLE);
        this.a.addColumn(Messages.getString("GiftCardExplorer.56"), "deActivationDate", BeanTableModel.EditMode.EDITABLE);
        this.a.addColumn(Messages.getString("GiftCardExplorer.58"), "expiryDate", BeanTableModel.EditMode.EDITABLE);
        this.a.addColumn(Messages.getString("GiftCardExplorer.60"), "active", BeanTableModel.EditMode.EDITABLE);
        this.a.addColumn(Messages.getString("GiftCardExplorer.62"), "disable", BeanTableModel.EditMode.EDITABLE);
        this.a.addColumn(Messages.getString("GiftCardExplorer.64"), "duration", BeanTableModel.EditMode.EDITABLE, 11, BeanTableModel.DataType.NUMBER);
        this.a.addColumn(Messages.getString("GiftCardExplorer.66"), "durationType", BeanTableModel.EditMode.EDITABLE);
        this.a.addColumn(Messages.getString("GiftCardExplorer.68"), "point", BeanTableModel.EditMode.EDITABLE, 11, BeanTableModel.DataType.NUMBER);
        this.b = new JXTable(this.a){

            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                GiftCardImportCheckingDialog.this.b.editCellAt(n, n2);
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)GiftCardImportCheckingDialog.this.b.getCellEditor(n, n2);
                if (defaultCellEditor.getComponent() instanceof JTextField) {
                    JTextField jTextField = (JTextField)defaultCellEditor.getComponent();
                    jTextField.requestFocus();
                    jTextField.selectAll();
                }
            }
        };
        this.b.setHighlighters(new Highlighter[]{new ColorHighlighter((HighlightPredicate)new DuplicateGiftCardHighlighter(), new Color(255, 77, 77), Color.white)});
        this.b.getColumnModel().getColumn(5).setCellEditor(new JDateChooserEditor(new JCheckBox()));
        this.b.getColumnModel().getColumn(6).setCellEditor(new JDateChooserEditor(new JCheckBox()));
        this.b.getColumnModel().getColumn(7).setCellEditor(new JDateChooserEditor(new JCheckBox()));
        this.b.getColumnModel().getColumn(8).setCellEditor(new JDateChooserEditor(new JCheckBox()));
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        this.b.getColumnModel().getColumn(9).setCellEditor(new JCheckBoxEditor(jCheckBox));
        this.b.getColumnModel().getColumn(10).setCellEditor(new JCheckBoxEditor(jCheckBox));
        this.a.initTableRenderer((JTable)this.b);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("DAY");
        jComboBox.addItem("MONTH");
        jComboBox.addItem("YEAR");
        this.b.getColumnModel().getColumn(12).setCellEditor(new JComboBoxEditor(jComboBox));
        this.b.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.resizeColumnWidth((JTable)this.b);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.e, "North");
        this.add((Component)new PosScrollPane((Component)this.b), "Center");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 4 8 6 0", "[][center][]", ""));
        JLabel jLabel = new JLabel();
        jLabel.setBackground(Color.RED);
        jLabel.setOpaque(true);
        JLabel jLabel2 = new JLabel(Messages.getString("GiftCardImportCheckingDialog.11"));
        PosButton posButton = new PosButton(Messages.getString("GiftCardImportCheckingDialog.4"));
        posButton.addActionListener(actionEvent -> this.e());
        PosButton posButton2 = new PosButton(Messages.getString("GiftCardImportCheckingDialog.7"));
        posButton2.addActionListener(actionEvent -> this.f());
        PosButton posButton3 = new PosButton(Messages.getString("DELETE"));
        posButton3.addActionListener(actionEvent -> this.c());
        jPanel.add((Component)jLabel, "left,w 20!,h 12!,split 2");
        jPanel.add(jLabel2);
        jPanel.add((Component)posButton, "split 4");
        jPanel.add(posButton2);
        jPanel.add(posButton3);
        jPanel.add(new PosButton(new CloseDialogAction(this, Messages.getString("CANCEL"))));
        this.add((Component)jPanel, "South");
    }

    private void c() {
        int n = this.b.getSelectedRow();
        if (n < 0) {
            return;
        }
        int n2 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("GiftCardImportCheckingDialog.9"), Messages.getString("GiftCardImportCheckingDialog.10"));
        if (n2 != 0) {
            return;
        }
        GiftCard giftCard = this.a.getRow(n);
        Iterator<GiftCard> iterator = this.g.iterator();
        while (iterator.hasNext()) {
            GiftCard giftCard2 = iterator.next();
            if (!giftCard2.getCardNumber().equals(giftCard.getCardNumber())) continue;
            iterator.remove();
            break;
        }
        this.a.removeRow(n);
        this.a(this.a.getRows().size());
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.d().get(i));
        }
    }

    private List d() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(80);
        arrayList.add(180);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(85);
        arrayList.add(90);
        arrayList.add(70);
        arrayList.add(50);
        arrayList.add(50);
        arrayList.add(50);
        arrayList.add(70);
        arrayList.add(50);
        return arrayList;
    }

    private List<GiftCard> a(URL uRL) {
        return this.b(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GiftCard> b(URL uRL) {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            ArrayList<GiftCard> arrayList = new ArrayList<GiftCard>();
            CSVParser cSVParser = CSVFormat.DEFAULT.withHeader(new String[0]).parse((Reader)bufferedReader);
            String string = GiftCardGeneratorView.generateBatchNumber();
            this.f = false;
            for (CSVRecord cSVRecord : cSVParser) {
                String string2 = this.b("Card Number", cSVRecord);
                if (StringUtils.isEmpty((String)string2)) {
                    this.f = true;
                    continue;
                }
                String string3 = this.b("Owner Name", cSVRecord);
                Date date = this.a("Issue Date", cSVRecord);
                Date date2 = this.a("Expiration Date", cSVRecord);
                Date date3 = this.a("Activation Date", cSVRecord);
                Date date4 = this.a("Deactivation Date", cSVRecord);
                Double d = this.c("Balance", cSVRecord);
                Boolean bl = this.e("Active", cSVRecord);
                Boolean bl2 = this.e("Disable", cSVRecord);
                String string4 = this.b("Duration Type", cSVRecord);
                Integer n = this.d("Duration", cSVRecord);
                String string5 = this.b("Pin Number", cSVRecord);
                String string6 = this.b("Batch Number", cSVRecord);
                Integer n2 = this.d("Point", cSVRecord);
                String string7 = this.b("Email", cSVRecord);
                String string8 = this.b("Type", cSVRecord);
                if (StringUtils.isNotEmpty((String)string2)) {
                    string2 = string2.replace("\"", "");
                    string2 = string2.replaceAll("\\W", "");
                }
                GiftCard giftCard = new GiftCard();
                giftCard.setCardNumber(string2);
                giftCard.setOwnerName(string3);
                giftCard.setIssueDate(date);
                giftCard.setExpiryDate(date2);
                giftCard.setActivationDate(date3);
                giftCard.setDeActivationDate(date4);
                giftCard.setBalance(d);
                if (StringUtils.isBlank((String)giftCard.getOwnerName()) || giftCard.getActivationDate() == null || giftCard.getExpiryDate() == null) {
                    giftCard.setActive(false);
                } else {
                    giftCard.setActive(bl);
                }
                giftCard.setDisable(bl2);
                giftCard.setDurationType(string4);
                giftCard.setDuration(n);
                giftCard.setPinNumber(string5);
                giftCard.setPoint(n2);
                if (StringUtils.isNotBlank((String)string6)) {
                    giftCard.setBatchNo(string6);
                } else {
                    giftCard.setBatchNo(string);
                }
                giftCard.setEmail(string7);
                giftCard.setType(string8);
                arrayList.add(giftCard);
            }
            ArrayList<GiftCard> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            PosLog.error(GiftCardExplorer.class, Messages.getString("MessageDialog.0") + exception);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return null;
    }

    private Date a(String string, CSVRecord cSVRecord) {
        try {
            if (StringUtils.isEmpty((String)string)) {
                return null;
            }
            String string2 = cSVRecord.get(string);
            if (StringUtils.isNotEmpty((String)string2)) {
                Date date = DateUtil.parseByGiftCardDateFormat(string2);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int n = calendar.get(1);
                if (n < 100) {
                    calendar.add(1, 2000);
                }
                return calendar.getTime();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String b(String string, CSVRecord cSVRecord) {
        try {
            String string2 = cSVRecord.get(string);
            if (StringUtils.isNotEmpty((String)string2)) {
                return string2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Double c(String string, CSVRecord cSVRecord) {
        try {
            String string2 = cSVRecord.get(string);
            if (StringUtils.isNotEmpty((String)string2)) {
                return Double.parseDouble(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Integer d(String string, CSVRecord cSVRecord) {
        try {
            String string2 = cSVRecord.get(string);
            if (StringUtils.isNotEmpty((String)string2)) {
                return Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Boolean e(String string, CSVRecord cSVRecord) {
        try {
            String string2 = cSVRecord.get(string);
            if (StringUtils.isNotEmpty((String)string2)) {
                return Boolean.parseBoolean(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public List<GiftCard> getGiftCards() {
        return this.d;
    }

    public void setGiftCards(List<GiftCard> list) {
        this.d = list;
    }

    public boolean isGiftCardExistWithEmptyCardNumber() {
        return this.f;
    }

    private void e() {
        try {
            ArrayList<GiftCard> arrayList = new ArrayList<GiftCard>(this.a.getRows());
            if (arrayList.size() < 1) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardImportCheckingDialog.3"));
                return;
            }
            String string = JOptionPane.showInputDialog(this, (Object)Messages.getString("GiftCardImportCheckingDialog.5"));
            if (StringUtils.isEmpty((String)string)) {
                return;
            }
            int n = JOptionPane.showConfirmDialog(this, Messages.getString("GiftCardImportCheckingDialog.6"));
            if (n != 0) {
                return;
            }
            for (GiftCard giftCard : arrayList) {
                giftCard.setBatchNo(string);
            }
            this.a.fireTableRowsUpdated(0, this.b.getRowCount() - 1);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void f() {
        if (this.a.getRows().size() < 1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardImportCheckingDialog.3"));
            return;
        }
        this.d = new ArrayList<GiftCard>();
        this.d.addAll(this.a.getRows());
        if (!this.g.isEmpty()) {
            POSMessageDialog.showError(Messages.getString("GiftCardImportCheckingDialog.12"));
            return;
        }
        if (!this.d.isEmpty()) {
            String string = "";
            int n = 1;
            for (GiftCard giftCard : this.d) {
                if (StringUtils.isNotBlank((String)giftCard.getCardNumber()) && giftCard.getCardNumber().length() > 16) {
                    if (StringUtils.isNotBlank((String)string)) {
                        string = string + " \n";
                    }
                    string = string + n + ". " + giftCard.getCardNumber();
                    ++n;
                }
                if (!StringUtils.isBlank((String)giftCard.getOwnerName()) && giftCard.getActivationDate() != null && giftCard.getExpiryDate() != null) continue;
                giftCard.setActive(false);
            }
            if (StringUtils.isNotBlank((String)string)) {
                DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(Messages.getString("GiftCardImportCheckingDialog.8"), string);
                detailsInfoDialog.open();
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void a(List<GiftCard> list) {
        this.g = new ArrayList<GiftCard>();
        for (GiftCard giftCard : list) {
            GiftCard giftCard2 = GiftCardDAO.getInstance().findByCardNumber(giftCard.getCardNumber());
            if (giftCard2 == null) continue;
            this.g.add(giftCard2);
        }
    }

    class JCheckBoxEditor
    extends DefaultCellEditor {
        JCheckBox a;

        public JCheckBoxEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            GiftCard giftCard = (GiftCard)GiftCardImportCheckingDialog.this.a.getRow(n);
            this.a = (JCheckBox)this.getComponent();
            if (n2 == 9) {
                this.a.setSelected(giftCard.isActive());
            } else if (n2 == 10) {
                this.a.setSelected(giftCard.isDisable());
            }
            return this.a;
        }

        @Override
        public Object getCellEditorValue() {
            return this.a.isSelected();
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    class JComboBoxEditor
    extends DefaultCellEditor {
        JComboBox a;

        public JComboBoxEditor(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            GiftCard giftCard = (GiftCard)GiftCardImportCheckingDialog.this.a.getRow(n);
            this.a = (JComboBox)this.getComponent();
            if (n2 == 12 && giftCard.getDurationType() != null) {
                this.a.setSelectedItem(giftCard.getDurationType());
            }
            return this.a;
        }

        @Override
        public Object getCellEditorValue() {
            return this.a.getSelectedItem();
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    class JDateChooserEditor
    extends DefaultCellEditor {
        DateTimePicker a;

        public JDateChooserEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.a = new DateTimePicker();
            GiftCard giftCard = (GiftCard)GiftCardImportCheckingDialog.this.a.getRow(n);
            if (n2 == 5) {
                this.a.setDate(giftCard.getIssueDate());
            } else if (n2 == 6) {
                this.a.setDate(giftCard.getActivationDate());
            } else if (n2 == 7) {
                this.a.setDate(giftCard.getDeActivationDate());
            } else if (n2 == 8) {
                this.a.setDate(giftCard.getExpiryDate());
            }
            return this.a;
        }

        @Override
        public Object getCellEditorValue() {
            return this.a.getDate();
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    class DuplicateGiftCardHighlighter
    implements HighlightPredicate {
        DuplicateGiftCardHighlighter() {
        }

        public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
            int n = GiftCardImportCheckingDialog.this.b.convertRowIndexToModel(componentAdapter.row);
            GiftCard giftCard = (GiftCard)GiftCardImportCheckingDialog.this.a.getRow(n);
            return !GiftCardImportCheckingDialog.this.g.isEmpty() && GiftCardImportCheckingDialog.this.g.contains(giftCard);
        }
    }
}

