/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.TicketDeletedException;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.TicketMergeUtil;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class MergeTicketDialog
extends POSDialog
implements RefreshableView {
    private List<Ticket> a;
    private Ticket b;
    private JTextField c;
    private JTextField d;
    private JTextField e;
    private JTextField f;
    private TicketViewerTable g;
    private DataChangeListener h;

    public MergeTicketDialog(List<Ticket> list, Ticket ticket) {
        this.a = list;
        this.b = ticket;
        this.a();
        this.b();
        this.updateView();
    }

    private void a() {
        TicketMergeUtil.doMergeTickets(this.b, this.a);
    }

    private void b() {
        this.setLayout(new BorderLayout(10, 10));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("MergeTicketDialog.0"));
        this.add((Component)titlePanel, "North");
        TransparentPanel transparentPanel = new TransparentPanel(new BorderLayout(5, 5));
        transparentPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.g = new TicketViewerTable();
        this.g.getModel().setTicket(this.b);
        PosScrollPane posScrollPane = new PosScrollPane();
        posScrollPane.setHorizontalScrollBarPolicy(31);
        posScrollPane.setVerticalScrollBarPolicy(20);
        posScrollPane.setViewportView(this.g);
        transparentPanel.add((Component)posScrollPane, "Center");
        TransparentPanel transparentPanel2 = new TransparentPanel((LayoutManager)new MigLayout("wrap 2,right,inset 5 5 5 "));
        JLabel jLabel = new JLabel(POSConstants.SUBTOTAL + ":");
        JLabel jLabel2 = new JLabel(POSConstants.DISCOUNT + ":");
        JLabel jLabel3 = new JLabel(POSConstants.TAX + ":");
        JLabel jLabel4 = new JLabel(POSConstants.TOTAL + ":");
        this.c = new JTextField();
        this.c.setHorizontalAlignment(11);
        this.c.setColumns(10);
        this.d = new JTextField();
        this.d.setHorizontalAlignment(11);
        this.d.setColumns(10);
        this.e = new JTextField();
        this.e.setHorizontalAlignment(11);
        this.e.setColumns(10);
        this.f = new JTextField();
        this.f.setHorizontalAlignment(11);
        this.f.setColumns(10);
        jLabel.setHorizontalAlignment(4);
        transparentPanel2.add(jLabel);
        this.c.setEditable(false);
        transparentPanel2.add(this.c);
        jLabel2.setHorizontalAlignment(4);
        transparentPanel2.add(jLabel2);
        this.e.setEditable(false);
        transparentPanel2.add(this.e);
        jLabel3.setHorizontalAlignment(4);
        transparentPanel2.add(jLabel3);
        this.d.setEditable(false);
        transparentPanel2.add(this.d);
        jLabel4.setHorizontalAlignment(4);
        transparentPanel2.add(jLabel4);
        this.f.setEditable(false);
        transparentPanel2.add(this.f);
        transparentPanel.add((Component)transparentPanel2, "South");
        this.add((Component)transparentPanel, "Center");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton posButton = new PosButton(Messages.getString("MergeTicketDialog.3"));
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MergeTicketDialog.this.c();
            }
        });
        PosButton posButton2 = new PosButton(Messages.getString("Cancel"));
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MergeTicketDialog.this.setCanceled(true);
                MergeTicketDialog.this.dispose();
            }
        });
        jPanel.add(posButton);
        jPanel.add(posButton2);
        this.add((Component)jPanel, "South");
        this.resizeColumnWidth(this.g);
    }

    private void c() {
        try {
            this.a(this.b, this.a);
            TicketDAO.getInstance().saveMergedTickets(this.a, this.b);
            this.setCanceled(false);
            this.dispose();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(Ticket ticket, List<Ticket> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tickets: ");
        Object object = list.iterator();
        while (object.hasNext()) {
            Ticket ticket2 = object.next();
            stringBuilder.append(ticket2.getId());
            if (!object.hasNext()) continue;
            stringBuilder.append(", ");
        }
        object = stringBuilder.toString();
        if (((String)object).length() > 255) {
            object = ((String)object).substring(0, 255);
        }
        ticket.addEvent("Merge ticket", (String)object);
    }

    public void updateView() {
        if (this.b == null || this.b.getTicketItems() == null || this.b.getTicketItems().size() <= 0) {
            this.c.setText("");
            this.e.setText("");
            this.d.setText("");
            this.f.setText("");
            return;
        }
        this.b.calculatePrice();
        this.c.setText(NumberUtil.formatNumber(this.b.getSubtotalAmount()));
        this.e.setText(NumberUtil.formatNumber(this.b.getDiscountAmount()));
        this.d.setText(NumberUtil.formatNumber(this.b.getTaxAmount()));
        this.f.setText(NumberUtil.formatNumber(this.b.getTotalAmountWithTips()));
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.d().get(i));
        }
    }

    private List d() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(200);
        arrayList.add(100);
        arrayList.add(100);
        return arrayList;
    }

    public Ticket getMainTicket() {
        return this.b;
    }

    @Override
    public void refresh() {
        try {
            this.b = TicketDAO.getInstance().loadFullTicket(this.b.getId());
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>(this.a);
            this.a.clear();
            for (Ticket ticket : arrayList) {
                ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                if (ticket == null) continue;
                this.a.add(ticket);
            }
            this.a();
            this.g.getModel().setTicket(this.b);
            this.updateView();
        }
        catch (TicketDeletedException ticketDeletedException) {
            POSMessageDialog.showError(Application.getPosWindow(), ticketDeletedException.getMessage());
            if (this.h != null) {
                this.h.dataSetUpdated();
            }
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage());
        }
    }

    public void setDataChangeListener(DataChangeListener dataChangeListener) {
        this.h = dataChangeListener;
    }
}

