/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.ui.views.payment.ManualGiftCardEntryDialog;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.ui.views.payment.SwipeCardDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Window;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.StaleStateException;

public class GiftCardInputListener
implements CardInputListener {
    private SettleTicketProcessor a;

    public GiftCardInputListener(SettleTicketProcessor settleTicketProcessor) {
        this.a = settleTicketProcessor;
    }

    @Override
    public void cardInputted(CardInputProcessor cardInputProcessor, PaymentType paymentType, String string) {
        Window window = POSUtil.getFocusedWindow();
        try {
            switch (paymentType) {
                case GIFT_CERTIFICATE: {
                    this.a(cardInputProcessor, paymentType, string);
                    break;
                }
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(window, this.a.getRefreshableView());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(window, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(window, Messages.getString("SettleTicketProcessor.1"), exception);
        }
    }

    private void a(CardInputProcessor cardInputProcessor, PaymentType paymentType, String string) throws Exception {
        PosTransaction posTransaction = paymentType.createTransaction();
        posTransaction.setTicket(this.a.getTicket());
        GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
        if (giftCardPaymentPlugin == null) {
            throw new PosException(Messages.getString("SettleTicketProcessor.3"));
        }
        GiftCardProcessor giftCardProcessor = giftCardPaymentPlugin.getProcessor();
        if (cardInputProcessor instanceof SwipeCardDialog) {
            SwipeCardDialog swipeCardDialog = (SwipeCardDialog)cardInputProcessor;
            String string2 = swipeCardDialog.getCardString();
            giftCardProcessor.validateCardNo(string2);
            GiftCard giftCard = giftCardProcessor.getCard(string2);
            posTransaction.setCardType(string);
            posTransaction.setGiftCertNumber(giftCard.getCardNumber());
            posTransaction.setCaptured(false);
            posTransaction.setCardMerchantGateway(giftCardPaymentPlugin.getProductName());
            posTransaction.setCardReader(CardReader.SWIPE.name());
            this.a.setTransactionAmounts(posTransaction);
            giftCardProcessor.chargeAmount(posTransaction);
            this.a.settleTicket(posTransaction, giftCardProcessor);
        } else if (cardInputProcessor instanceof ManualGiftCardEntryDialog) {
            ManualGiftCardEntryDialog manualGiftCardEntryDialog = (ManualGiftCardEntryDialog)cardInputProcessor;
            giftCardProcessor.validateCard(manualGiftCardEntryDialog.getCardNo(), manualGiftCardEntryDialog.getPinNo());
            GiftCard giftCard = giftCardProcessor.getCard(manualGiftCardEntryDialog.getCardNo());
            Calendar calendar = Calendar.getInstance();
            Date date = giftCard.getExpiryDate();
            if (date != null) {
                calendar.setTime(date);
                posTransaction.setCardExpMonth("" + calendar.get(2) + 1);
                posTransaction.setCardExpYear("" + calendar.get(1));
            }
            posTransaction.setCaptured(false);
            posTransaction.setCardMerchantGateway(giftCardPaymentPlugin.getProductName());
            posTransaction.setCardReader(CardReader.MANUAL.name());
            posTransaction.setCardHolderName(giftCard.getOwnerName());
            posTransaction.setGiftCertNumber(giftCard.getCardNumber());
            this.a.setTransactionAmounts(posTransaction);
            giftCardProcessor.chargeAmount(posTransaction);
            this.a.settleTicket(posTransaction, giftCardProcessor);
        }
    }
}

