/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.floreantpos.PosLog;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class AddressUtil {
    private List<Country> a;

    public AddressUtil() {
        this.a();
    }

    public List<String> getCityNames(String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Country country : this.a) {
            if (StringUtils.isBlank((String)country.getName()) || !country.getName().equalsIgnoreCase(string)) continue;
            for (State state : country.getStates()) {
                if (!state.getName().equalsIgnoreCase(string2)) continue;
                for (City city : state.getCities()) {
                    linkedList.add(city.getName());
                }
                return linkedList;
            }
        }
        return linkedList;
    }

    public List<String> getStateNames(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Country country : this.a) {
            if (StringUtils.isBlank((String)country.getName()) || !country.getName().equalsIgnoreCase(string)) continue;
            for (State state : country.getStates()) {
                linkedList.add(state.getName());
            }
            return linkedList;
        }
        return linkedList;
    }

    public List<String> getCountryNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Country country : this.a) {
            linkedList.add(country.getName());
        }
        return linkedList;
    }

    private void a() {
        if (this.a != null && this.a.size() > 0) {
            return;
        }
        String string = "/country-list.json";
        try (InputStream inputStream = this.getClass().getResourceAsStream(string);){
            String string2 = IOUtils.toString((InputStream)inputStream);
            ObjectMapper objectMapper = new ObjectMapper();
            this.a = (List)objectMapper.readValue(string2, (TypeReference)new TypeReference<List<Country>>(){});
            Collections.sort(this.a, Comparator.comparing(Country::getName, Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER)));
        }
        catch (Exception exception) {
            this.a = new ArrayList<Country>(0);
            PosLog.error(this.getClass(), exception);
        }
    }

    public static class City
    implements Serializable {
        private String a;

        public String getName() {
            return this.a;
        }

        public void setName(String string) {
            this.a = string;
        }

        public String toString() {
            return this.a;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.a == null ? 0 : this.a.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            City city = (City)object;
            return !(this.a == null ? city.a != null : !this.a.equals(city.a));
        }
    }

    public static class State
    implements Serializable {
        private String a;
        private List<City> b;

        public String getName() {
            return this.a;
        }

        public void setName(String string) {
            this.a = string;
        }

        public List<City> getCities() {
            return this.b;
        }

        public void setCities(List<City> list) {
            this.b = list;
        }

        public String toString() {
            return this.a;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.a == null ? 0 : this.a.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            State state = (State)object;
            return !(this.a == null ? state.a != null : !this.a.equals(state.a));
        }
    }

    public static class Country
    implements Serializable {
        private String a;
        private List<State> b;

        public String getName() {
            return this.a;
        }

        public void setName(String string) {
            this.a = string;
        }

        public List<State> getStates() {
            return this.b;
        }

        public void setStates(List<State> list) {
            this.b = list;
        }

        public String toString() {
            return this.a;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.a == null ? 0 : this.a.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Country country = (Country)object;
            return !(this.a == null ? country.a != null : !this.a.equals(country.a));
        }
    }
}

