/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class BarcodeUtil {
    private static String a(String string) {
        if (!BarcodeUtil.isGTIN(string)) {
            return null;
        }
        if (string.length() == 14 && string.startsWith("02")) {
            return string.substring(1);
        }
        if (string.length() == 13 && string.startsWith("2")) {
            return string;
        }
        return null;
    }

    private static void b(String string) {
        if (string == null) {
            throw new NullPointerException("GTIN must not be null");
        }
        if (!BarcodeUtil.isDigits(string)) {
            throw new IllegalArgumentException("Invalid GTIN " + string + ", must be digits");
        }
        if (string.length() != 14 && string.length() != 13) {
            throw new IllegalArgumentException("Invalid GTIN " + string + ", must be 13 or 14 digits long");
        }
    }

    public static boolean isGTIN(String string) {
        return BarcodeUtil.isDigits(string) && (string.length() == 14 || string.length() == 13 || string.length() == 12 || string.length() == 8);
    }

    public static String extractBarcodeFromVariableMeasureItem(String string) {
        BarcodeUtil.b(string);
        if (!BarcodeUtil.isVariableMeasureItem(string)) {
            throw new IllegalArgumentException("GTIN " + string + " is not contains either weight or price");
        }
        String string2 = BarcodeUtil.a(string);
        return string2.substring(2, 7);
    }

    public static BigDecimal extractPriceFromVariableMeasureItem(String string) {
        BarcodeUtil.b(string);
        String string2 = BarcodeUtil.a(string);
        if (string2 == null || string2.charAt(1) < '0' || string2.charAt(1) > '2') {
            throw new IllegalArgumentException("GTIN " + string + " is not a variable measure item with price");
        }
        int n = Integer.parseInt(string2.substring(8, 12));
        if (string2.charAt(1) == '0') {
            return new BigDecimal(n).movePointLeft(2);
        }
        if (string2.charAt(1) == '1') {
            return new BigDecimal(n).movePointLeft(1).setScale(2, RoundingMode.UNNECESSARY);
        }
        return new BigDecimal(n).setScale(2, RoundingMode.UNNECESSARY);
    }

    public static Double extractWeightFromVariableMeasureItem(String string) throws Exception {
        BarcodeUtil.b(string);
        String string2 = BarcodeUtil.a(string);
        if (string2 == null || string2.charAt(1) < '3' || string2.charAt(1) > '5') {
            throw new IllegalArgumentException("GTIN " + string + " is not a variable measure item with weight");
        }
        Double d = Double.parseDouble(string2.substring(8, 12));
        if (string2.charAt(1) == '3') {
            return d;
        }
        if (string2.charAt(1) == '4') {
            return d * 10.0;
        }
        return d * 100.0;
    }

    public static boolean isDigits(String string) {
        if (string == null || string.length() < 1) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isVariableMeasureItemWithWeight(String string) {
        String string2 = BarcodeUtil.a(string);
        return string2 != null && string2.charAt(1) >= '3' && string2.charAt(1) <= '5';
    }

    public static boolean isVariableMeasureItemWithPrice(String string) {
        String string2 = BarcodeUtil.a(string);
        return string2 != null && string2.charAt(1) >= '0' && string2.charAt(1) <= '2';
    }

    public static boolean isVariableMeasureItem(String string) {
        String string2 = BarcodeUtil.a(string);
        return string2 != null && string2.charAt(1) >= '0' && string2.charAt(1) <= '5';
    }
}

