/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.StoreAlreadyCloseException;
import com.floreantpos.StoreAlreadyOpenException;
import com.floreantpos.main.Application;
import com.floreantpos.model.DayOfWeek;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionControlDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.CashRoundingRule;
import com.floreantpos.util.POSUtil;
import com.orocube.licensemanager.OroLicense;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class StoreUtil {
    private OroLicense a;

    public StoreUtil() {
        this(Application.getInstance().getLicense());
    }

    public StoreUtil(OroLicense oroLicense) {
        this.a = oroLicense;
    }

    public static StoreSession getCurrentStoreSession() {
        return StoreSessionDAO.getInstance().getLastStoreSession();
    }

    public static boolean isStoreOpen() {
        StoreSession storeSession = StoreUtil.getCurrentStoreSession();
        return storeSession != null && storeSession.isOpen();
    }

    public static void openStore(User user) {
        Outlet outlet = DataProvider.get().getOutlet();
        StoreUtil.openStore(user, outlet == null ? null : outlet.getId());
    }

    public static void openStore(User user, String string) {
        if (StoreUtil.isStoreOpen()) {
            throw new StoreAlreadyOpenException(Messages.getString("StoreUtil.0"));
        }
        StoreSession storeSession = new StoreSession();
        storeSession.setOpenedBy(user);
        storeSession.setOpenTime(new Date());
        storeSession.setOutletId(string);
        SequenceNumber sequenceNumber = SequenceNumberDAO.getInstance().get("TICKET_TOKEN_NUMBER");
        if (sequenceNumber == null) {
            sequenceNumber = new SequenceNumber("TICKET_TOKEN_NUMBER");
        }
        Store store = DataProvider.get().getStore();
        boolean bl = store.getBooleanProperty("reset.token", true);
        String string2 = store.getProperty("token_no.start");
        Integer n = POSUtil.parseInteger(string2);
        if (bl) {
            if (n > 0) {
                sequenceNumber.setNextSequenceNumber(n);
            } else {
                sequenceNumber.setNextSequenceNumber(1);
            }
        }
        StoreSessionDAO.getInstance().save(storeSession);
        DataProvider.get().setStoreSession(storeSession);
        StoreSessionControl storeSessionControl = StoreUtil.a();
        if (storeSessionControl != null) {
            storeSessionControl.setCurrentData(storeSession);
        }
        TerminalDAO.getInstance().performBatchSave(sequenceNumber, storeSessionControl);
    }

    public static void closeStore(User user) throws Exception {
        StoreSession storeSession = StoreUtil.getCurrentStoreSession();
        if (!storeSession.isOpen()) {
            throw new StoreAlreadyCloseException(Messages.getString("StoreUtil.1"));
        }
        StoreDAO.getInstance().closeStore(storeSession, user);
        DataProvider.get().setStoreSession(null);
    }

    @Deprecated
    private static StoreSessionControl a() {
        return StoreSessionControlDAO.getInstance().getCurrent();
    }

    public static void closeStore(Session session, User user) throws Exception {
        StoreSession storeSession = StoreUtil.getCurrentStoreSession();
        if (!storeSession.isOpen()) {
            throw new StoreAlreadyCloseException(Messages.getString("StoreUtil.1"));
        }
        StoreDAO.getInstance().closeStore(session, storeSession, user);
        DataProvider.get().setStoreSession(null);
    }

    public static int getQuickTenderButtonValue(int n, int n2, Store store) {
        return POSUtil.parseInteger(store.getProperty("quick_tender_input.button_value" + n, String.valueOf(n2)));
    }

    public static void setQuickTenderButtonValue(int n, String string, Store store) {
        store.addProperty("quick_tender_input.button_value" + n, string);
    }

    public static String getQuickTenderButtonText(int n, String string, Store store) {
        return store.getProperty("quick_tender_input.button_text" + n, string);
    }

    public static void setQuickTenderButtonText(int n, String string, Store store) {
        store.addProperty("quick_tender_input.button_text" + n, string);
    }

    public static void setQuickTenderButtonFontSize(int n, Store store) {
        store.addProperty("quick_tender_input.button_font_size", String.valueOf(n));
    }

    public static int getQuickTenderButtonFontSize(Store store) {
        String string = store.getProperty("quick_tender_input.button_font_size");
        if (StringUtils.isNotBlank((String)string)) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                return 24;
            }
        }
        return 24;
    }

    @XmlTransient
    public static boolean isAutoOpenStore(Store store) {
        Outlet outlet;
        String string = store.getProperty("auto_open_store");
        if (StringUtils.isBlank((String)string) && (outlet = DataProvider.get().getOutlet()) != null) {
            return outlet.getBooleanProperty("auto_open_store", false);
        }
        return Boolean.valueOf(string);
    }

    public static void setAutoOpenStore(boolean bl, Store store) {
        store.addProperty("auto_open_store", String.valueOf(bl));
    }

    @XmlTransient
    public static boolean isAutoCloseStore(Store store) {
        Outlet outlet;
        String string = store.getProperty("auto_close_store");
        if (StringUtils.isBlank((String)string) && (outlet = DataProvider.get().getOutlet()) != null) {
            return outlet.getBooleanProperty("auto_close_store", false);
        }
        return Boolean.valueOf(string);
    }

    public static void setAutoCloseStore(boolean bl, Store store) {
        store.addProperty("auto_close_store", String.valueOf(bl));
    }

    @XmlTransient
    public static String getAutoCloseStoreTime(Store store) {
        Outlet outlet;
        String string = store.getProperty("store_close_time");
        if (StringUtils.isBlank((String)string) && (outlet = DataProvider.get().getOutlet()) != null) {
            return outlet.getProperty("store_close_time");
        }
        return string;
    }

    public static void setAutoCloseStoreTime(String string, Store store) {
        store.addProperty("store_close_time", string);
    }

    @XmlTransient
    public static String getAutoOpenCloseStoreBy(Store store) {
        Outlet outlet;
        String string = store.getProperty("auto_open_close_store_by");
        if (StringUtils.isBlank((String)string) && (outlet = DataProvider.get().getOutlet()) != null) {
            return outlet.getProperty("auto_open_close_store_by");
        }
        return string;
    }

    public static void setAutoOpenCloseStoreBy(String string, Store store) {
        store.addProperty("auto_open_close_store_by", string);
    }

    public static void addWorkingHoursToStoreProperty(Store store, JCheckBox jCheckBox, JComboBox<Date> jComboBox, JComboBox<Date> jComboBox2) {
        StoreUtil.setOpenStoreByDay(store, jCheckBox.getText(), jCheckBox.isSelected());
        if (jCheckBox.isSelected()) {
            store.addProperty(jCheckBox.getText() + ".StartTime", DateUtil.getOnlyFormattedTime((Date)jComboBox.getSelectedItem()));
            store.addProperty(jCheckBox.getText() + ".EndTime", DateUtil.getOnlyFormattedTime((Date)jComboBox2.getSelectedItem()));
        }
    }

    public static void updateHourFromStoreProperty(Store store, JCheckBox jCheckBox, JComboBox<Date> jComboBox, JComboBox<Date> jComboBox2) {
        jCheckBox.setSelected(StoreUtil.isOpenStoreByDay(store, jCheckBox.getText()));
        jComboBox.setSelectedItem(DateUtil.getOnlyFormattedTime(store.getProperty(jCheckBox.getText() + ".StartTime", "10:00 AM")));
        jComboBox2.setSelectedItem(DateUtil.getOnlyFormattedTime(store.getProperty(jCheckBox.getText() + ".EndTime", "08:00 PM")));
    }

    public static boolean isOpenStoreByDay(Store store, String string) {
        return store.getBooleanProperty(string + ".Open", false);
    }

    public static void setOpenStoreByDay(Store store, String string, boolean bl) {
        store.addProperty(string + ".Open", String.valueOf(bl));
    }

    public static int getStartDayOfWeek(Store store) {
        try {
            String string = store.getProperty("StartDayOfWeek");
            if (StringUtils.isNotEmpty((String)string)) {
                return Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DayOfWeek.Monday.getValue();
    }

    public static void setStartDayOfWeek(Store store, int n) {
        store.addProperty("StartDayOfWeek", String.valueOf(n));
    }

    public static boolean isStoreOpeningHourConfigured(Store store) {
        return store.hasProperty("StartDayOfWeek");
    }

    public static void setCashRoundRule(Store store, CashRoundingRule cashRoundingRule) {
        store.addProperty("cash.rounding.rule", cashRoundingRule.name());
    }

    public static CashRoundingRule getCashRounding(Store store) {
        try {
            String string = store.getProperty("cash.rounding.rule");
            if (StringUtils.isBlank((String)string)) {
                return CashRoundingRule._NOROUNDING;
            }
            return CashRoundingRule.valueOf(string);
        }
        catch (Exception exception) {
            return CashRoundingRule._NOROUNDING;
        }
    }

    public String getName(Store store) {
        if (this.a != null && this.a.isDemoLicense()) {
            return Messages.getString("StoreUtil.2");
        }
        return store.getName();
    }
}

