/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.mqtt;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.main.Application;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.AboutDialog;
import com.floreantpos.ui.dialog.OroLicenceActivationDialog;
import com.floreantpos.ui.dialog.OroLicenseInfoDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.util.AsyncAction;
import com.floreantpos.util.KitchenTicketUtill;
import com.floreantpos.util.LicenseFileUtil;
import com.floreantpos.util.OrgJsonUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.common.about.PluginAboutDialog;
import com.orocube.common.about.dialog.OroCommonLicenceActivationDialog;
import com.orocube.common.util.TerminalUtil;
import com.orocube.common.util.TicketStatus;
import com.orocube.licensemanager.LicenseNotFoundException;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.rest.service.mqtt.MqttSender;
import com.orocube.rest.service.mqtt.OroMqttClient;
import com.orocube.rest.service.mqtt.OroMqttDataListener;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.swing.JDialog;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONObject;

public abstract class OroMqttMessageReceiver
implements IMqttMessageListener {
    private final Vector<OroMqttDataListener> dataListeners = new Vector();

    public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
        AsyncAction.execute(() -> {
            try {
                Vector<OroMqttDataListener> vector = this.dataListeners;
                synchronized (vector) {
                    this.handleMessage(string, mqttMessage);
                }
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        });
    }

    private void handleMessage(String string, MqttMessage mqttMessage) throws Exception {
        block39: {
            block38: {
                String string2;
                if (!string.endsWith("MQTT-COMMAND")) break block38;
                switch (string2 = new String(mqttMessage.getPayload())) {
                    case "2": {
                        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                            oroMqttDataListener.refreshBookingRequestReceived(string, mqttMessage);
                        }
                        break block39;
                    }
                    case "3": {
                        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                            oroMqttDataListener.refreshKDSRequestReceived(string, mqttMessage);
                        }
                        break block39;
                    }
                    case "REFRESH_DISPATCH_VIEW": {
                        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                            oroMqttDataListener.refreshDispatchView(string, mqttMessage);
                        }
                        break block39;
                    }
                    case "1": {
                        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                            oroMqttDataListener.refreshTablesRequestReceived(string, mqttMessage);
                        }
                        break block39;
                    }
                    case "4": {
                        String string3 = Application.getInstance().getCurrentTerminalOutletId();
                        String[] stringArray = string.split("/");
                        String string4 = stringArray[1];
                        if (StringUtils.isBlank((String)string4)) break;
                        if (string4.equals("MQTT-COMMAND") || string4.equals(string3)) {
                            for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                                oroMqttDataListener.cloudDataUpdateRequestReceived();
                            }
                        }
                        break block39;
                    }
                    default: {
                        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                            oroMqttDataListener.mqttCommandReceived(string, mqttMessage);
                        }
                        break block39;
                    }
                }
                break block39;
            }
            if (string.endsWith("auto-update-service")) {
                for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                    oroMqttDataListener.autoUpdateRequestReceived(string, mqttMessage);
                }
            } else if (string.endsWith("MQTT-COMMAND-KIT-DIS-UPDATE")) {
                for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                    oroMqttDataListener.refreshKDSRequestReceived(string, mqttMessage);
                }
            } else if (string.endsWith("public") || string.endsWith("data")) {
                String string5 = POSUtil.decompress(mqttMessage.getPayload());
                if (StringUtils.isEmpty((String)string5)) {
                    return;
                }
                this.debug("Notification received: ");
                JSONObject jSONObject = new JSONObject(string5);
                if (!this.isValidMessage(jSONObject)) {
                    return;
                }
                this.messageReceived(jSONObject);
            } else if (string.endsWith("MQTT-COMMAND-REFRESH-CACHE")) {
                for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                    oroMqttDataListener.cacheRefreshRequestReceived(string, mqttMessage);
                }
            } else if (string.endsWith("MQTT-COMMAND-STORE-CLOSED")) {
                for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
                    oroMqttDataListener.storeCloseRequestReceived(string, mqttMessage);
                }
            } else if (string.equalsIgnoreCase(TerminalUtil.getSystemUID())) {
                this.doUpdateLicense(mqttMessage);
            }
        }
    }

    private void doUpdateLicense(MqttMessage mqttMessage) throws IOException, Exception {
        try {
            String string = POSUtil.decompress(mqttMessage.getPayload());
            if (StringUtils.isEmpty((String)string)) {
                throw new Exception(Messages.getString("OroLicenceActivationDialog.25"));
            }
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(string));
            JsonObject jsonObject = jsonReader.readObject();
            this.doSetLicense(jsonObject);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void doSetLicense(JsonObject jsonObject) throws Exception {
        String string = TerminalUtil.getSystemUID();
        String string2 = jsonObject.getString("product");
        OroLicense oroLicense = this.getExistingLicense(string2, string);
        if (oroLicense != null && oroLicense.isValid() && !oroLicense.isDemoLicense()) {
            PosLog.info(this.getClass(), "Existing license is valid and will expiry " + oroLicense.getExpiryDate());
        }
        PosLog.info(this.getClass(), "Start loading new license");
        File file = LicenseFileUtil.convertJsonObjectToFile(jsonObject);
        OroLicense oroLicense2 = LicenseUtil.loadAndValidate((File)file, (String)string2, null, (String)string);
        if (oroLicense2 != null && oroLicense2.isValid()) {
            LicenseUtil.copyLicenseFile((File)file, (String)string2);
            PosLog.info(this.getClass(), "New license copied. Expiry date: " + oroLicense2.getExpiryDate());
            this.showLicenseInfoDialog(oroLicense2);
            if (string2.equalsIgnoreCase(VersionInfo.getAppName())) {
                Application.getInstance().initLicense(string);
            }
        } else {
            PosLog.error(this.getClass(), Messages.getString("OroLicenceActivationDialog.17"));
        }
    }

    private OroLicense getExistingLicense(String string, String string2) {
        try {
            if (string.equalsIgnoreCase(VersionInfo.getAppName())) {
                Application application = Application.getInstance();
                OroLicense oroLicense = LicenseUtil.loadAndValidate((String)VersionInfo.getProductid(), (String)application.getProductName(), (String)application.getProductVersion(), (String)string2);
                return oroLicense;
            }
            List<FloreantPlugin> list = ExtensionManager.getPlugins();
            if (list != null && list.size() > 0) {
                for (FloreantPlugin floreantPlugin : list) {
                    String string3 = floreantPlugin.getProductName();
                    if (!string3.equalsIgnoreCase(string)) continue;
                    return floreantPlugin.getLicense();
                }
            }
        }
        catch (LicenseNotFoundException licenseNotFoundException) {
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return null;
    }

    private void showLicenseInfoDialog(OroLicense oroLicense) {
        boolean bl;
        boolean bl2 = bl = Application.getCurrentUser() == null && oroLicense.getProductName().equalsIgnoreCase(VersionInfo.getAppName());
        if (!bl) {
            Application.getPosWindow().getStatusBar().setVisibleRestartButton(true);
        }
        Window[] windowArray = Window.getWindows();
        for (Window window : windowArray) {
            if (!window.isShowing() || !(window instanceof BackOfficeWindow)) continue;
            BackOfficeWindow backOfficeWindow = (BackOfficeWindow)window;
            backOfficeWindow.getStatusBar().setVisibleRestartButton(true);
            break;
        }
        this.closePopupLicenseWindows(windowArray, oroLicense);
        OroLicenseInfoDialog oroLicenseInfoDialog = new OroLicenseInfoDialog(oroLicense, (boolean)Boolean.FALSE);
        oroLicenseInfoDialog.setSize(PosUIManager.getSize(500, 500));
        oroLicenseInfoDialog.setLocationRelativeTo(null);
        oroLicenseInfoDialog.setVisible(true);
    }

    private void closePopupLicenseWindows(Window[] windowArray, OroLicense oroLicense) {
        try {
            for (Window window : windowArray) {
                JDialog jDialog;
                if (!window.isShowing() || !(window instanceof OroCommonLicenceActivationDialog) && !(window instanceof OroLicenceActivationDialog) && !(window instanceof PluginAboutDialog) && !(window instanceof AboutDialog) && !(window instanceof OroLicenseInfoDialog)) continue;
                if (window instanceof OroLicenceActivationDialog) {
                    jDialog = (OroLicenceActivationDialog)window;
                    ((OroLicenceActivationDialog)jDialog).setLicense(oroLicense);
                    ((POSDialog)jDialog).setCanceled(false);
                    jDialog.dispose();
                    continue;
                }
                if (window instanceof OroCommonLicenceActivationDialog) {
                    jDialog = (OroCommonLicenceActivationDialog)window;
                    jDialog.setLicense(oroLicense);
                    jDialog.setCanceled(false);
                    jDialog.dispose();
                    continue;
                }
                if (window instanceof POSDialog) {
                    jDialog = (POSDialog)window;
                    ((POSDialog)jDialog).setCanceled(false);
                    jDialog.dispose();
                    continue;
                }
                jDialog = (JDialog)window;
                jDialog.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void messageReceived(JSONObject jSONObject) throws Exception {
        String string;
        if (this.isPosLogFileRequest(jSONObject)) {
            MailService.doSendEmailPosLogFile(jSONObject.toString());
            return;
        }
        if (!this.isValidMqttSender(jSONObject)) {
            return;
        }
        BaseDataServiceDao baseDataServiceDao = BaseDataServiceDao.getInstance();
        String string2 = jSONObject.toString();
        switch (string = jSONObject.getString("request")) {
            case "Ticket Notification": {
                List<Ticket> list = baseDataServiceDao.saveOrUpdateTickets(string2, false);
                ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                if (list != null && list.size() > 0) {
                    for (Ticket ticket : list) {
                        Store store;
                        Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                        arrayList.add(ticket2);
                        if (ticket2.getTicketStatus() == TicketStatus.Confirmed) {
                            store = DataProvider.get().getStore();
                            if (store.isAutoSendOrdersToKitchen() && store.getSendOrderBeforeTime() == 0) {
                                SendToKitchenAction.doSendNewItemsToKitchen(ticket2, false);
                            }
                        } else if (ticket2.getTicketStatus() == TicketStatus.Preparing) {
                            SendToKitchenAction.doSendNewItemsToKitchen(ticket2, false);
                        } else if (ticket2.getTicketStatus() == TicketStatus.Ready) {
                            this.doBumpTicketFromKitchen(ticket2);
                        } else if (ticket2.getTicketStatus() == TicketStatus.Pending && (store = DataProvider.get().getStore()) != null && store.isAutomaticConfirmOrder()) {
                            ticket2.setTicketStatus(TicketStatus.Confirmed);
                            ticket2.setShouldUpdateStock(true);
                            ticket2.setShowNewOrderNotification(true);
                            TicketDAO.getInstance().saveOrUpdate(ticket2);
                            if (store.isAutoSendOrdersToKitchen() && store.getSendOrderBeforeTime() == 0) {
                                SendToKitchenAction.doSendNewItemsToKitchen(ticket2, false);
                            }
                        }
                        ActionHistoryDAO.saveHistory(ticket2, "Mqtt ticket save", "Ticket found via mqtt. Id: " + ticket2.getId());
                    }
                }
                this.fireTicketReceived(arrayList);
            }
        }
    }

    private void doBumpTicketFromKitchen(Ticket ticket) throws Exception {
        List<KitchenTicket> list = KitchenTicketDAO.getInstance().findByParentId(ticket.getId());
        if (list != null) {
            for (KitchenTicket kitchenTicket : list) {
                KitchenTicketUtill.bumpOrUnbumpKitchenTicket(kitchenTicket);
                OroMqttMessageReceiver.sendUpdateNotificationToKitchen();
            }
        }
    }

    private static void sendUpdateNotificationToKitchen() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("terminalKey", (Object)TerminalUtil.getSystemUID());
            jSONObject.put("command", (Object)"3");
            jSONObject.put("isKds", (Object)Boolean.FALSE);
            OroMqttClient.getInstance().publishData("MQTT-COMMAND-KIT-DIS-UPDATE", jSONObject.toString());
        }
        catch (Exception exception) {
            PosLog.error(OroMqttMessageReceiver.class, exception);
        }
    }

    private boolean isValidMqttSender(JSONObject jSONObject) {
        String string = OrgJsonUtil.getString(jSONObject, "source");
        return StringUtils.isNotBlank((String)string) && MqttSender.valueOf(string) == MqttSender.ONLINE_ORDER;
    }

    private boolean isPosLogFileRequest(JSONObject jSONObject) {
        return jSONObject.getString("request").equals("Log File Request");
    }

    private boolean isValidMessage(JSONObject jSONObject) {
        String string;
        String string2 = jSONObject.getString("deviceId");
        if (string2 != null && string2.equals(Application.getInstance().getMqttDeviceId())) {
            return false;
        }
        if (!jSONObject.has("request")) {
            this.debug("Empty request");
            return false;
        }
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal == null) {
            return false;
        }
        boolean bl = terminal.isMasterTerminal();
        if (!bl) {
            this.debug("Notification skipped. This is not master terminal.");
        }
        if (StringUtils.isEmpty((String)(string = Application.getInstance().getCurrentTerminalOutletId()))) {
            this.debug("Notification skipped. No outlet is defined for this terminal.");
            return false;
        }
        if (bl) {
            Integer n;
            Integer n2 = n = jSONObject.has("blockTerminalId") ? Integer.valueOf(jSONObject.getInt("blockTerminalId")) : null;
            if (n != null && n > 0 && terminal.getId() == n) {
                return false;
            }
        }
        return bl;
    }

    private void debug(String string) {
        PosLog.debug(OroMqttClient.class, string);
    }

    public void addDataListener(OroMqttDataListener oroMqttDataListener) {
        if (oroMqttDataListener != null && !this.dataListeners.contains(oroMqttDataListener)) {
            this.dataListeners.add(oroMqttDataListener);
        }
    }

    public void removeDataListener(OroMqttDataListener oroMqttDataListener) {
        AsyncAction.execute(() -> this.dataListeners.remove(oroMqttDataListener));
    }

    private void fireTicketReceived(List<Ticket> list) {
        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
            oroMqttDataListener.ticketReceived(list);
        }
    }

    public void fireConnectionLostEvent() {
        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
            oroMqttDataListener.mqttConnectionLost();
        }
    }

    public void fireMqttConnected() {
        for (OroMqttDataListener oroMqttDataListener : this.dataListeners) {
            oroMqttDataListener.mqttConnected();
        }
    }
}

