/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.DefaultCustomerListView;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.EmailSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;

public class ReceiptEmailSendAction
extends PosAction {
    private PosTransaction a;

    public ReceiptEmailSendAction(PosTransaction posTransaction) {
        super(Messages.getString("ReceiptEmailSendAction.0"));
        this.a = posTransaction;
    }

    @Override
    public void execute() {
        try {
            if (this.a == null) {
                return;
            }
            Customer customer = this.a(this.a.getTicket());
            if (customer == null) {
                throw new RuntimeException(Messages.getString("ReceiptEmailSendAction.5"));
            }
            String string = Messages.getString("ReceiptEmailSendAction.1");
            EmailSelectionDialog emailSelectionDialog = new EmailSelectionDialog(string, customer.getEmail(), customer.getEmail2()){

                @Override
                public boolean doSendEmail(String string) {
                    try {
                        MailService.sendTransaction(string, ReceiptEmailSendAction.this.a);
                        String string2 = String.format(Messages.getString("ReceiptEmailSendAction.2"), string);
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), string2);
                        return true;
                    }
                    catch (Exception exception) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                        return false;
                    }
                }
            };
            emailSelectionDialog.pack();
            emailSelectionDialog.open();
        }
        catch (RuntimeException runtimeException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), runtimeException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private Customer a(Ticket ticket) throws Exception {
        Customer customer = null;
        String string = ticket.getCustomerId();
        if (string == null) {
            String string2 = Messages.getString("ReceiptEmailSendAction.3");
            String string3 = Messages.getString("ReceiptEmailSendAction.4");
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string2, string3);
            if (n != 0) {
                return null;
            }
            CustomerSelectorDialog customerSelectorDialog = new CustomerSelectorDialog(new DefaultCustomerListView());
            customerSelectorDialog.setCreateNewTicket(false);
            customerSelectorDialog.updateView(true);
            customerSelectorDialog.openUndecoratedFullScreen();
            if (customerSelectorDialog.isCanceled()) {
                return null;
            }
            customer = customerSelectorDialog.getSelectedCustomer();
            if (customer != null) {
                ticket.setCustomer(customer);
                TicketDAO.getInstance().saveOrUpdate(ticket);
            }
        } else {
            customer = CustomerDAO.getInstance().get(string);
        }
        return customer;
    }
}

