/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.model.UserPermission;
import com.floreantpos.report.AttendanceReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class EmployeeAttendanceAction
extends PosAction {
    public EmployeeAttendanceAction() {
        super(Messages.getString("EmployeeAttendanceAction.0"));
        super.setRequiredPermission(UserPermission.EMPLOYEE_PRODUCTIVITY_AND_PAYROLL_REPORT);
        this.setMandatoryPermission(true);
    }

    public EmployeeAttendanceAction(String string) {
        super(string);
        super.setRequiredPermission(UserPermission.EMPLOYEE_PRODUCTIVITY_AND_PAYROLL_REPORT);
        this.setMandatoryPermission(true);
    }

    public EmployeeAttendanceAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void execute() throws Exception {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            AttendanceReportView attendanceReportView = null;
            int n = jTabbedPane.indexOfTab(Messages.getString("EmployeeAttendanceAction.1"));
            if (n == -1) {
                attendanceReportView = new AttendanceReportView();
                jTabbedPane.addTab(Messages.getString("EmployeeAttendanceAction.1"), attendanceReportView);
            } else {
                attendanceReportView = (AttendanceReportView)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(attendanceReportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

