/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.model.UserPermission;
import com.floreantpos.report.StaffBankReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class StaffBankReportAction
extends PosAction {
    public StaffBankReportAction() {
        super(Messages.getString("StaffBankReportAction.0"));
        super.setRequiredPermission(UserPermission.EMPLOYEE_PRODUCTIVITY_AND_PAYROLL_REPORT);
        this.setMandatoryPermission(true);
    }

    public StaffBankReportAction(String string) {
        super(string);
        super.setRequiredPermission(UserPermission.EMPLOYEE_PRODUCTIVITY_AND_PAYROLL_REPORT);
        this.setMandatoryPermission(true);
    }

    public StaffBankReportAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void execute() throws Exception {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            StaffBankReportView staffBankReportView = null;
            int n = jTabbedPane.indexOfTab(Messages.getString("StaffBankReportAction.0"));
            if (n == -1) {
                staffBankReportView = new StaffBankReportView();
                jTabbedPane.addTab(Messages.getString("StaffBankReportAction.0"), staffBankReportView);
            } else {
                staffBankReportView = (StaffBankReportView)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(staffBankReportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

