/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.UserExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class UserExplorerAction
extends AbstractAction {
    public UserExplorerAction() {
        super(POSConstants.USERS);
    }

    public UserExplorerAction(String string) {
        super(string);
    }

    public UserExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            UserExplorer userExplorer = null;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(POSConstants.USERS);
            if (n == -1) {
                userExplorer = new UserExplorer();
                jTabbedPane.addTab(POSConstants.USERS, userExplorer);
            } else {
                userExplorer = (UserExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(userExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

