/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.model.UserPermission;
import com.floreantpos.report.WeeklyPayrollReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class WeeklyPayrollReportAction
extends PosAction {
    public WeeklyPayrollReportAction() {
        super(Messages.getString("WeeklyPayrollReportAction.0"));
        super.setRequiredPermission(UserPermission.EMPLOYEE_PRODUCTIVITY_AND_PAYROLL_REPORT);
        this.setMandatoryPermission(true);
    }

    public WeeklyPayrollReportAction(String string) {
        super(string);
        super.setRequiredPermission(UserPermission.EMPLOYEE_PRODUCTIVITY_AND_PAYROLL_REPORT);
        this.setMandatoryPermission(true);
    }

    public WeeklyPayrollReportAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void execute() throws Exception {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            WeeklyPayrollReportView weeklyPayrollReportView = null;
            int n = jTabbedPane.indexOfTab(Messages.getString("WeeklyPayrollReportAction.0"));
            if (n == -1) {
                weeklyPayrollReportView = new WeeklyPayrollReportView();
                jTabbedPane.addTab(Messages.getString("WeeklyPayrollReportAction.0"), weeklyPayrollReportView);
            } else {
                weeklyPayrollReportView = (WeeklyPayrollReportView)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(weeklyPayrollReportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

