/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.Course;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.model.CourseForm;

public class CourseExplorer
extends BeanTableExplorerView<Course> {
    public CourseExplorer() {
        super(Course.class);
    }

    @Override
    public void initTableModel(BeanTableModel<Course> beanTableModel) {
        beanTableModel.addColumn(POSConstants.NAME, Course.PROP_NAME);
        beanTableModel.addColumn(Messages.getString("CourseExplorer.0"), Course.PROP_SHORT_NAME);
        beanTableModel.addColumn(POSConstants.SORT_ORDER, Course.PROP_SORT_ORDER, 2, BeanTableModel.DataType.NUMBER);
    }

    @Override
    public void initData() {
        this.setRows(CourseDAO.getInstance().findAll());
    }

    @Override
    public Course createNew() {
        CourseForm courseForm = new CourseForm();
        courseForm.setExistingCourses(this.getRows());
        return super.openNewForm(courseForm, 500, 450);
    }

    @Override
    public Course editSelectedRow(Course course) {
        CourseDAO.getInstance().refresh(course);
        this.checkDataValidation(course.isDeleted(), course.getName());
        CourseForm courseForm = new CourseForm(course);
        courseForm.setExistingCourses(this.getRows());
        return this.openEditForm(courseForm, 500, 450);
    }

    @Override
    public boolean delete(Course course) {
        CourseDAO.getInstance().refresh(course);
        this.checkDataValidation(course.isDeleted(), course.getName());
        CourseDAO.getInstance().delete(course);
        return true;
    }
}

