/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.DefaultPriceExplorerReport;
import com.floreantpos.bo.ui.explorer.MenuItemExplorer;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;

public class DefaultPriceExplorer
extends TransparentPanel {
    private MenuItemDefaultPriceTable a;
    private BeanTableModel<MenuItem> b;
    private JButton c;
    private JButton d;
    private JLabel e;
    private JTextField f;
    private JComboBox<Object> g;
    private JComboBox h;
    private JComboBox<Object> i;
    private boolean j;
    private JCheckBox k = new JCheckBox(Messages.getString("DefaultPriceExplorer.0"));

    public DefaultPriceExplorer() {
        this.initcomponents();
        this.c();
    }

    public void initcomponents() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill", "", ""));
        this.b = new BeanTableModel(MenuItem.class, 50);
        this.b.addColumn(Messages.getString("DefaultPriceExplorer.5"), "displayName");
        this.b.addColumn(Messages.getString("DefaultPriceExplorer.7"), "barcode");
        this.b.addColumn(Messages.getString("DefaultPriceExplorer.9") + " (" + CurrencyUtil.getCurrencySymbol() + ")", "variantCost", 11, BeanTableModel.DataType.MONEY);
        this.b.addColumn(Messages.getString("DefaultPriceExplorer.13") + " (" + CurrencyUtil.getCurrencySymbol() + ")", "variantPrice", BeanTableModel.EditMode.EDITABLE, 11, BeanTableModel.DataType.MONEY);
        this.b.addColumn(Messages.getString("DefaultPriceExplorer.43"), "profitMargin");
        this.a = new MenuItemDefaultPriceTable(this.b);
        this.a.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.a.setSelectionMode(0);
        this.a.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        DoubleTextField doubleTextField = new DoubleTextField();
        doubleTextField.setHorizontalAlignment(4);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(doubleTextField);
        defaultCellEditor.setClickCountToStart(1);
        this.a.setDefaultEditor(this.a.getColumnClass(3), defaultCellEditor);
        this.a.setRowHeight(PosUIManager.getSize(30));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.a));
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel3.add((Component)jScrollPane, "grow");
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fillx", "[fill]", ""));
        int n = PosUIManager.getSize(16);
        JButton jButton = new JButton(Messages.getString("DefaultPriceExplorer.2"));
        jButton.addActionListener(actionEvent -> this.a());
        this.c = new JButton();
        this.c.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)n));
        this.c.addActionListener(actionEvent -> this.d());
        this.d = new JButton();
        this.d.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)n));
        this.d.addActionListener(actionEvent -> this.e());
        this.e = new JLabel();
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new MigLayout("fill", "[][grow]", ""));
        jPanel5.add((Component)jButton, "split 1");
        jPanel5.add((Component)this.e, "split 3,right");
        jPanel5.add(this.c);
        jPanel5.add(this.d);
        jPanel4.add((Component)jPanel5, "grow");
        jPanel2.add((Component)this.b(), "grow");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.add((Component)jPanel, "grow");
    }

    private void a() {
        new DefaultPriceExplorerReport(this.b.getRows());
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("fill", "[][grow]", ""));
        JLabel jLabel = new JLabel(Messages.getString("MenuItemExplorer.0"));
        JLabel jLabel2 = new JLabel(Messages.getString("MenuItemExplorer.1"));
        this.g = new JComboBox();
        this.g.addItem(Messages.getString("MenuItemExplorer.5"));
        JLabel jLabel3 = new JLabel(Messages.getString("DefaultPriceExplorer.1"));
        this.h = new JComboBox<MenuItemExplorer.MenuItemType>(MenuItemExplorer.MenuItemType.values());
        List<MenuGroup> list = MenuGroupDAO.getInstance().findAll();
        for (MenuGroup serializable : list) {
            this.g.addItem(serializable);
        }
        this.f = new JTextField(15);
        try {
            JButton jButton = new JButton(Messages.getString("Search"));
            JButton jButton2 = new JButton(Messages.getString("DefaultPriceExplorer.35"));
            jPanel.add((Component)jLabel, "split 8");
            jPanel.add(this.f);
            jPanel.add((Component)jLabel2, "");
            jPanel.add(this.g);
            jPanel.add(jLabel3);
            jPanel.add(this.h);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add((Component)new JLabel(Messages.getString("DefaultPriceExplorer.37")), "split 5,right");
            jPanel.add(new JLabel(Messages.getString("DefaultPriceExplorer.39")));
            jPanel.add(this.k);
            jPanel.add(new JLabel(Messages.getString("DefaultPriceExplorer.40")));
            this.i = new JComboBox();
            this.i.addItem(null);
            this.i.addItem(MenuItem.PROP_NAME);
            this.i.addItem(MenuItem.PROP_BARCODE);
            this.i.addItem(MenuItem.PROP_COST);
            this.i.addItem(MenuItem.PROP_PRICE);
            this.i.setSelectedItem(null);
            this.i.addItemListener(itemEvent -> this.c());
            jPanel.add(this.i);
            this.k.addActionListener(actionEvent -> this.c());
            this.k.setSelected(true);
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("Search"));
            titledBorder.setTitleJustification(1);
            jPanel.setBorder(titledBorder);
            jButton.addActionListener(actionEvent -> this.c());
            this.f.addActionListener(actionEvent -> this.c());
            jButton2.addActionListener(actionEvent -> this.f());
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return jPanel;
    }

    private void c() {
        this.a(0);
    }

    private void a(Integer n) {
        String string = this.f.getText();
        MenuGroup menuGroup = null;
        Boolean bl = false;
        Boolean bl2 = false;
        Object object = this.g.getSelectedItem();
        Object object2 = this.h.getSelectedItem();
        if (object instanceof MenuGroup) {
            menuGroup = (MenuGroup)object;
        }
        if (object2 == MenuItemExplorer.MenuItemType.Combo) {
            bl = true;
        }
        if (object2 == MenuItemExplorer.MenuItemType.Variant) {
            bl2 = true;
        }
        try {
            Object object3 = this.i.getSelectedItem();
            this.b.setSortBy((String)object3, this.k.isSelected());
            if (n != null) {
                this.b.setCurrentRowIndex(n);
            }
            MenuItemDAO.getInstance().loadDefaultPriceMenuItems(this.b, true, menuGroup, string, Boolean.FALSE, bl2, bl);
            int n2 = this.b.getCurrentRowIndex() + 1;
            int n3 = this.b.getNextRowIndex();
            int n4 = this.b.getNumRows();
            if (n3 > n4) {
                n3 = n4;
            }
            this.e.setText(String.format(Messages.getString("DefaultPriceExplorer.42"), n2, n3, n4));
            this.c.setEnabled(this.b.hasPrevious());
            this.d.setEnabled(this.b.hasNext());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void d() {
        if (this.j && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DefaultPriceExplorer.24"), Messages.getString("DefaultPriceExplorer.25")) == 0) {
            try {
                MenuItemDAO.getInstance().saveAll(this.b.getRows());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
            }
        }
        this.j = false;
        this.a(this.b.getPreviousRowIndex());
    }

    private void e() {
        if (this.j && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("DefaultPriceExplorer.27"), Messages.getString("DefaultPriceExplorer.28")) == 0) {
            try {
                MenuItemDAO.getInstance().saveAll(this.b.getRows());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
            }
        }
        this.j = false;
        this.a(this.b.getNextRowIndex());
    }

    private void f() {
        this.f.setText("");
        this.g.setSelectedIndex(0);
        this.h.setSelectedIndex(0);
        this.c();
    }

    private class MenuItemDefaultPriceTable
    extends PosTable {
        public MenuItemDefaultPriceTable(BeanTableModel<MenuItem> beanTableModel) {
            super(beanTableModel);
            this.setSortable(false);
        }

        public void setValueAt(Object object, int n, int n2) {
            try {
                String string = (String)object;
                if (string.isEmpty()) {
                    return;
                }
                Double d = NumberUtil.parseOrGetZero(string).doubleValue();
                if (d < 0.0) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuItemForm.12"));
                    return;
                }
                MenuItem menuItem = (MenuItem)DefaultPriceExplorer.this.b.getRow(n);
                MenuItem menuItem2 = MenuItemDAO.getInstance().get(menuItem.getId());
                if (n2 == 3) {
                    MenuItem menuItem3;
                    double d2 = 0.0;
                    if (menuItem2.isVariant().booleanValue() && (menuItem3 = menuItem2.getParentMenuItem()) != null) {
                        d2 = menuItem3.getPrice();
                    }
                    menuItem2.setPrice(d - d2);
                    MenuItemDAO.getInstance().saveOrUpdate(menuItem2);
                    menuItem.setPrice(d - d2);
                }
                super.setValueAt((Object)d, n, n2);
            }
            catch (Exception exception) {
                POSMessageDialog.showError(exception.getMessage());
            }
        }
    }
}

