/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.bo.ui.explorer.DepartmentEntryForm;
import com.floreantpos.model.Department;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.swing.BeanTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class DepartmentExplorer
extends BeanTableExplorerView<Department> {
    public DepartmentExplorer() {
        super(Department.class);
    }

    @Override
    public void initTableModel(BeanTableModel<Department> beanTableModel) {
        beanTableModel.addColumn(Messages.getString("DepartmentExplorer.0"), Department.PROP_ID);
        beanTableModel.addColumn(Messages.getString("DepartmentExplorer.2"), Department.PROP_NAME);
        beanTableModel.addColumn(Messages.getString("DepartmentExplorer.4"), Department.PROP_DESCRIPTION);
        beanTableModel.addColumn(Messages.getString("DepartmentExplorer.6"), Department.PROP_ADDRESS);
    }

    @Override
    public void initData() {
        this.setRows(DepartmentDAO.getInstance().findAll());
    }

    @Override
    public Department createNew() {
        return this.openNewForm(new DepartmentEntryForm(new Department()), 500, 450);
    }

    @Override
    public Department editSelectedRow(Department department) {
        department = DepartmentDAO.getInstance().initialize(department);
        this.checkDataValidation(department.isDeleted(), department.getName());
        return this.openEditForm(new DepartmentEntryForm(department), 500, 450);
    }

    @Override
    public boolean delete(Department department) {
        DepartmentDAO.getInstance().refresh(department);
        this.checkDataValidation(department.isDeleted(), department.getName());
        DepartmentDAO.getInstance().delete(department);
        return true;
    }

    @Override
    public DefaultTableCellRenderer geTableCellRenderer() {
        return new CustomCellRenderer();
    }
}

