/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import javax.swing.tree.TreePath;
import org.hibernate.StaleStateException;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.tree.TreeModelSupport;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

class MenuItemTreeTableModel
extends DefaultTreeTableModel
implements PaginationSupport {
    private int a;
    private int b;
    private int c = 20;
    private List<?> d;
    private JXTreeTable e;
    private final String[] f = new String[]{POSConstants.NAME, POSConstants.TRANSLATED_NAME, Messages.getString("MenuItemExplorer.12"), Messages.getString("MenuItemExplorer.15"), Messages.getString("MenuItemExplorer.27"), POSConstants.COST, POSConstants.PRICE + " (" + CurrencyUtil.getCurrencySymbol() + ")", Messages.getString("MenuItemExplorer.14"), Messages.getString("MenuItemExplorer.26"), POSConstants.ACTIVE, Messages.getString("MenuItemExplorer.29"), Messages.getString("MenuItemExplorer.21"), Messages.getString("MenuItemExplorer.23"), Messages.getString("MenuItemExplorer.25"), POSConstants.IMAGE};

    public MenuItemTreeTableModel(DefaultMutableTreeTableNode defaultMutableTreeTableNode, JXTreeTable jXTreeTable) {
        super((TreeTableNode)defaultMutableTreeTableNode);
        this.e = jXTreeTable;
    }

    public Object getValueAt(Object object, int n) {
        if (object instanceof DefaultMutableTreeTableNode) {
            MenuItem menuItem = (MenuItem)((DefaultMutableTreeTableNode)object).getUserObject();
            if (menuItem == null) {
                return "";
            }
            switch (n) {
                case 0: {
                    return menuItem.getName();
                }
                case 1: {
                    return menuItem.getTranslatedName();
                }
                case 2: {
                    return menuItem.getBarcode();
                }
                case 3: {
                    return menuItem.getComboItem();
                }
                case 4: {
                    return menuItem.getHasModifiers();
                }
                case 5: {
                    return menuItem.getCost();
                }
                case 6: {
                    Double d = menuItem.getPrice();
                    if (menuItem.isVariant().booleanValue()) {
                        d = menuItem.getParentMenuItem().getPrice() + menuItem.getPrice();
                    }
                    return d;
                }
                case 7: {
                    if (menuItem.isHasVariant().booleanValue()) {
                        return null;
                    }
                    return menuItem.getAvailableUnit();
                }
                case 8: {
                    if (menuItem.isHasVariant().booleanValue()) {
                        return null;
                    }
                    return menuItem.getUnitOnHand();
                }
                case 9: {
                    return menuItem.isVisible();
                }
                case 10: {
                    TaxGroup taxGroup = menuItem.getTaxGroup();
                    if (menuItem.isVariant().booleanValue() && taxGroup == null) {
                        return menuItem.getParentMenuItem().getTaxGroup();
                    }
                    return taxGroup;
                }
                case 11: {
                    return menuItem.getSortOrder();
                }
                case 12: {
                    return menuItem.getButtonColor();
                }
                case 13: {
                    return menuItem.getTextColor();
                }
                case 14: {
                    return menuItem.getImage();
                }
            }
        }
        return null;
    }

    public TreeModelSupport getModelSupport() {
        return this.modelSupport;
    }

    public int getColumnCount() {
        return this.f.length;
    }

    public String getColumnName(int n) {
        return this.f[n];
    }

    public boolean isCellEditable(Object object, int n) {
        DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)object;
        MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
        return menuItem.isVariant() == false && (n == 11 || n == 6);
    }

    @Override
    public int getNumRows() {
        return this.a;
    }

    @Override
    public void setNumRows(int n) {
        this.a = n;
    }

    @Override
    public int getCurrentRowIndex() {
        return this.b;
    }

    @Override
    public void setCurrentRowIndex(int n) {
        this.b = n;
    }

    @Override
    public int getPageSize() {
        return this.c;
    }

    @Override
    public void setPageSize(int n) {
        this.c = n;
    }

    @Override
    public boolean hasNext() {
        return this.b + this.c < this.a;
    }

    @Override
    public boolean hasPrevious() {
        return this.b > 0;
    }

    @Override
    public int getNextRowIndex() {
        if (this.a == 0) {
            return 0;
        }
        return this.getCurrentRowIndex() + this.getPageSize();
    }

    @Override
    public int getPreviousRowIndex() {
        int n = this.getCurrentRowIndex() - this.getPageSize();
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    @Override
    public void setRows(List list) {
        this.d = list;
    }

    public List getRows() {
        return this.d;
    }

    public void setValueAt(Object object, Object object2, int n) {
        if (n == 11 || n == 6 || object2 instanceof DefaultMutableTreeTableNode) {
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)object2;
            if (!(defaultMutableTreeTableNode.getUserObject() instanceof MenuItem)) {
                super.setValueAt(object, object2, n);
                return;
            }
            MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
            try {
                Integer n2 = 0;
                double d = 0.0;
                if (n == 11) {
                    n2 = POSUtil.parseInteger(object.toString());
                    Integer n3 = menuItem.getSortOrder();
                    if (n3 == n2) {
                        return;
                    }
                    menuItem.setSortOrder(n2);
                } else if (n == 6) {
                    d = POSUtil.parseDouble(object.toString());
                    double d2 = menuItem.getPrice();
                    if (d2 == d) {
                        return;
                    }
                    menuItem.setPrice(d);
                }
                MenuItemDAO.getInstance().saveOrUpdate(menuItem);
                super.setValueAt((Object)n2, object2, n);
                if (menuItem.isHasVariant().booleanValue()) {
                    this.a(defaultMutableTreeTableNode);
                }
            }
            catch (PosException posException) {
                BOMessageDialog.showError(posException.getMessage());
            }
            catch (StaleStateException staleStateException) {
                POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), new RefreshableView(){

                    @Override
                    public void refresh() {
                        MenuItemTreeTableModel.this.doRefresh();
                    }
                });
            }
            catch (Throwable throwable) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), throwable.getMessage(), throwable);
            }
        } else {
            super.setValueAt(object, object2, n);
        }
    }

    public void doRefresh() {
        int n = this.e.getSelectedRow();
        if (n < 0) {
            return;
        }
        TreePath treePath = this.e.getPathForRow(n);
        DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
        MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
        menuItem = MenuItemDAO.getInstance().getInitialized(menuItem.getId());
        this.valueForPathChanged(treePath, menuItem);
        if (menuItem.isHasVariant().booleanValue()) {
            this.a(defaultMutableTreeTableNode);
        }
    }

    private void a(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
        int n = this.getChildCount(defaultMutableTreeTableNode);
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeTableNode defaultMutableTreeTableNode2 = (DefaultMutableTreeTableNode)defaultMutableTreeTableNode.getChildAt(i);
            MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode2.getUserObject();
            menuItem = MenuItemDAO.getInstance().getInitialized(menuItem.getId());
            this.setUserObject((TreeTableNode)defaultMutableTreeTableNode2, menuItem);
        }
    }
}

