/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer.attribute;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.explorer.attribute.QuickAttributeLayout;
import com.floreantpos.bo.ui.explorer.attribute.QuickGroupLayout;
import com.floreantpos.bo.ui.explorer.attribute.VariantComboCheckUtil;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.AttributeGroupDAO;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.actions.AttributeGroupsSelectionListener;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class AttributesGroupSelectionDialog
extends OkCancelOptionDialog {
    private List<Attribute> a;
    private MenuItem b;
    private boolean c;
    private JPanel d;
    private JButton e;
    private boolean f = true;
    private AttributeGroupsSelectionListener g;

    public AttributesGroupSelectionDialog(List<Attribute> list, MenuItem menuItem) {
        this(list, menuItem, (boolean)Boolean.FALSE);
    }

    public AttributesGroupSelectionDialog(List<Attribute> list, MenuItem menuItem, boolean bl) {
        this.a = list;
        this.b = menuItem;
        this.c = bl;
        this.setCaption(Messages.getString("AttributesGroupSelectionDialog.0"));
        this.a();
    }

    private void a() {
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("fillx,inset 0,hidemode 3", "[][grow]", ""));
        this.d = new TransparentPanel();
        this.d.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3,wrap 4,ins 5 0", "[][]"));
        this.e = new JButton(Messages.getString("AttributesGroupSelectionDialog.1"));
        this.e.setVisible(!this.c);
        jPanel.add(this.d);
        jPanel.add((Component)this.e, "newline,gapleft 10!");
        this.e.addActionListener(actionEvent -> this.c());
        this.updatePanel();
    }

    protected void updatePanel() {
        boolean bl;
        if (this.a == null || this.a.isEmpty()) {
            this.a(this.b(), null, false, this.b);
            return;
        }
        HashMap<AttributeGroup, Object> hashMap = new HashMap<AttributeGroup, Object>();
        for (Attribute attribute : this.a) {
            AttributeGroup attributeGroup = attribute.getGroup();
            ArrayList<Attribute> arrayList = (ArrayList<Attribute>)hashMap.get(attributeGroup);
            if (arrayList == null) {
                arrayList = new ArrayList<Attribute>();
            }
            arrayList.add(attribute);
            hashMap.put(attributeGroup, arrayList);
        }
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        if (arrayList != null) {
            Collections.sort(arrayList, new Comparator<AttributeGroup>(){

                @Override
                public int compare(AttributeGroup attributeGroup, AttributeGroup attributeGroup2) {
                    return attributeGroup.getSortOrder().compareTo(attributeGroup2.getSortOrder());
                }
            });
        }
        boolean bl2 = bl = arrayList == null || arrayList.isEmpty();
        if (bl) {
            this.a(this.b());
            return;
        }
        boolean bl3 = true;
        for (AttributeGroup attributeGroup : arrayList) {
            if (bl3) {
                this.a(attributeGroup, (List)hashMap.get(attributeGroup), false, this.b);
                bl3 = false;
                bl = StringUtils.isBlank((CharSequence)attributeGroup.getId());
                continue;
            }
            this.a(attributeGroup, (List)hashMap.get(attributeGroup), true, this.b);
        }
    }

    private AttributeGroup b() {
        AttributeGroupDAO attributeGroupDAO;
        AttributeGroup attributeGroup = new AttributeGroup();
        if (this.c && (attributeGroup = (attributeGroupDAO = AttributeGroupDAO.getInstance()).get("membership_type")) == null) {
            attributeGroup = new AttributeGroup("membership_type");
            attributeGroup.setName(Messages.getString("CustomerForm.37"));
            attributeGroupDAO.save(attributeGroup);
        }
        return attributeGroup;
    }

    @Override
    public void doOk() {
        if (this.doCheckValidation()) {
            return;
        }
        this.saveAttributeGroup();
        this.setCanceled(false);
        this.dispose();
    }

    protected void saveAttributeGroup() {
        ArrayList<AttributeGroup> arrayList = new ArrayList<AttributeGroup>();
        for (int i = 0; i < this.d.getComponentCount(); ++i) {
            Component component = this.d.getComponent(i);
            if (!(component instanceof QuickGroupLayout)) continue;
            QuickGroupLayout quickGroupLayout = (QuickGroupLayout)component;
            AttributeGroup attributeGroup = quickGroupLayout.getAttributeGroup();
            attributeGroup.setSortOrder(i + 1);
            int n = 1;
            List<Attribute> list = attributeGroup.getAttributes();
            if (list != null) {
                for (Attribute attribute : list) {
                    attribute.setSortOrder(n++);
                }
            }
            ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>(list);
            if (quickGroupLayout.b != null && !quickGroupLayout.b.isEmpty()) {
                arrayList2.addAll(quickGroupLayout.b);
            }
            attributeGroup.setAttributes((List<Attribute>)arrayList2);
            arrayList.add(attributeGroup);
        }
        if (this.g != null) {
            this.g.itemSelected(arrayList);
        }
    }

    private void c() {
        try {
            VariantComboCheckUtil.checkVariantIsUsedByCombo(this.b, this.a, true);
            AttributeGroup attributeGroup = this.b();
            QuickGroupLayout quickGroupLayout = new QuickGroupLayout(attributeGroup, new ArrayList<Attribute>(), true, this.b);
            this.d.add((Component)quickGroupLayout, "wrap");
            this.d();
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage());
        }
    }

    private void d() {
        this.revalidate();
        this.repaint();
    }

    private void a(AttributeGroup attributeGroup) {
        this.a(attributeGroup, null);
    }

    private void a(AttributeGroup attributeGroup, List<Attribute> list) {
        this.a(attributeGroup, list, true);
    }

    private void a(AttributeGroup attributeGroup, List<Attribute> list, boolean bl) {
        this.a(attributeGroup, list, bl, null);
    }

    private void a(AttributeGroup attributeGroup, List<Attribute> list, boolean bl, MenuItem menuItem) {
        QuickGroupLayout quickGroupLayout = new QuickGroupLayout(attributeGroup, list, bl, menuItem);
        this.d.add((Component)quickGroupLayout, "wrap");
    }

    public boolean isSaveImmediately() {
        return this.f;
    }

    public void setSaveImmediately(boolean bl) {
        this.f = bl;
    }

    protected boolean doCheckValidation() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (int i = 0; i < this.d.getComponentCount(); ++i) {
            Component component = this.d.getComponent(i);
            if (!(component instanceof QuickGroupLayout)) continue;
            QuickGroupLayout quickGroupLayout = (QuickGroupLayout)component;
            AttributeGroup attributeGroup = quickGroupLayout.getAttributeGroup();
            String string = attributeGroup.getName();
            if (StringUtils.isBlank((CharSequence)string)) {
                POSMessageDialog.showError(Messages.getString("AttributesGroupSelectionDialog.2"));
                quickGroupLayout.getTfAttributeGroupName().selectAll();
                quickGroupLayout.getTfAttributeGroupName().requestFocus();
                return true;
            }
            List<QuickAttributeLayout> list = quickGroupLayout.getQuickAttributeLayoutList();
            if (list.size() == 1) {
                QuickAttributeLayout quickAttributeLayout = list.get(0);
                if (quickAttributeLayout == null || StringUtils.isBlank((CharSequence)quickAttributeLayout.getAttribute().getName())) {
                    POSMessageDialog.showError(Messages.getString("AttributesGroupSelectionDialog.3"));
                    quickAttributeLayout.getTfAttributeName().requestFocus();
                    return true;
                }
            } else {
                boolean bl = false;
                for (QuickAttributeLayout quickAttributeLayout : list) {
                    if (quickAttributeLayout == null || !StringUtils.isNotBlank((CharSequence)quickAttributeLayout.getAttribute().getName())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    POSMessageDialog.showError(Messages.getString("AttributesGroupSelectionDialog.3"));
                    QuickAttributeLayout quickAttributeLayout = list.get(0);
                    quickAttributeLayout.getTfAttributeName().requestFocus();
                    return true;
                }
            }
            QuickAttributeLayout.renderAttributeUi(list);
            arrayList.addAll(attributeGroup.getAttributes());
        }
        this.validateAttributeGroup();
        this.validateAttribute(arrayList);
        return false;
    }

    protected void validateAttribute(List<Attribute> list) {
        if (list.size() == 1) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Attribute attribute = list.get(i);
            for (int j = 0; j < list.size(); ++j) {
                Attribute attribute2 = list.get(j);
                if (i == j || !StringUtils.isNotBlank((CharSequence)attribute2.getName()) || !attribute.getName().equals(attribute2.getName())) continue;
                throw new PosException(attribute2.getName() + Messages.getString("AttributesGroupSelectionDialog.5"));
            }
        }
    }

    protected void validateAttributeGroup() {
        int n = this.d.getComponentCount();
        if (n == 1) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Component component = this.d.getComponent(i);
            if (!(component instanceof QuickGroupLayout)) continue;
            QuickGroupLayout quickGroupLayout = (QuickGroupLayout)component;
            for (int j = 0; j < n; ++j) {
                Component component2 = this.d.getComponent(j);
                if (!(component2 instanceof QuickGroupLayout)) continue;
                QuickGroupLayout quickGroupLayout2 = (QuickGroupLayout)component2;
                if (i == j) continue;
                AttributeGroup attributeGroup = quickGroupLayout.getAttributeGroup();
                if (attributeGroup.getName().equals(quickGroupLayout2.getAttributeGroup().getName())) {
                    quickGroupLayout2.updateValidation(attributeGroup.getName() + Messages.getString("AttributesGroupSelectionDialog.6"));
                    throw new PosException(attributeGroup.getName() + Messages.getString("AttributesGroupSelectionDialog.6"));
                }
                quickGroupLayout2.updateValidation("");
            }
        }
    }

    public void addItemSelectionListener(AttributeGroupsSelectionListener attributeGroupsSelectionListener) {
        this.g = attributeGroupsSelectionListener;
    }
}

