/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.SystemProperties;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class LabelConfigurationView
extends TransparentPanel
implements RefreshableView {
    private Store a;
    private JCheckBox b;
    private JCheckBox c;
    private JCheckBox d;
    private JCheckBox e;
    private PosButton f;

    public LabelConfigurationView() {
        this.b();
        this.updateView();
        this.a();
    }

    private void a() {
        this.f.addActionListener(actionEvent -> this.save());
    }

    private void b() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[][grow][]", ""));
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 31);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, Messages.getString("LabelConfigurationView.3"), 2, 0);
        jPanel.setBorder(titledBorder);
        this.b = new JCheckBox(Messages.getString("LabelConfigurationView.4"));
        this.c = new JCheckBox(Messages.getString("LabelConfigurationView.5"));
        this.d = new JCheckBox(Messages.getString("LabelConfigurationView.6"));
        this.e = new JCheckBox("Print translated name");
        jPanel.add((Component)this.b, "wrap");
        jPanel.add((Component)this.c, "wrap");
        if (SystemProperties.isForeTees()) {
            jPanel.add((Component)this.d, "wrap");
        }
        jPanel.add((Component)this.e, "wrap");
        jScrollPane.setBorder(null);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("center"));
        this.f = new PosButton(Messages.getString("LabelConfigurationView.14"));
        jPanel2.add(this.f);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "South");
    }

    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            StoreDAO.getInstance().saveOrUpdate(this.a);
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("LabelConfigurationView.15"));
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
        return false;
    }

    public void updateView() {
        try {
            this.a = DataProvider.get().getStore();
            StoreDAO.getInstance().refresh(this.a);
            this.b.setSelected(POSUtil.getBoolean(this.a.getProperty("label.barcode")));
            this.c.setSelected(POSUtil.getBoolean(this.a.getProperty("label.member.price")));
            this.d.setSelected(POSUtil.getBoolean(this.a.getProperty("label.isPrint.retail.price")));
            this.e.setSelected(POSUtil.getBoolean(this.a.getProperty("label.print_translated_name")));
        }
        catch (Exception exception) {
            PosLog.error(LabelConfigurationView.class, exception);
        }
    }

    public boolean updateModel() {
        try {
            this.a.addProperty("label.barcode", String.valueOf(this.b.isSelected()));
            this.a.addProperty("label.member.price", String.valueOf(this.c.isSelected()));
            this.a.addProperty("label.isPrint.retail.price", String.valueOf(this.d.isSelected()));
            this.a.addProperty("label.print_translated_name", String.valueOf(this.e.isSelected()));
        }
        catch (Exception exception) {
            PosLog.error(LabelConfigurationView.class, exception.getMessage(), exception);
        }
        return true;
    }

    @Override
    public String getName() {
        return Messages.getString("LabelConfigurationView.16");
    }

    @Override
    public void refresh() {
        this.updateView();
    }
}

