/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer;

import com.floreantpos.ITicketList;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.base.BaseTicket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.CustomerTicketListView;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TicketListUpdateListener;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.VoidTicketDialog;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.order.DefaultOrderServiceExtension;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class CustomerHistoryDialog
extends POSDialog
implements ITicketList,
TicketListUpdateListener,
ActionListener {
    private OrderServiceExtension a;
    private PosButton b = new PosButton(POSConstants.ORDER_INFO_BUTTON_TEXT);
    private CustomerTicketListView c;
    private TitledBorder d;
    private String e;
    private boolean f;
    private boolean g = Boolean.TRUE;

    public CustomerHistoryDialog(String string) {
        this(string, (boolean)Boolean.TRUE);
    }

    public CustomerHistoryDialog(String string, boolean bl) {
        this.setTitle(VersionInfo.getAppName());
        this.setLayout(new BorderLayout());
        this.e = string;
        this.c = new CustomerTicketListView(string);
        this.a();
        this.g = bl;
        this.b.addActionListener(this);
        this.a = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
        if (this.a == null) {
            this.a = new DefaultOrderServiceExtension();
        }
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.updateTicketList();
    }

    private void a() {
        this.setLayout(new BorderLayout(10, 10));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("CustomerHistoryDialog.0"));
        this.add((Component)titlePanel, "North");
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        this.d = BorderFactory.createTitledBorder(null, "Tickets", 2, 0);
        JPanel jPanel3 = this.b();
        jPanel2.setBorder(new CompoundBorder(this.d, new EmptyBorder(2, 2, 2, 2)));
        jPanel2.add((Component)this.c, "Center");
        jPanel2.add((Component)jPanel3, "South");
        jPanel.add((Component)jPanel2, "Center");
        this.add((Component)jPanel, "Center");
    }

    private JPanel b() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        PosButton posButton = new PosButton(POSConstants.CANCEL);
        posButton.setPreferredSize(new Dimension(60, 40));
        posButton.addActionListener(actionEvent -> this.a(false));
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("fillx"));
        transparentPanel.add((Component)this.b, "center,split 2");
        transparentPanel.add(posButton);
        jPanel.add((Component)transparentPanel, "Center");
        return jPanel;
    }

    protected void doCloseOrder() {
        Ticket ticket = this.getFirstSelectedTicket();
        if (ticket == null) {
            return;
        }
        ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        int n = (int)POSUtil.getDouble(ticket.getDueAmount());
        if (n != 0) {
            POSMessageDialog.showError(this, Messages.getString("CustomerHistoryDialog.2"));
            return;
        }
        int n2 = JOptionPane.showOptionDialog(Application.getPosWindow(), "Ticket#" + ticket.getId() + "  will be closed.", POSConstants.CONFIRM, 2, 1, null, null, null);
        if (n2 != 0) {
            return;
        }
        OrderController.closeOrder(ticket);
    }

    private void c() {
        this.a(this.c.getSelectedTickets());
    }

    private void a(List<Ticket> list) {
        try {
            Serializable serializable;
            if (list == null || list.size() == 0) {
                POSMessageDialog.showMessage(Messages.getString("CustomerHistoryDialog.3"));
                return;
            }
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            for (int i = 0; i < list.size(); ++i) {
                serializable = list.get(i);
                arrayList.add(TicketDAO.getInstance().loadFullTicket(((BaseTicket)serializable).getId()));
            }
            OrderInfoView orderInfoView = new OrderInfoView(arrayList);
            serializable = new OrderInfoDialog(orderInfoView);
            ((OrderInfoDialog)serializable).showReorderButton(this.g);
            ((Window)serializable).setSize(400, 600);
            ((JDialog)serializable).setDefaultCloseOperation(2);
            ((Window)serializable).setLocationRelativeTo(Application.getPosWindow());
            ((Dialog)serializable).setVisible(true);
            this.f = ((OrderInfoDialog)serializable).isReorder();
            if (this.f) {
                this.a(true);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void doHomeDelivery(OrderType orderType) {
    }

    public void doVoidTicket() {
        Ticket ticket = this.c.getSelectedTicket();
        if (ticket == null) {
            POSMessageDialog.showMessage(POSConstants.SELECT_ONE_TICKET_TO_VOID);
            return;
        }
        Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        VoidTicketDialog voidTicketDialog = new VoidTicketDialog();
        voidTicketDialog.setTicket(ticket2);
        voidTicketDialog.pack();
        voidTicketDialog.open();
        if (!voidTicketDialog.isCanceled()) {
            // empty if block
        }
    }

    public void updateView() {
    }

    private void a(boolean bl) {
        this.setCanceled(bl);
        this.dispose();
        if (bl) {
            // empty if block
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.updateView();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.b) {
            this.c();
        }
    }

    public Ticket getFirstSelectedTicket() {
        List<Ticket> list = this.c.getSelectedTickets();
        if (list == null || list.size() == 0 || list.size() > 1) {
            POSMessageDialog.showMessage(this, Messages.getString("CustomerHistoryDialog.4"));
            return null;
        }
        Ticket ticket = list.get(0);
        return ticket;
    }

    @Override
    public Ticket getSelectedTicket() {
        List<Ticket> list = this.c.getSelectedTickets();
        if (list.size() == 0 || list.size() > 1) {
            return null;
        }
        Ticket ticket = list.get(0);
        return ticket;
    }

    @Override
    public void ticketListUpdated() {
        String string = POSConstants.OPEN_TICKETS_AND_ACTIVITY;
        this.d.setTitle(string);
    }

    public String getMemberId() {
        return this.e;
    }

    @Override
    public void updateTicketList() {
        this.c.updateTicketList();
    }

    public boolean isTicketReordered() {
        return this.f;
    }
}

