/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.db.update;

import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.util.DatabaseUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projections;
import org.hibernate.jdbc.Work;

public class UpdateDBTo171 {
    public UpdateDBTo171(SessionFactory sessionFactory) {
        sessionFactory.openSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = DatabaseUtil.getActualTableName(databaseMetaData, "TRANSACTIONS");
                String string2 = DatabaseUtil.getActualColumnName(databaseMetaData, string, "class_type");
                String string3 = "update %s set %s=? where %s=?";
                string3 = String.format(string3, string, string2, string2);
                PreparedStatement preparedStatement = connection.prepareStatement(string3);
                preparedStatement.setString(1, "CUSTOMER_ACCOUNT");
                preparedStatement.setString(2, "MEMBER_ACCOUNT");
                preparedStatement.execute();
                connection.commit();
            }
        });
    }

    public void updateTickets() throws Exception {
        Transaction transaction = null;
        try (Session session = null;){
            TicketDAO ticketDAO = TicketDAO.getInstance();
            session = ticketDAO.createNewSession();
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.setProjection(Projections.rowCount());
            Object object = criteria.uniqueResult();
            int n = 0;
            if (object != null) {
                n = ((Number)object).intValue();
            }
            int n2 = 0;
            int n3 = 10;
            while (n2 < n) {
                Criteria criteria2 = session.createCriteria(Ticket.class);
                criteria2.addOrder(ticketDAO.getDefaultOrder());
                criteria2.setFirstResult(n2);
                criteria2.setMaxResults(n3);
                List list = criteria2.list();
                for (Ticket ticket : list) {
                    Map<String, String> map = ticket.getProperties();
                    Set<String> set = map.keySet();
                    for (String string : set) {
                        String string2 = map.get(string);
                        ticket.addProperty(string, string2);
                    }
                    session.update((Object)ticket);
                    ++n2;
                }
            }
            transaction.commit();
        }
    }

    public void updateTransactions() throws Exception {
        Transaction transaction = null;
        try (Session session = null;){
            PosTransactionDAO posTransactionDAO = PosTransactionDAO.getInstance();
            session = posTransactionDAO.createNewSession();
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(PosTransaction.class);
            criteria.setProjection(Projections.rowCount());
            Object object = criteria.uniqueResult();
            int n = 0;
            if (object != null) {
                n = ((Number)object).intValue();
            }
            int n2 = 0;
            int n3 = 100;
            while (n2 < n) {
                Criteria criteria2 = session.createCriteria(PosTransaction.class);
                criteria2.setFirstResult(n2);
                criteria2.setMaxResults(n3);
                List list = criteria2.list();
                for (PosTransaction posTransaction : list) {
                    Map<String, String> map = posTransaction.getProperties();
                    Set<String> set = map.keySet();
                    for (String string : set) {
                        String string2 = map.get(string);
                        posTransaction.addExtraProperty(string, string2);
                    }
                    session.update((Object)posTransaction);
                    ++n2;
                }
            }
            transaction.commit();
        }
    }
}

