/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main.update;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.extension.AbstractFloreantPlugin;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.main.PosWindow;
import com.floreantpos.main.ProcessUtil;
import com.floreantpos.main.update.UpdateNotificationDialog;
import com.floreantpos.main.update.UpdateNotificationHandler;
import com.floreantpos.main.update.UpdatePendingDialog;
import com.floreantpos.main.update.UpdatePluginNotificationHandler;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.GlassPane;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.update.Information;
import com.floreantpos.update.Modes;
import com.floreantpos.update.UpdateListener;
import com.floreantpos.update.UpdateService;
import com.floreantpos.update.UpdateXMLParser;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import com.orocube.rest.service.mqtt.OroMqttDataListener;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONObject;

public class UpdateManager
implements OroMqttDataListener {
    public static final String SOFTWARE_NUMERIC_VERSION = "software.numeric.version";
    public static final String HAS_UPDATE = "has_update";
    public static final String HAS_PLUGIN_UPDATE = "has_plugin_update";
    public static final String FORCE_UPDATE = "force_update";
    private JFrame a;

    public JFrame getParentWindow() {
        return this.a;
    }

    public void setParentWindow(JFrame jFrame) {
        this.a = jFrame;
    }

    public void checkForUpdate() {
        String string = Application.getInstance().getUpdateServerURL();
        String string2 = VersionInfo.getAppName();
        String string3 = VersionInfo.getVersion();
        int n = VersionInfo.getNumericVersion();
        UpdateService.checkForUpdate((Component)this.a, (UpdateListener)new UpdateNotificationHandler(false), (String)string, (String)string2, (String)string3, (int)n);
    }

    public void checkForPluginUpdate(String string, String string2, String string3, int n) {
        UpdateService.checkForUpdate((Component)this.a, (UpdateListener)new UpdatePluginNotificationHandler(false, string2, n), (String)string, (String)string2, (String)string3, (int)n);
    }

    public boolean isUpdateAvailable() {
        String string = Application.getInstance().getUpdateServerURL();
        String string2 = VersionInfo.getAppName();
        String string3 = VersionInfo.getVersion();
        int n = VersionInfo.getNumericVersion();
        return this.isUpdateAvailable(string, string2, string3, n);
    }

    public boolean isUpdateAvailable(String string, String string2, String string3, int n) {
        return UpdateService.isUpdateAvailable((Component)this.a, (UpdateListener)new UpdateNotificationHandler(false), (String)string, (String)string2, (String)string3, (int)n);
    }

    public void checkHasRemainingUpdates() {
        if (AppConfig.getBoolean(HAS_UPDATE, false)) {
            this.a();
        } else if (AppConfig.getBoolean(HAS_PLUGIN_UPDATE, false)) {
            this.b();
        }
    }

    private void a() {
        try {
            Information information = UpdateManager.c();
            if (!AppConfig.getBoolean(FORCE_UPDATE, false)) {
                Object object;
                try {
                    object = OroMqttClient.getInstance();
                    ((OroMqttClient)object).initMqttClient(Application.getInstance().getMqttDeviceId());
                    this.a(information, Action.MESSAGE.name(), Messages.getString("UpdateManager.5"), Messages.getString("UpdateManager.6"), false, "");
                    PosLog.debug(this.getClass(), "mqtt client started");
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), exception);
                }
                object = new UpdatePendingDialog();
                ((POSDialog)object).open();
            }
            this.a(information);
            AppConfig.removeProperty(HAS_UPDATE);
            System.exit(0);
        }
        catch (Exception exception) {
            AppConfig.removeProperty(HAS_UPDATE);
            POSMessageDialog.showError(null, Messages.getString("UpdateManager.9") + exception.getMessage(), exception);
            System.exit(1);
        }
    }

    private void b() {
        try {
            String string = AppConfig.getString("updated_plugin_name");
            Information information = UpdateManager.a(string);
            if (!AppConfig.getBoolean(FORCE_UPDATE, false)) {
                OroMqttClient oroMqttClient = OroMqttClient.getInstance();
                oroMqttClient.initMqttClient(Application.getInstance().getMqttDeviceId());
                this.a(information, Action.MESSAGE.name(), Messages.getString("UpdateManager.12"), Messages.getString("UpdateManager.6"), true, information.getAppName());
                PosLog.debug(this.getClass(), "mqtt client started");
                UpdatePendingDialog updatePendingDialog = new UpdatePendingDialog();
                updatePendingDialog.open();
            }
            this.a(information, string.trim().toLowerCase(), true);
            AppConfig.removeProperty(HAS_PLUGIN_UPDATE);
            System.exit(0);
        }
        catch (Exception exception) {
            AppConfig.removeProperty(HAS_PLUGIN_UPDATE);
            POSMessageDialog.showError(null, Messages.getString("UpdateManager.15") + exception.getMessage(), exception);
            System.exit(1);
        }
    }

    private void a(Information information, String string, String string2, String string3, boolean bl, String string4) throws Exception {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("action", (Object)string);
            jSONObject.put("content", (Object)string2);
            jSONObject.put("msg", (Object)string3);
            jSONObject.put("terminalKey", (Object)TerminalUtil.getSystemUID());
            if (bl) {
                jSONObject.put("plugin", bl);
                jSONObject.put("pluginName", (Object)string4);
                jSONObject.put("pluginNumericVersion", information.getPkgrel());
            } else {
                jSONObject.put("terminalAppNumericVersion", information.getPkgrel());
            }
            OroMqttClient.getInstance().publishData("auto-update-service", jSONObject.toString());
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private static Information c() throws Exception {
        return UpdateManager.a(UpdateManager.d());
    }

    private static Information a(String string) throws Exception {
        String string2 = System.getProperty("java.io.tmpdir") + "/" + string.toLowerCase() + "/update.xml";
        Information information = UpdateXMLParser.parse((String)string2, (Modes)Modes.FILE);
        if (information != null) {
            return information;
        }
        throw new Exception(Messages.getString("UpdateManager.28"));
    }

    private void a(Information information) throws Exception {
        this.a(information, VersionInfo.getAppName(), false);
    }

    private void a(Information information, String string, boolean bl) throws Exception {
        if (!bl) {
            UpdateManager.b(information);
        }
        String string2 = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        File file = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        String string3 = URLDecoder.decode(file.getPath(), "UTF-8");
        String string4 = string3.replace(file.getName(), "auto-updater.jar");
        ProcessBuilder processBuilder = new ProcessBuilder(string2, "-cp", string4, "com.floreantpos.update.UpdateServiceWindow", string3, string, VersionInfo.getAppName());
        processBuilder.start();
    }

    private static void b(Information information) throws Exception {
        String string = System.getProperty("java.io.tmpdir") + "/" + UpdateManager.d().toLowerCase() + "/" + information.getFilename();
        PosLog.info(UpdateManager.class, Messages.getString("UpdateManager.37") + string);
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            if (!string2.startsWith("lib") || !string2.contains("auto-updater")) continue;
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                String string3;
                File file = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                if (!file.isFile()) {
                    return;
                }
                file = file.getParentFile();
                String string4 = string3 = URLDecoder.decode(file.getPath(), "UTF-8");
                PosLog.info(UpdateManager.class, "decode parent path: " + string3);
                PosLog.info(UpdateManager.class, "auto updater destination: " + string4);
                File file2 = new File(string4, "auto-updater.jar");
                try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                }
                PosLog.info(UpdateManager.class, Messages.getString("UpdateManager.44"));
                break;
            }
        }
        zipFile.close();
    }

    private static String d() {
        return VersionInfo.getAppName().replaceAll("\\W+", "_").toLowerCase();
    }

    public void publishIfNewUpdateAvailable() throws Exception {
        int n = AppConfig.getInt("last_app_version", VersionInfo.getNumericVersion());
        if (VersionInfo.getNumericVersion() > n) {
            this.e();
        }
    }

    private void e() throws Exception {
        Information information = UpdateManager.c();
        Store store = StoreDAO.getRestaurant();
        Integer n = store.getSoftwareNumericVersion();
        if (n == null || n < VersionInfo.getNumericVersion()) {
            store.setSoftwareVersion(VersionInfo.getVersion());
            store.setSoftwareNumericVersion(VersionInfo.getNumericVersion());
            StoreDAO.getInstance().update(store);
            DataProvider.get().refreshStore();
        }
        this.a(information, Action.UPDATE.name(), Messages.getString("UpdateManager.50"), "", false, "");
        AppConfig.removeProperty(HAS_UPDATE);
        AppConfig.removeProperty(FORCE_UPDATE);
        AppConfig.removeProperty("last_app_version");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                POSMessageDialog.showMessage(UpdateManager.this.a, Messages.getString("UpdateManager.54") + VersionInfo.getVersion());
            }
        });
    }

    private void f() {
        String string = UpdateManager.d();
        PosWindow posWindow = Application.getPosWindow();
        String string2 = Application.getInstance().getUpdateServerURL();
        UpdateService.startDownload((Component)posWindow, (UpdateListener)new UpdateNotificationHandler(), (String)string2, (String)string);
    }

    public void subscribeToUpdateService() throws Exception {
        OroMqttClient.getInstance().addDataListener(this);
    }

    private boolean a(String string, int n) {
        List<FloreantPlugin> list = ExtensionManager.getPlugins();
        for (FloreantPlugin floreantPlugin : list) {
            int n2;
            if (!(floreantPlugin instanceof AbstractFloreantPlugin)) continue;
            AbstractFloreantPlugin abstractFloreantPlugin = (AbstractFloreantPlugin)floreantPlugin;
            String string2 = abstractFloreantPlugin.getProductName();
            if (string == null || string2 == null || !string.equalsIgnoreCase(string2) || n > (n2 = abstractFloreantPlugin.getProductNumericVersion().intValue())) continue;
            return true;
        }
        return false;
    }

    private void a(Integer n, String string, Integer n2) {
        try {
            boolean bl;
            Integer n3 = VersionInfo.getNumericVersion();
            Integer n4 = 282;
            boolean bl2 = bl = n2 != null && n2 > n3;
            if (bl || n != null && n > n4) {
                String string2 = Messages.getString("UpdateManager.78") + Messages.getString("UpdateManager.79");
                string2 = String.format(string2, string);
                String string3 = null;
                string3 = TerminalConfig.isShowDbConfigureButton() ? POSMessageDialog.showOptionDialog(Application.getPosWindow(), string2, Messages.getString("UpdateManager.80"), Messages.getString("UpdateManager.81"), Messages.getString("UpdateManager.82"), Messages.getString("UpdateManager.83")) : POSMessageDialog.showOptionDialog(Application.getPosWindow(), string2, Messages.getString("UpdateManager.84"), Messages.getString("UpdateManager.85"), Messages.getString("UpdateManager.86"));
                if (string3 == null || string3.equals("No")) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("UpdateManager.63"));
                    System.exit(1);
                } else if (string3.equals("Yes")) {
                    this.f();
                } else {
                    DatabaseConfigurationDialog databaseConfigurationDialog = DatabaseConfigurationDialog.show(Application.getPosWindow());
                    if (databaseConfigurationDialog.isCanceled()) {
                        POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("UpdateManager.90"));
                        System.exit(1);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void performDatabaseUpgrade() throws Exception {
        Database database = AppConfig.getDefaultDatabase();
        String string = AppConfig.getConnectString();
        String string2 = AppConfig.getDatabaseUser();
        String string3 = AppConfig.getDatabasePassword();
        String string4 = database.getHibernateConnectionDriverClass();
        Map<String, String> map = DatabaseUtil.getStoreProperties(string, string4, string2, string3);
        String string5 = map.get("software.version");
        Integer n = null;
        Integer n2 = null;
        try {
            n = Integer.parseInt(map.get("database.version"));
            n2 = Integer.parseInt(map.get(SOFTWARE_NUMERIC_VERSION));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.a(n, string5, n2);
        if (!DatabaseUtil.isDbUpdateNeeded(n)) {
            return;
        }
        String string6 = Messages.getString("DB_UPGRADE_REQUIRED");
        String string7 = Messages.getString("ALERT");
        int n3 = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), string6, string7);
        if (n3 != 0) {
            return;
        }
        string6 = Messages.getString("DB_UPGRADE_ALERT_MESSAGE");
        n3 = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), string6, string7);
        if (n3 != 0) {
            POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("SHUTDOWN_MESSAGE"));
            System.exit(1);
        }
        GlassPane glassPane = (GlassPane)Application.getPosWindow().getGlassPane();
        glassPane.showMessageWithIndeterminateProgress("Updating database, this may take a few minutes");
        String string8 = database.getHibernateDialect();
        boolean bl = DatabaseUtil.updateDatabase(string, string8, string4, string2, string3);
        glassPane.hideMessageWithIndeterminateProgress();
        if (bl) {
            POSMessageDialog.showMessage(Messages.getString("DB_UPGRADE_SUCCESS"));
            ProcessUtil.restart();
        } else {
            POSMessageDialog.showMessage(Messages.getString("DatabaseConfigurationDialog.3"));
        }
    }

    @Override
    public void autoUpdateRequestReceived(String string, MqttMessage mqttMessage) {
        try {
            int n;
            PosLog.debug(this.getClass(), "Update message received");
            String string2 = new String(mqttMessage.getPayload());
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("terminalKey");
            PosLog.debug(this.getClass(), "Update notification from terminal " + string3);
            if (string3.equals(TerminalUtil.getSystemUID())) {
                return;
            }
            boolean bl = jSONObject.has("plugin") ? jSONObject.getBoolean("plugin") : false;
            String string4 = jSONObject.has("pluginName") ? jSONObject.getString("pluginName") : null;
            System.out.println("");
            if (bl && jSONObject.has("pluginNumericVersion") ? this.a(string4, n = jSONObject.getInt("pluginNumericVersion")) : jSONObject.has("terminalAppNumericVersion") && (n = jSONObject.getInt("terminalAppNumericVersion")) <= VersionInfo.getNumericVersion()) {
                return;
            }
            Object object = jSONObject.get("content");
            Object object2 = jSONObject.get("msg");
            Toolkit.getDefaultToolkit().beep();
            Action action = Action.valueOf(jSONObject.getString("action"));
            switch (action) {
                case MESSAGE: {
                    PosLog.debug(this.getClass(), "going to show that software will be updated");
                    UpdateNotificationDialog.showMessage(object.toString(), object2.toString(), false);
                    break;
                }
                case UPDATE: {
                    if (!bl && String.valueOf(VersionInfo.getNumericVersion()).equals(StoreDAO.getRestaurant().getSoftwareVersion())) {
                        return;
                    }
                    UpdateNotificationDialog updateNotificationDialog = UpdateNotificationDialog.getInstance(object.toString(), object2.toString(), true, bl, string4);
                    updateNotificationDialog.setUpdateButtonVisible(false);
                    updateNotificationDialog.startUpdating();
                }
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    static enum Action {
        MESSAGE,
        UPDATE;

    }
}

