/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.BalanceType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseBalanceUpdateTransaction;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"paymentType", "balanceType"})
@XmlRootElement
public class BalanceUpdateTransaction
extends BaseBalanceUpdateTransaction
implements PropertyContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROP_DESCRIPTION = "description";
    public static final String JSON_PROP_BALANCE_BEFORE = "balance.before";
    private double endBalance;
    private Integer dataVersion;
    private double giftCertFaceValue;
    private double serviceChargeAmount;
    private double taxAmount;
    private double tipsAmount;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public BalanceUpdateTransaction() {
    }

    public BalanceUpdateTransaction(String string) {
        super(string);
    }

    public BalanceUpdateTransaction(String string, String string2, String string3, String string4, String string5) {
        super(string, string2, string3, string4, string5);
    }

    public void setPaymentType(PaymentType paymentType) {
        this.setPaymentTypeString(paymentType != null ? paymentType.name() : null);
    }

    @XmlTransient
    public PaymentType getPaymentType() {
        String string = super.getPaymentTypeString();
        if (string == null) {
            return null;
        }
        return PaymentType.valueOf(string);
    }

    public void setBalanceType(BalanceType balanceType) {
        this.setBalanceTypeString(balanceType != null ? balanceType.name() : null);
    }

    @XmlTransient
    public BalanceType getBalanceType() {
        String string = super.getBalanceTypeString();
        if (string == null) {
            return null;
        }
        return BalanceType.valueOf(string);
    }

    public double getEndBalance() {
        return this.endBalance;
    }

    public void setEndBalance(double d) {
        this.endBalance = d;
    }

    @Override
    public String getExtraProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getExtraProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setExtraProperties(String string) {
        super.setExtraProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }

    public String getDescription() {
        return this.getProperty(JSON_PROP_DESCRIPTION);
    }

    public void setDescription(String string) {
        this.addProperty(JSON_PROP_DESCRIPTION, string);
    }

    public Double getBalanceBefore() {
        return POSUtil.parseDouble(this.getProperty(JSON_PROP_BALANCE_BEFORE));
    }

    public void setBalanceBefore(double d) {
        this.addProperty(JSON_PROP_BALANCE_BEFORE, String.valueOf(d));
    }

    public Integer getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(Integer n) {
        this.dataVersion = n;
    }

    public double getGiftCertFaceValue() {
        return this.giftCertFaceValue;
    }

    public void setGiftCertFaceValue(double d) {
        this.giftCertFaceValue = d;
    }

    public double getServiceChargeAmount() {
        return this.serviceChargeAmount;
    }

    public void setServiceChargeAmount(double d) {
        this.serviceChargeAmount = d;
    }

    public double getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(double d) {
        this.taxAmount = d;
    }

    public double getTipsAmount() {
        return this.tipsAmount;
    }

    public void setTipsAmount(double d) {
        this.tipsAmount = d;
    }
}

