/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.Course;
import com.floreantpos.model.Customer;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.ServicePaymentType;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseComboItem;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BasePizzaPrice;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.model.ext.UnitBaseItemPrice;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.InventoryUnitConvertionUtil;
import com.floreantpos.model.util.pricecalc.DataUtilCalcFactory;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true, value={"buttonColor", "textColor", "image", "orderTypeList", "properties", "discounts", "terminals", "recepieItems", "units", "sizes", "variantName", "parentMenuItem", "explorerImage", "taxGroup", "reportGroup", "unit", "stockStatus", "availableUnit", "unitOnHand", "variants", "activeVariants"})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MenuItem
extends BaseMenuItem
implements TimedModel {
    public static final String JSON_PROP_SUFFIX_TAXGROUP = ".taxgroup";
    public static final String JSON_PROP_SUFFIX_FOR_HERE = ".for_here";
    public static final String JSON_PROP_SUFFIX_TO_GO = ".to_go";
    private static final long serialVersionUID = 1L;
    public static final String TRANSIENT_PROP_VENDOR_NAME = "vendorNames";
    public static final String PROP_UNIT_BASE_PRICE_KEY = "unit.{name}.price";
    public static final String TYPE_RAW_METARIAL = "Raw Material";
    public static final String TYPE_INVENTORY_ITEM = "Inventory Item";
    public static final String TYPE_MENU_ITEM = "Menu Item";
    private static final String JSON_PROP_ENABLE_QTY_SELECTION = "enable.qty.selection";
    private static final String JSON_PROP_MOD_PRICE_COMBO_ITEM = "menuitem.modifiable.price.on.comboItem";
    private transient String vendorNames;
    private MenuItem parentMenuItem;
    private MenuItemInventoryStatus stockStatus;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private boolean showChildUnits = true;
    private boolean unitWiseItem = false;
    private transient JSONObject properties;

    public MenuItem() {
    }

    public MenuItem(String string) {
        super(string);
    }

    public MenuItem(String string, String string2, Double d) {
        super(string, string2, d);
    }

    public void setImage(ImageIcon imageIcon) {
    }

    @JsonIgnore
    public ImageIcon getImage() {
        ImageResource imageResource = DataProvider.get().getImageResource(this.getImageId());
        if (imageResource != null) {
            return imageResource.getButtonImage();
        }
        return null;
    }

    @JsonIgnore
    public ImageIcon getExplorerImage() {
        ImageResource imageResource = DataProvider.get().getImageResource(this.getImageId());
        if (imageResource != null) {
            return ImageResource.getScaledImageIcon(imageResource.getImageIcon(), PosUIManager.getSize(30));
        }
        return null;
    }

    public void setExplorerImage(ImageIcon imageIcon) {
    }

    @Override
    public Integer getSortOrder() {
        return super.getSortOrder() == null ? 9999 : super.getSortOrder();
    }

    @Override
    public Integer getButtonColorCode() {
        Integer n = super.getButtonColorCode();
        if (n == null || n == 0 || n == -1316371) {
            n = Color.WHITE.getRGB();
        }
        return n;
    }

    @XmlTransient
    @JsonIgnore
    public Color getButtonColor() {
        Integer n = this.getButtonColorCode();
        if (n == null) {
            return null;
        }
        return new Color(this.getButtonColorCode());
    }

    public void setButtonColor(Color color) {
        if (color != null) {
            this.setTextColorCode(color.getRGB());
        }
    }

    @XmlTransient
    @JsonIgnore
    public Color getTextColor() {
        if (this.getTextColorCode() == null) {
            return null;
        }
        return new Color(this.getTextColorCode());
    }

    public void setTextColor(Color color) {
        if (color != null) {
            this.setTextColorCode(color.getRGB());
        }
    }

    @XmlTransient
    @JsonIgnore
    public String getDisplayName() {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        if ((terminal != null && terminal.isShowTranslatedName().booleanValue() || this.isVariant().booleanValue()) && StringUtils.isNotEmpty((String)super.getTranslatedName())) {
            return super.getTranslatedName();
        }
        String string = super.getName();
        return string;
    }

    public void setDisplayName(String string) {
    }

    @XmlTransient
    @JsonIgnore
    public String getVariantName() {
        String string = super.getName();
        List<Attribute> list = this.getAttributes();
        if (list == null) {
            return string;
        }
        string = string + " (";
        Iterator<Attribute> iterator = list.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            string = string + attribute.getName();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        string = string + ")";
        return string;
    }

    public String createVariantName(String string) {
        List<Attribute> list = this.getAttributes();
        if (list == null) {
            return string;
        }
        string = string + " (";
        Iterator<Attribute> iterator = list.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            string = string + attribute.getName();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        string = string + ")";
        return string;
    }

    public void setVariantName(String string) {
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    @JsonIgnore
    public String getUniqueId() {
        return ("menu_item_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    public TicketItem convertToTicketItem(Ticket ticket, double d) {
        return this.convertToTicketItem(ticket, d, false);
    }

    public TicketItem convertToTicketItem(Ticket ticket, double d, IUnit iUnit) {
        return this.convertToTicketItem(ticket, d, false, iUnit);
    }

    public TicketItem convertToTicketItem(Ticket ticket, double d, boolean bl) {
        return this.convertToTicketItem(ticket, d, bl, null);
    }

    public TicketItem convertToTicketItem(Ticket ticket, double d, boolean bl, IUnit iUnit) {
        return this.convertToTicketItem(ticket, d, bl, iUnit, true);
    }

    public TicketItem convertToTicketItem(Ticket ticket, double d, boolean bl, IUnit iUnit, boolean bl2) {
        return DataUtilCalcFactory.getCalc().convertToTicketItem(this, ticket, d, bl, iUnit, bl2);
    }

    public void setTicketItemUnitPriceAndCost(TicketItem ticketItem, MenuItem menuItem, IUnit iUnit, Ticket ticket) {
        this.setTicketItemUnitPriceAndCost(ticketItem, menuItem, iUnit, ticket, true);
    }

    public void setTicketItemUnitPriceAndCost(TicketItem ticketItem, MenuItem menuItem, IUnit iUnit, Ticket ticket, boolean bl) {
        this.setTicketItemUnitPriceAndCost(ticketItem, menuItem, iUnit, ticket, bl, false);
    }

    public void setTicketItemUnitPriceAndCost(TicketItem ticketItem, MenuItem menuItem, IUnit iUnit, Ticket ticket, boolean bl, boolean bl2) {
        DataUtilCalcFactory.getCalc().setTicketItemUnitPriceAndCost(this, ticketItem, iUnit, ticket, bl, bl2);
    }

    public double getDestinationUnitPrice(Ticket ticket, MenuItem menuItem, IUnit iUnit, double d) {
        return DataUtilCalcFactory.getCalc().getDestinationUnitPrice(ticket, menuItem, iUnit, d);
    }

    public double getDestinationUnitPrice(MenuItem menuItem, IUnit iUnit, Double d, double d2) {
        return DataUtilCalcFactory.getCalc().getDestinationUnitPrice(menuItem, iUnit, d, d2);
    }

    public Double calculateDefaultPizzaPrice() {
        return DataUtilCalcFactory.getCalc().calculateDefaultPizzaPrice(this);
    }

    public Double calculateDefaultPizzaCost() {
        return DataUtilCalcFactory.getCalc().calculateDefaultPizzaCost(this);
    }

    public double getPriceFromPriceRule(Ticket ticket) {
        return DataUtilCalcFactory.getCalc().getPriceFromPriceRule(this, ticket);
    }

    public String getCourseOrganizeId() {
        String string = super.getCourseId();
        return string;
    }

    public static void setItemTaxes(TicketItem ticketItem, TaxGroup taxGroup, OrderType orderType) {
        DataUtilCalcFactory.getCalc().setItemTaxes(ticketItem, taxGroup, orderType);
    }

    public boolean hasModifiers() {
        return super.isHasModifiers();
    }

    public boolean hasMandatoryModifiers() {
        return super.isHasMandatoryModifiers();
    }

    public boolean hasAutoShowModifierGroup() {
        List<MenuItemModifierSpec> list = this.getMenuItemModiferSpecs();
        if (list == null || list.size() == 0) {
            return false;
        }
        for (MenuItemModifierSpec menuItemModifierSpec : list) {
            if (menuItemModifierSpec.isUseModifierGroupSettings()) {
                ModifierGroup modifierGroup = menuItemModifierSpec.getModifierGroup();
                if (!modifierGroup.isEnable().booleanValue()) continue;
                if (menuItemModifierSpec.isUseModifierGroupSettings()) {
                    menuItemModifierSpec.copyModifierGroupProperties();
                }
                if (!modifierGroup.isAutoShow().booleanValue() && modifierGroup.getMinQuantity() <= 0) continue;
                return true;
            }
            if (!menuItemModifierSpec.isEnable().booleanValue() || !menuItemModifierSpec.isAutoShow().booleanValue() && menuItemModifierSpec.getMinQuantity() <= 0) continue;
            return true;
        }
        return false;
    }

    @XmlTransient
    @JsonIgnore
    public Set<MenuItemSize> getSizes() {
        HashSet<MenuItemSize> hashSet = new HashSet<MenuItemSize>();
        List<PizzaPrice> list = this.getPizzaPriceList();
        if (list != null) {
            for (PizzaPrice pizzaPrice : list) {
                hashSet.add(pizzaPrice.getSize());
            }
        }
        return hashSet;
    }

    @XmlTransient
    @JsonIgnore
    public Set<PizzaCrust> getPizzaCrusts() {
        HashSet<PizzaCrust> hashSet = new HashSet<PizzaCrust>();
        List<PizzaPrice> list = this.getPizzaPriceList();
        if (list != null) {
            for (PizzaPrice pizzaPrice : list) {
                hashSet.add(pizzaPrice.getCrust());
            }
        }
        return hashSet;
    }

    @JsonIgnore
    public List<IUnit> getStockCountableUnits() {
        return this.getStockCountableUnits(false);
    }

    public List<IUnit> getStockCountableUnits(boolean bl) {
        return this.getUnits(true, bl, true);
    }

    @JsonIgnore
    public List<IUnit> getUnits() {
        return this.getUnits(false);
    }

    public List<IUnit> getUnits(boolean bl) {
        return this.getUnits(true, bl);
    }

    public List<IUnit> getUnits(boolean bl, boolean bl2) {
        return this.getUnits(bl, bl2, false);
    }

    public List<IUnit> getUnits(boolean bl, boolean bl2, boolean bl3) {
        return DataUtilCalcFactory.getCalc().getUnits(this, bl, bl2, bl3);
    }

    @JsonIgnore
    public List<InventoryStockUnit> getVariantStockUnits() {
        MenuItem menuItem;
        if (this.isVariant().booleanValue() && (menuItem = this.getParentMenuItem()) != null) {
            return menuItem.getStockUnits();
        }
        return super.getStockUnits();
    }

    public Double getVariantCost(IUnit iUnit) {
        return DataUtilCalcFactory.getCalc().getVariantCost(this, iUnit);
    }

    public Double getCost(IUnit iUnit) {
        return DataUtilCalcFactory.getCalc().getCost(this, iUnit);
    }

    public Double getCost(String string) {
        return DataUtilCalcFactory.getCalc().getCost(this, string);
    }

    public double getUnitQuantity(IUnit iUnit, IUnit iUnit2) {
        return InventoryUnitConvertionUtil.getUnitQuantity(iUnit, iUnit2, this);
    }

    public double getBaseUnitQuantity(String string) {
        return InventoryUnitConvertionUtil.getBaseUnitQuantity(string, this);
    }

    @Override
    @JsonIgnore
    public Double getAverageUnitPurchasePrice() {
        Double d = super.getAverageUnitPurchasePrice();
        if (d == 0.0) {
            return this.getCost();
        }
        return d;
    }

    @Override
    public String getSku() {
        String string = super.getSku();
        if (StringUtils.isEmpty((String)string)) {
            return super.getBarcode();
        }
        return string;
    }

    @XmlTransient
    public Double getAvailableUnit() {
        if (this.stockStatus != null) {
            return this.stockStatus.getAvailableUnit();
        }
        this.stockStatus = this.getStockStatus();
        return this.stockStatus == null ? 0.0 : this.stockStatus.getAvailableUnit();
    }

    @XmlTransient
    public Double getUnitOnHand() {
        if (this.stockStatus != null) {
            return this.stockStatus.getUnitOnHand();
        }
        this.stockStatus = this.getStockStatus();
        return this.stockStatus == null ? 0.0 : this.stockStatus.getUnitOnHand();
    }

    public void setUnitOnHand(Double d) {
        if (this.stockStatus == null) {
            this.stockStatus = new MenuItemInventoryStatus();
            this.stockStatus.setId(this.getId());
        }
        this.stockStatus.setUnitOnHand(d);
    }

    public void setAvailableUnit(Double d) {
        if (this.stockStatus == null) {
            this.stockStatus = new MenuItemInventoryStatus();
            this.stockStatus.setId(this.getId());
        }
        this.stockStatus.setAvailableUnit(d);
    }

    @JsonIgnore
    public Double getRetailPrice() {
        return this.getPrice();
    }

    @JsonIgnoreProperties
    @XmlTransient
    @Deprecated
    @JsonIgnore
    public MenuGroup getParent() {
        String string = this.getMenuGroupId();
        if (StringUtils.isNotEmpty((String)string)) {
            return MenuGroupDAO.getInstance().get(string);
        }
        return null;
    }

    public void setParent(MenuGroup menuGroup) {
        this.setMenuGroup(menuGroup);
    }

    public void setMenuGroup(MenuGroup menuGroup) {
        if (menuGroup == null) {
            this.setMenuGroupId(null);
            this.setMenuGroupName(null);
            this.setMenuCategoryId(null);
            this.setMenuCategoryName(null);
            this.setTicketDiscountApplicable(true);
        } else {
            MenuCategory menuCategory;
            this.setMenuGroupId(menuGroup.getId());
            this.setMenuGroupName(menuGroup.getDisplayName());
            this.setMenuCategoryId(menuGroup.getMenuCategoryId());
            this.setMenuCategoryName(menuGroup.getMenuCategoryName());
            String string = menuGroup.getMenuCategoryId();
            if (StringUtils.isNotBlank((String)string) && (menuCategory = MenuCategoryDAO.getInstance().get(string)) != null) {
                this.setTicketDiscountApplicable(menuCategory.isTicketDiscountApplicable());
            }
        }
    }

    @XmlTransient
    @JsonIgnore
    public PrinterGroup getPrinterGroup() {
        return DataProvider.get().getPrinterGroupById(this.getPrinterGroupId());
    }

    public void setPrinterGroup(PrinterGroup printerGroup) {
        String string = null;
        if (printerGroup != null) {
            string = printerGroup.getId();
        }
        super.setPrinterGroupId(string);
    }

    @XmlTransient
    @JsonIgnore
    public InventoryUnit getUnit() {
        if (this.isVariant().booleanValue() && this.getUnitId() == null) {
            return DataProvider.get().getInventoryUnitById(this.getParentMenuItem().getUnitId());
        }
        return DataProvider.get().getInventoryUnitById(this.getUnitId());
    }

    @XmlTransient
    @JsonIgnore
    public InventoryUnit getStockCountableUnit() {
        InventoryUnit inventoryUnit = this.getUnit();
        if (inventoryUnit == null || inventoryUnit.isStockCountable()) {
            return inventoryUnit;
        }
        return this.getBaseUnit();
    }

    @XmlTransient
    @JsonIgnore
    public InventoryUnit getBaseUnit() {
        InventoryUnit inventoryUnit = this.getUnit();
        if (inventoryUnit == null) {
            return null;
        }
        if (inventoryUnit.isBaseUnit().booleanValue()) {
            return inventoryUnit;
        }
        InventoryUnitGroup inventoryUnitGroup = inventoryUnit.getUnitGroup();
        if (inventoryUnitGroup != null && inventoryUnitGroup.getActiveUnits() != null) {
            for (InventoryUnit inventoryUnit2 : inventoryUnitGroup.getActiveUnits()) {
                if (!inventoryUnit2.isBaseUnit().booleanValue()) continue;
                return inventoryUnit2;
            }
        }
        return inventoryUnit;
    }

    public void setUnit(InventoryUnit inventoryUnit) {
        String string = null;
        if (inventoryUnit != null) {
            string = inventoryUnit.getId();
            this.setUnitName(inventoryUnit.getCode());
        }
        super.setUnitId(string);
    }

    @XmlTransient
    @JsonIgnore
    public ReportGroup getReportGroup() {
        return DataProvider.get().getReportGroupById(this.getReportGroupId());
    }

    public void setReportGroup(ReportGroup reportGroup) {
        String string = null;
        if (reportGroup != null) {
            string = reportGroup.getId();
        }
        super.setReportGroupId(string);
    }

    @XmlTransient
    @JsonIgnore
    public TaxGroup getTaxGroup() {
        TaxGroup taxGroup = DataProvider.get().getTaxGroupById(this.getTaxGroupId());
        if (taxGroup == null && this.isVariant().booleanValue() && this.getParentMenuItemId() != null) {
            taxGroup = this.getParentMenuItem().getTaxGroup();
        }
        return taxGroup;
    }

    public TaxGroup getTaxGroup(Customer customer) {
        return this.getTaxGroup();
    }

    public void setTaxGroup(TaxGroup taxGroup) {
        String string = null;
        if (taxGroup != null) {
            string = taxGroup.getId();
        }
        super.setTaxGroupId(string);
    }

    public void setOrderTypeList(List list) {
    }

    @XmlTransient
    @JsonIgnore
    public MenuItem getParentMenuItem() {
        if (this.parentMenuItem != null) {
            return this.parentMenuItem;
        }
        String string = this.getParentMenuItemId();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.parentMenuItem = MenuItemDAO.getInstance().get(string);
        return this.parentMenuItem;
    }

    public void setParentMenuItem(MenuItem menuItem) {
        this.parentMenuItem = menuItem;
        if (menuItem != null) {
            String string = menuItem.getId();
            if (StringUtils.isBlank((String)super.getParentMenuItemId()) && StringUtils.isNotBlank((String)string)) {
                super.setParentMenuItemId(string);
                this.addProperty("variantParentMenuItemId", string);
            }
        }
    }

    @XmlTransient
    public MenuItemInventoryStatus getStockStatus() {
        if (this.stockStatus != null || this.getId() == null) {
            return this.stockStatus;
        }
        this.stockStatus = DataProvider.get().getMenuItemStockStatus(this);
        return this.stockStatus;
    }

    public void setStockStatus(MenuItemInventoryStatus menuItemInventoryStatus) {
        this.stockStatus = menuItemInventoryStatus;
    }

    @Override
    public void setPropertiesJson(String string) {
        super.setPropertiesJson(string);
        this.properties = StringUtils.isNotEmpty((String)string) ? new JSONObject(string) : new JSONObject();
    }

    private void buildPropertis() {
        if (this.properties != null) {
            return;
        }
        String string = this.getPropertiesJson();
        if (StringUtils.isEmpty((String)string)) {
            this.properties = new JSONObject();
            return;
        }
        this.properties = new JSONObject(string);
    }

    public void addProperty(String string, String string2) {
        this.buildPropertis();
        this.properties.put(string, (Object)string2);
        this.setPropertiesJson(this.properties.toString());
    }

    @JsonIgnore
    public JSONObject getProperties() {
        return this.properties;
    }

    public String getProperty(String string) {
        this.buildPropertis();
        if (this.properties.has(string)) {
            return this.properties.getString(string);
        }
        return null;
    }

    public void removeProperty(String string) {
        this.buildPropertis();
        this.properties.remove(string);
        this.setPropertiesJson(this.properties.toString());
    }

    @Deprecated
    @JsonIgnore
    public Course getCourse() {
        String string = this.getCourseId();
        if (StringUtils.isNotEmpty((String)string)) {
            return CourseDAO.getInstance().get(string);
        }
        return null;
    }

    public void setCourse(Course course) {
        this.setCourseId(course == null ? null : course.getId());
    }

    private MenuItem cloneItemConsideringOrphanCollections(MenuItem menuItem) {
        List<PizzaPrice> list = menuItem.getPizzaPriceList();
        List<MenuItem> list2 = menuItem.getVariants();
        menuItem.setPizzaPriceList(null);
        menuItem.setVariants(null);
        MenuItem menuItem2 = (MenuItem)SerializationUtils.clone((Serializable)menuItem);
        menuItem.setPizzaPriceList(list);
        menuItem.setVariants(list2);
        return menuItem2;
    }

    public MenuItem clone() {
        Serializable serializable2;
        List<Comparable> list;
        MenuItem menuItem = this.cloneItemConsideringOrphanCollections(this);
        String string = POSUtil.doDuplicateName(this.getName());
        menuItem.setName(string);
        menuItem.setId(null);
        List<InventoryStockUnit> list3 = menuItem.getStockUnits();
        if (list3 != null) {
            for (InventoryStockUnit list22 : list3) {
                list22.setId(null);
                list22.setMenuItemId(menuItem.getId());
            }
        }
        List<ComboItem> list4 = menuItem.getComboItems();
        menuItem.setComboItems(new ArrayList<ComboItem>());
        if (list4 != null) {
            Iterator iterator = list4.iterator();
            while (iterator.hasNext()) {
                list = (ComboItem)iterator.next();
                ((BaseComboItem)((Object)list)).setId(null);
                menuItem.getComboItems().add((ComboItem)((Object)list));
            }
        }
        List<ComboGroup> list2 = menuItem.getComboGroups();
        menuItem.setComboGroups(new ArrayList<ComboGroup>());
        if (list2 != null) {
            for (ComboGroup comboGroup : list2) {
                comboGroup.setId(null);
                List<MenuItem> list5 = comboGroup.getItems();
                comboGroup.setItems(new ArrayList<MenuItem>());
                if (list5 != null) {
                    for (Serializable serializable2 : list5) {
                        comboGroup.getItems().add((MenuItem)serializable2);
                    }
                }
                menuItem.getComboGroups().add(comboGroup);
            }
        }
        MenuItem.copyModifierSpecsToMenuItem(menuItem, menuItem.getMenuItemModiferSpecs());
        if (this.isPizzaType().booleanValue() && this.getPizzaPriceList() != null) {
            list = this.getPizzaPriceList();
            List<PizzaPrice> list6 = menuItem.getPizzaPriceList();
            if (list6 != null) {
                list6.clear();
            }
            for (PizzaPrice pizzaPrice : list) {
                serializable2 = (PizzaPrice)SerializationUtils.clone((Serializable)pizzaPrice);
                ((BasePizzaPrice)serializable2).setId(null);
                menuItem.addTopizzaPriceList((PizzaPrice)serializable2);
            }
        }
        menuItem.setVariants(null);
        list = this.getVariants();
        if (list != null) {
            for (MenuItem menuItem2 : list) {
                if (menuItem2.isDeleted().booleanValue()) continue;
                MenuItem menuItem3 = this.cloneItemConsideringOrphanCollections(menuItem2);
                menuItem3.setId(null);
                menuItem3.setMenuItemModiferSpecs(null);
                menuItem3.setComboGroups(null);
                menuItem3.setComboItems(null);
                menuItem3.setVariants(null);
                serializable2 = new ArrayList();
                List<Attribute> list7 = menuItem2.getAttributes();
                for (Attribute attribute : list7) {
                    Attribute attribute2 = (Attribute)SerializationUtils.clone((Serializable)attribute);
                    serializable2.add(attribute2);
                }
                menuItem3.setAttributes((List<Attribute>)((Object)serializable2));
                menuItem.addTovariants(menuItem3);
            }
        }
        return menuItem;
    }

    public static void copyModifierSpecsToMenuItem(MenuItem menuItem, List<MenuItemModifierSpec> list) {
        ArrayList<MenuItemModifierSpec> arrayList = new ArrayList<MenuItemModifierSpec>();
        if (list != null) {
            for (MenuItemModifierSpec menuItemModifierSpec : list) {
                menuItemModifierSpec.setId(null);
                Set<MenuItemModifierPage> set = menuItemModifierSpec.getModifierPages();
                HashSet<MenuItemModifierPage> hashSet = new HashSet<MenuItemModifierPage>();
                if (set != null) {
                    for (MenuItemModifierPage menuItemModifierPage : set) {
                        ArrayList<MenuItemModifierPageItem> arrayList2 = new ArrayList<MenuItemModifierPageItem>();
                        menuItemModifierPage.setId(null);
                        menuItemModifierPage.setModifierSpecId(menuItemModifierSpec.getId());
                        List<MenuItemModifierPageItem> list2 = menuItemModifierPage.getPageItems();
                        if (list2 != null) {
                            for (MenuItemModifierPageItem menuItemModifierPageItem : list2) {
                                menuItemModifierPageItem.setId(null);
                                menuItemModifierPageItem.setParentPage(menuItemModifierPage);
                                arrayList2.add(menuItemModifierPageItem);
                            }
                        }
                        menuItemModifierPage.setPageItems(arrayList2);
                        hashSet.add(menuItemModifierPage);
                    }
                }
                menuItemModifierSpec.setModifierPages(hashSet);
                arrayList.add(menuItemModifierSpec);
            }
        }
        menuItem.setMenuItemModiferSpecs(arrayList);
    }

    public void setUnitSelection(boolean bl) {
        this.addProperty("menuitem.allow_unit_selection", String.valueOf(bl));
    }

    public boolean isAllowUnitSelection() {
        if (this.isVariant().booleanValue()) {
            MenuItem menuItem = this.getParentMenuItem();
            if (menuItem != null) {
                return menuItem.getBooleanProperty("menuitem.allow_unit_selection", Boolean.FALSE);
            }
            return Boolean.FALSE;
        }
        return this.getBooleanProperty("menuitem.allow_unit_selection", Boolean.FALSE);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.getProperty(string);
        if (StringUtils.isBlank((String)string2)) {
            return bl;
        }
        return Boolean.valueOf(string2);
    }

    @JsonIgnore
    public String getVendorNames() {
        return this.vendorNames;
    }

    public void setVendorNames(String string) {
        this.vendorNames = string;
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @XmlTransient
    @JsonIgnore
    public double getTotalTaxRate() {
        TaxGroup taxGroup = this.getTaxGroup();
        if (taxGroup != null) {
            return taxGroup.getTotalTaxRate();
        }
        return 0.0;
    }

    public void setTotalTaxRate(double d) {
    }

    @Override
    public void addTomenuItemModiferSpecs(MenuItemModifierSpec menuItemModifierSpec) {
        List<MenuItemModifierSpec> list = this.getMenuItemModiferSpecs();
        if (list == null) {
            list = new ArrayList<MenuItemModifierSpec>(1);
            this.setMenuItemModiferSpecs(list);
        }
        for (MenuItemModifierSpec menuItemModifierSpec2 : list) {
            if (!menuItemModifierSpec2.getModifierGroupId().equals(menuItemModifierSpec.getModifierGroupId())) continue;
            return;
        }
        list.add(menuItemModifierSpec);
    }

    @Override
    public String getUnitName() {
        InventoryUnit inventoryUnit;
        String string = super.getUnitName();
        if (StringUtils.isNotEmpty((String)string)) {
            return string;
        }
        String string2 = this.getUnitId();
        if (StringUtils.isNotEmpty((String)string2) && (inventoryUnit = DataProvider.get().getInventoryUnitById(string2)) != null) {
            return inventoryUnit.getCode();
        }
        return string;
    }

    @XmlTransient
    public void setModifiablePriceForComboItem(boolean bl) {
        this.addProperty(JSON_PROP_MOD_PRICE_COMBO_ITEM, String.valueOf(bl));
    }

    public boolean isModifiablePriceForComboItem() {
        return POSUtil.getBoolean(this.getProperty(JSON_PROP_MOD_PRICE_COMBO_ITEM));
    }

    @XmlTransient
    public void setBasePriceForComboItem(boolean bl) {
        this.addProperty("base.priced.comboItem", String.valueOf(bl));
    }

    public boolean isBasePriceForComboItem() {
        return POSUtil.getBoolean(this.getProperty("base.priced.comboItem"));
    }

    @XmlTransient
    public void setBaseAndGroupPriceForComboItem(boolean bl) {
        this.addProperty("base_and_group.priced.comboItem", String.valueOf(bl));
    }

    public boolean isBaseAndGroupPriceForComboItem() {
        return POSUtil.getBoolean(this.getProperty("base_and_group.priced.comboItem"));
    }

    @XmlTransient
    public void setHighestPricedComboItem(boolean bl) {
        this.addProperty("highest.priced.comboItem", String.valueOf(bl));
    }

    public boolean isHighestPricedComboItem() {
        return POSUtil.getBoolean(this.getProperty("highest.priced.comboItem"));
    }

    @XmlTransient
    public void setEnableComboQuantitySelection(boolean bl) {
        this.addProperty(JSON_PROP_ENABLE_QTY_SELECTION, String.valueOf(bl));
    }

    public boolean isEnableComboQuantitySelection() {
        return POSUtil.getBoolean(this.getProperty(JSON_PROP_ENABLE_QTY_SELECTION));
    }

    public Double updateUnitBasePrice(String string, Double d) {
        String string2 = PROP_UNIT_BASE_PRICE_KEY.replace("{name}", string);
        this.addProperty(string2, String.valueOf(d));
        return d;
    }

    public void removeUnitBasePrice(String string) {
        String string2 = PROP_UNIT_BASE_PRICE_KEY.replace("{name}", string);
        this.removeProperty(string2);
    }

    @XmlTransient
    @JsonIgnore
    public List<MenuItem> getActiveVariants() {
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        if (this.getVariants() != null) {
            for (MenuItem menuItem : this.getVariants()) {
                if (menuItem.isDeleted().booleanValue()) continue;
                arrayList.add(menuItem);
            }
        }
        return arrayList;
    }

    public boolean attributesEqual(MenuItem menuItem) {
        List<Attribute> list = this.getAttributes();
        List<Attribute> list2 = menuItem.getAttributes();
        if (list == null || list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (Attribute attribute : list) {
            if (list2.contains(attribute)) continue;
            return false;
        }
        return true;
    }

    public boolean hasSimilerGroupSpec(ModifierGroup modifierGroup) {
        List<MenuItemModifierSpec> list = this.getMenuItemModiferSpecs();
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (MenuItemModifierSpec menuItemModifierSpec : list) {
            if (!menuItemModifierSpec.getModifierGroup().getName().equals(modifierGroup.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasSimilerItemInOtherComboGroup(ComboGroup comboGroup, List<MenuItem> list) {
        List<ComboGroup> list2 = this.getComboGroups();
        if (list2 == null) {
            return false;
        }
        for (ComboGroup comboGroup2 : list2) {
            if (comboGroup == comboGroup2) continue;
            if (list == null || list.isEmpty()) {
                return false;
            }
            List<MenuItem> list3 = comboGroup2.getItems();
            if (list3 == null || list3.isEmpty()) {
                return false;
            }
            for (MenuItem menuItem : list3) {
                if (menuItem == null || StringUtils.isEmpty((String)menuItem.getId())) continue;
                for (MenuItem menuItem2 : list) {
                    if (menuItem2 == null || !StringUtils.isNotEmpty((String)menuItem2.getId()) || !menuItem.getId().equals(menuItem2.getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void clearNonExistingUnitBasePriceProperties(List<UnitBaseItemPrice> list) {
        try {
            List<String> list2 = this.getUnitBasePriceKeys();
            if (!this.isAllowUnitSelection() && !this.isAllowUnitWiseSelection()) {
                for (String string : list2) {
                    this.removeProperty(string);
                }
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list != null && !list.isEmpty()) {
                String string = PROP_UNIT_BASE_PRICE_KEY;
                for (UnitBaseItemPrice unitBaseItemPrice : list) {
                    String string2 = PROP_UNIT_BASE_PRICE_KEY.replace("{name}", unitBaseItemPrice.getUnitCode());
                    this.addProperty(string2, NumberUtil.formatNumber(unitBaseItemPrice.getPrice()));
                    arrayList.add(string2);
                }
            }
            if (list2.size() > 0) {
                for (String string : list2) {
                    if (arrayList.contains(string)) continue;
                    this.removeProperty(string);
                }
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    @JsonIgnore
    private List<String> getUnitBasePriceKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (this.properties != null && this.properties.length() > 0) {
                Set set = this.properties.keySet();
                for (String string : set) {
                    if (!string.startsWith("unit.") || !string.endsWith(".price")) continue;
                    arrayList.add(string);
                }
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return arrayList;
    }

    public double getItemCost() {
        double d = this.getCost();
        if (this.isVariant().booleanValue() && d == 0.0) {
            d = this.getParentMenuItem().getCost();
        }
        if (this.isComboItem().booleanValue()) {
            d = 0.0;
            List<ComboItem> list = this.getComboItems();
            for (ComboItem comboItem : list) {
                d += comboItem.getCost().doubleValue();
            }
        }
        return d;
    }

    public void setDeafultPizzaSize(String string) {
        this.addProperty("DeafultPizzaSize", string);
    }

    @XmlTransient
    @JsonIgnore
    public MenuItemSize getDeafultPizzaSize() {
        String string = this.getProperty("DeafultPizzaSize");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        return MenuItemSizeDAO.getInstance().get(string);
    }

    public void setDeafultPizzaCrust(String string) {
        this.addProperty("DeafultPizzaCrust", string);
    }

    @XmlTransient
    @JsonIgnore
    public PizzaCrust getDeafultPizzaCrust() {
        String string = this.getProperty("DeafultPizzaCrust");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        return PizzaCrustDAO.getInstance().get(string);
    }

    @XmlTransient
    @JsonIgnore
    public Double getCalculatedPrice() {
        return this.getPriceFromPriceRule(null);
    }

    public void setCalculatedPrice(Double d) {
    }

    @XmlTransient
    @JsonIgnore
    public Double getVariantPrice() {
        MenuItem menuItem;
        if (this.isVariant().booleanValue() && (menuItem = this.getParentMenuItem()) != null) {
            return menuItem.getPrice() + super.getPrice();
        }
        return super.getPrice();
    }

    public void setVariantPrice(Double d) {
    }

    @XmlTransient
    @JsonIgnore
    public Double getVariantCost() {
        MenuItem menuItem;
        Double d = super.getCost();
        if (d == 0.0 && this.isVariant().booleanValue() && (menuItem = this.getParentMenuItem()) != null) {
            return menuItem.getCost();
        }
        return d;
    }

    public void setVariantCost(Double d) {
    }

    @XmlTransient
    @JsonIgnore
    public double getProfitMargin() {
        double d = this.getVariantPrice() - this.getVariantCost();
        double d2 = Math.abs(this.getVariantPrice());
        if (d2 > 0.0) {
            return NumberUtil.round(d / d2 * 100.0);
        }
        return 0.0;
    }

    public void setProfitMargin(double d) {
    }

    public void setUnitWiseSelection(boolean bl) {
        this.addProperty("menuitem.allow_unit_wise_selection", String.valueOf(bl));
    }

    public boolean isAllowUnitWiseSelection() {
        return this.getBooleanProperty("menuitem.allow_unit_wise_selection", Boolean.FALSE);
    }

    public boolean isShowChildUnits() {
        return this.showChildUnits;
    }

    public void setShowChildUnits(boolean bl) {
        this.showChildUnits = bl;
    }

    public void setCustomerRequired(boolean bl) {
        this.addProperty("service.customerRequired", String.valueOf(bl));
    }

    @XmlTransient
    @JsonIgnore
    public boolean isCustomerRequired() {
        return this.getBooleanProperty("service.customerRequired", false);
    }

    public void setPaymentType(ServicePaymentType servicePaymentType) {
        this.addProperty("service.paymentType", servicePaymentType == null ? null : servicePaymentType.name());
    }

    @XmlTransient
    @JsonIgnore
    public ServicePaymentType getPaymentType() {
        String string = this.getProperty("service.paymentType");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        return ServicePaymentType.valueOf((String)string);
    }

    @JsonIgnore
    @XmlTransient
    public boolean isUnitWiseItem() {
        return this.unitWiseItem;
    }

    public void setUnitWiseItem(boolean bl) {
        this.unitWiseItem = bl;
    }

    public Double getOnlinePrice(String string) {
        if (this.isVariant().booleanValue()) {
            PriceTableItem priceTableItem = PriceTableItemDAO.getInstance().getItemByPriceTableId("menugreat_online_" + string, this);
            if (priceTableItem != null) {
                return priceTableItem.getPrice();
            }
            return this.getParentMenuItem() == null ? 0.0 : this.getParentMenuItem().getOnlinePrice(string) + this.getPrice();
        }
        PriceTableItem priceTableItem = PriceTableItemDAO.getInstance().getItemByPriceTableId("menugreat_online_" + string, this);
        if (priceTableItem != null) {
            return priceTableItem.getPrice();
        }
        return this.getPrice();
    }

    @XmlTransient
    @JsonIgnore
    public Integer getVariantSortOrder() {
        String string = this.getProperty("variantSortOrder");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        return POSUtil.parseInteger(string);
    }

    public void setVariantSortOrder(Integer n) {
        this.addProperty("variantSortOrder", String.valueOf(n));
    }
}

